/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.search.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.core.search.action.AsyncSearchResponse;
import org.elasticsearch.xpack.core.search.action.SearchStatusResponse;

public class AsyncStatusResponse
extends ActionResponse
implements SearchStatusResponse,
StatusToXContentObject {
    private final String id;
    private final boolean isRunning;
    private final boolean isPartial;
    private final long startTimeMillis;
    private final long expirationTimeMillis;
    private final int totalShards;
    private final int successfulShards;
    private final int skippedShards;
    private final int failedShards;
    private final RestStatus completionStatus;

    public AsyncStatusResponse(String id, boolean isRunning, boolean isPartial, long startTimeMillis, long expirationTimeMillis, int totalShards, int successfulShards, int skippedShards, int failedShards, RestStatus completionStatus) {
        this.id = id;
        this.isRunning = isRunning;
        this.isPartial = isPartial;
        this.startTimeMillis = startTimeMillis;
        this.expirationTimeMillis = expirationTimeMillis;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.skippedShards = skippedShards;
        this.failedShards = failedShards;
        this.completionStatus = completionStatus;
    }

    public static AsyncStatusResponse getStatusFromStoredSearch(AsyncSearchResponse asyncSearchResponse, long expirationTimeMillis, String id) {
        int totalShards = 0;
        int successfulShards = 0;
        int skippedShards = 0;
        int failedShards = 0;
        RestStatus completionStatus = null;
        SearchResponse searchResponse = asyncSearchResponse.getSearchResponse();
        if (searchResponse != null) {
            totalShards = searchResponse.getTotalShards();
            successfulShards = searchResponse.getSuccessfulShards();
            skippedShards = searchResponse.getSkippedShards();
            failedShards = searchResponse.getFailedShards();
        }
        if (!asyncSearchResponse.isRunning()) {
            if (searchResponse != null) {
                completionStatus = searchResponse.status();
            } else {
                Exception failure = asyncSearchResponse.getFailure();
                if (failure != null) {
                    completionStatus = ExceptionsHelper.status((Throwable)ExceptionsHelper.unwrapCause((Throwable)failure));
                }
            }
        }
        return new AsyncStatusResponse(id, asyncSearchResponse.isRunning(), asyncSearchResponse.isPartial(), asyncSearchResponse.getStartTime(), expirationTimeMillis, totalShards, successfulShards, skippedShards, failedShards, completionStatus);
    }

    public AsyncStatusResponse(StreamInput in) throws IOException {
        this.id = in.readString();
        this.isRunning = in.readBoolean();
        this.isPartial = in.readBoolean();
        this.startTimeMillis = in.readLong();
        this.expirationTimeMillis = in.readLong();
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        this.skippedShards = in.readVInt();
        this.failedShards = in.readVInt();
        this.completionStatus = !this.isRunning ? RestStatus.readFrom((StreamInput)in) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBoolean(this.isRunning);
        out.writeBoolean(this.isPartial);
        out.writeLong(this.startTimeMillis);
        out.writeLong(this.expirationTimeMillis);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.skippedShards);
        out.writeVInt(this.failedShards);
        if (!this.isRunning) {
            RestStatus.writeTo((StreamOutput)out, (RestStatus)this.completionStatus);
        }
    }

    public RestStatus status() {
        return RestStatus.OK;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("is_running", this.isRunning);
        builder.field("is_partial", this.isPartial);
        builder.timeField("start_time_in_millis", "start_time", this.startTimeMillis);
        builder.timeField("expiration_time_in_millis", "expiration_time", this.expirationTimeMillis);
        RestActions.buildBroadcastShardsHeader((XContentBuilder)builder, (ToXContent.Params)params, (int)this.totalShards, (int)this.successfulShards, (int)this.skippedShards, (int)this.failedShards, null);
        if (!this.isRunning) {
            builder.field("completion_status", this.completionStatus.getStatus());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncStatusResponse other = (AsyncStatusResponse)obj;
        return this.id.equals(other.id) && this.isRunning == other.isRunning && this.isPartial == other.isPartial && this.startTimeMillis == other.startTimeMillis && this.expirationTimeMillis == other.expirationTimeMillis && this.totalShards == other.totalShards && this.successfulShards == other.successfulShards && this.skippedShards == other.skippedShards && this.failedShards == other.failedShards && Objects.equals(this.completionStatus, other.completionStatus);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.isRunning, this.isPartial, this.startTimeMillis, this.expirationTimeMillis, this.totalShards, this.successfulShards, this.skippedShards, this.failedShards, this.completionStatus);
    }

    public String getId() {
        return this.id;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public long getStartTime() {
        return this.startTimeMillis;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTimeMillis;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getSkippedShards() {
        return this.skippedShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public RestStatus getCompletionStatus() {
        return this.completionStatus;
    }
}

