/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class GeoResults
implements ToXContentObject,
Writeable {
    public static final ParseField GEO_RESULTS = new ParseField("geo_results", new String[0]);
    public static final ParseField TYPICAL_POINT = new ParseField("typical_point", new String[0]);
    public static final ParseField ACTUAL_POINT = new ParseField("actual_point", new String[0]);
    public static final ObjectParser<GeoResults, Void> STRICT_PARSER = GeoResults.createParser(false);
    public static final ObjectParser<GeoResults, Void> LENIENT_PARSER = GeoResults.createParser(true);
    private String actualPoint;
    private String typicalPoint;

    private static ObjectParser<GeoResults, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(GEO_RESULTS.getPreferredName(), ignoreUnknownFields, GeoResults::new);
        parser.declareString(GeoResults::setActualPoint, ACTUAL_POINT);
        parser.declareString(GeoResults::setTypicalPoint, TYPICAL_POINT);
        return parser;
    }

    public GeoResults() {
    }

    public GeoResults(StreamInput in) throws IOException {
        this.actualPoint = in.readOptionalString();
        this.typicalPoint = in.readOptionalString();
    }

    public String getActualPoint() {
        return this.actualPoint;
    }

    public void setActualPoint(String actualPoint) {
        this.actualPoint = actualPoint;
    }

    public String getTypicalPoint() {
        return this.typicalPoint;
    }

    public void setTypicalPoint(String typicalPoint) {
        this.typicalPoint = typicalPoint;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.actualPoint);
        out.writeOptionalString(this.typicalPoint);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.typicalPoint != null) {
            builder.field(TYPICAL_POINT.getPreferredName(), this.typicalPoint);
        }
        if (this.actualPoint != null) {
            builder.field(ACTUAL_POINT.getPreferredName(), this.actualPoint);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.typicalPoint, this.actualPoint);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GeoResults that = (GeoResults)other;
        return Objects.equals(this.typicalPoint, that.typicalPoint) && Objects.equals(this.actualPoint, that.actualPoint);
    }
}

