/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedInferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.PredictionFieldType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.StrictlyParsedInferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;

public class ClassificationConfig
implements LenientlyParsedInferenceConfig,
StrictlyParsedInferenceConfig {
    public static final ParseField NAME = new ParseField("classification", new String[0]);
    public static final String DEFAULT_TOP_CLASSES_RESULTS_FIELD = "top_classes";
    public static final String DEFAULT_RESULTS_FIELD = "predicted_value";
    public static final ParseField RESULTS_FIELD = new ParseField("results_field", new String[0]);
    public static final ParseField NUM_TOP_CLASSES = new ParseField("num_top_classes", new String[0]);
    public static final ParseField TOP_CLASSES_RESULTS_FIELD = new ParseField("top_classes_results_field", new String[0]);
    public static final ParseField NUM_TOP_FEATURE_IMPORTANCE_VALUES = new ParseField("num_top_feature_importance_values", new String[0]);
    public static final ParseField PREDICTION_FIELD_TYPE = new ParseField("prediction_field_type", new String[0]);
    private static final Version MIN_SUPPORTED_VERSION = Version.V_7_6_0;
    public static ClassificationConfig EMPTY_PARAMS = new ClassificationConfig(0, "predicted_value", "top_classes", null, null);
    private final int numTopClasses;
    private final String topClassesResultsField;
    private final String resultsField;
    private final int numTopFeatureImportanceValues;
    private final PredictionFieldType predictionFieldType;
    private static final ObjectParser<Builder, Void> LENIENT_PARSER = ClassificationConfig.createParser(true);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = ClassificationConfig.createParser(false);

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME.getPreferredName(), lenient, Builder::new);
        parser.declareInt(Builder::setNumTopClasses, NUM_TOP_CLASSES);
        parser.declareString(Builder::setResultsField, RESULTS_FIELD);
        parser.declareString(Builder::setTopClassesResultsField, TOP_CLASSES_RESULTS_FIELD);
        parser.declareInt(Builder::setNumTopFeatureImportanceValues, NUM_TOP_FEATURE_IMPORTANCE_VALUES);
        parser.declareField(Builder::setPredictionFieldType, (p, c) -> {
            try {
                return PredictionFieldType.fromString(p.text());
            }
            catch (IllegalArgumentException iae) {
                if (lenient) {
                    return PredictionFieldType.STRING;
                }
                throw iae;
            }
        }, PREDICTION_FIELD_TYPE, ObjectParser.ValueType.STRING);
        return parser;
    }

    public static ClassificationConfig fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public static ClassificationConfig fromXContentLenient(XContentParser parser) {
        return ((Builder)LENIENT_PARSER.apply(parser, null)).build();
    }

    public ClassificationConfig(Integer numTopClasses) {
        this(numTopClasses, null, null, null, null);
    }

    public ClassificationConfig(Integer numTopClasses, String resultsField, String topClassesResultsField, Integer featureImportance, PredictionFieldType predictionFieldType) {
        this.numTopClasses = numTopClasses == null ? 0 : numTopClasses;
        this.topClassesResultsField = topClassesResultsField == null ? DEFAULT_TOP_CLASSES_RESULTS_FIELD : topClassesResultsField;
        String string = this.resultsField = resultsField == null ? DEFAULT_RESULTS_FIELD : resultsField;
        if (featureImportance != null && featureImportance < 0) {
            throw new IllegalArgumentException("[" + NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName() + "] must be greater than or equal to 0");
        }
        this.numTopFeatureImportanceValues = featureImportance == null ? 0 : featureImportance;
        this.predictionFieldType = predictionFieldType == null ? PredictionFieldType.STRING : predictionFieldType;
    }

    public ClassificationConfig(StreamInput in) throws IOException {
        this.numTopClasses = in.readInt();
        this.topClassesResultsField = in.readString();
        this.resultsField = in.readString();
        this.numTopFeatureImportanceValues = in.getVersion().onOrAfter(Version.V_7_7_0) ? in.readVInt() : 0;
        this.predictionFieldType = in.getVersion().onOrAfter(Version.V_7_8_0) ? PredictionFieldType.fromStream(in) : PredictionFieldType.STRING;
    }

    public int getNumTopClasses() {
        return this.numTopClasses;
    }

    public String getTopClassesResultsField() {
        return this.topClassesResultsField;
    }

    public String getResultsField() {
        return this.resultsField;
    }

    public int getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    public PredictionFieldType getPredictionFieldType() {
        return this.predictionFieldType;
    }

    @Override
    public boolean requestingImportance() {
        return this.numTopFeatureImportanceValues > 0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.numTopClasses);
        out.writeString(this.topClassesResultsField);
        out.writeString(this.resultsField);
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            out.writeVInt(this.numTopFeatureImportanceValues);
        }
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            this.predictionFieldType.writeTo(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassificationConfig that = (ClassificationConfig)o;
        return Objects.equals(this.numTopClasses, that.numTopClasses) && Objects.equals(this.topClassesResultsField, that.topClassesResultsField) && Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues) && Objects.equals((Object)this.predictionFieldType, (Object)that.predictionFieldType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.numTopClasses, this.topClassesResultsField, this.resultsField, this.numTopFeatureImportanceValues, this.predictionFieldType});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        builder.field(TOP_CLASSES_RESULTS_FIELD.getPreferredName(), this.topClassesResultsField);
        builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        builder.field(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        builder.field(PREDICTION_FIELD_TYPE.getPreferredName(), this.predictionFieldType.toString());
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return TargetType.CLASSIFICATION.equals((Object)targetType);
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return this.requestingImportance() ? Version.V_7_7_0 : MIN_SUPPORTED_VERSION;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer numTopClasses;
        private String topClassesResultsField;
        private String resultsField;
        private PredictionFieldType predictionFieldType;
        private Integer numTopFeatureImportanceValues;

        Builder() {
        }

        Builder(ClassificationConfig config) {
            this.numTopClasses = config.numTopClasses;
            this.topClassesResultsField = config.topClassesResultsField;
            this.resultsField = config.resultsField;
            this.numTopFeatureImportanceValues = config.numTopFeatureImportanceValues;
            this.predictionFieldType = config.predictionFieldType;
        }

        public Builder setNumTopClasses(Integer numTopClasses) {
            this.numTopClasses = numTopClasses;
            return this;
        }

        public Builder setTopClassesResultsField(String topClassesResultsField) {
            this.topClassesResultsField = topClassesResultsField;
            return this;
        }

        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        public Builder setPredictionFieldType(PredictionFieldType predictionFieldType) {
            this.predictionFieldType = predictionFieldType;
            return this;
        }

        public ClassificationConfig build() {
            return new ClassificationConfig(this.numTopClasses, this.resultsField, this.topClassesResultsField, this.numTopFeatureImportanceValues, this.predictionFieldType);
        }
    }
}

