/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.Step;

public class MoveToStepAction
extends ActionType<AcknowledgedResponse> {
    public static final MoveToStepAction INSTANCE = new MoveToStepAction();
    public static final String NAME = "cluster:admin/ilm/_move/post";

    protected MoveToStepAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        static final ParseField CURRENT_KEY_FIELD = new ParseField("current_step", new String[0]);
        static final ParseField NEXT_KEY_FIELD = new ParseField("next_step", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("move_to_step_request", false, (a, index) -> {
            Step.StepKey currentStepKey = (Step.StepKey)a[0];
            Step.StepKey nextStepKey = (Step.StepKey)a[1];
            return new Request((String)index, currentStepKey, nextStepKey);
        });
        private String index;
        private Step.StepKey currentStepKey;
        private Step.StepKey nextStepKey;

        public Request(String index, Step.StepKey currentStepKey, Step.StepKey nextStepKey) {
            this.index = index;
            this.currentStepKey = currentStepKey;
            this.nextStepKey = nextStepKey;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
            this.currentStepKey = new Step.StepKey(in);
            this.nextStepKey = new Step.StepKey(in);
        }

        public Request() {
        }

        public String getIndex() {
            return this.index;
        }

        public Step.StepKey getCurrentStepKey() {
            return this.currentStepKey;
        }

        public Step.StepKey getNextStepKey() {
            return this.nextStepKey;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public static Request parseRequest(String name, XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, (Object)name));
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            this.currentStepKey.writeTo(out);
            this.nextStepKey.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.currentStepKey, this.nextStepKey);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.index, other.index) && Objects.equals(this.currentStepKey, other.currentStepKey) && Objects.equals(this.nextStepKey, other.nextStepKey);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(CURRENT_KEY_FIELD.getPreferredName(), (ToXContent)this.currentStepKey).field(NEXT_KEY_FIELD.getPreferredName(), (ToXContent)this.nextStepKey).endObject();
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, name) -> Step.StepKey.parse(p), CURRENT_KEY_FIELD);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, name) -> Step.StepKey.parse(p), NEXT_KEY_FIELD);
        }
    }
}

