/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.Phase;

public class IndexLifecycleFeatureSetUsage
extends XPackFeatureSet.Usage {
    private List<PolicyStats> policyStats;

    public IndexLifecycleFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        if (input.readBoolean()) {
            this.policyStats = input.readList(PolicyStats::new);
        }
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_6_6_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        boolean hasPolicyStats = this.policyStats != null;
        out.writeBoolean(hasPolicyStats);
        if (hasPolicyStats) {
            out.writeList(this.policyStats);
        }
    }

    public IndexLifecycleFeatureSetUsage() {
        this((List<PolicyStats>)null);
    }

    public IndexLifecycleFeatureSetUsage(List<PolicyStats> policyStats) {
        super("ilm", true, true);
        this.policyStats = policyStats;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.policyStats != null) {
            builder.field("policy_count", this.policyStats.size());
            builder.field("policy_stats", this.policyStats);
        }
    }

    public List<PolicyStats> getPolicyStats() {
        return this.policyStats;
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.policyStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexLifecycleFeatureSetUsage other = (IndexLifecycleFeatureSetUsage)obj;
        return Objects.equals(this.available, other.available) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.policyStats, other.policyStats);
    }

    public static final class PhaseStats
    implements ToXContentObject,
    Writeable {
        private final String[] actionNames;
        private final TimeValue minimumAge;

        public PhaseStats(TimeValue after, String[] actionNames) {
            this.actionNames = actionNames;
            this.minimumAge = after;
        }

        public PhaseStats(StreamInput in) throws IOException {
            this.actionNames = in.readStringArray();
            this.minimumAge = in.readTimeValue();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.actionNames);
            out.writeTimeValue(this.minimumAge);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Phase.MIN_AGE.getPreferredName(), this.minimumAge.getMillis());
            builder.field(Phase.ACTIONS_FIELD.getPreferredName(), (Object)this.actionNames);
            builder.endObject();
            return builder;
        }

        public String[] getActionNames() {
            return this.actionNames;
        }

        public TimeValue getAfter() {
            return this.minimumAge;
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.actionNames), this.minimumAge);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PhaseStats other = (PhaseStats)obj;
            return Objects.equals(this.minimumAge, other.minimumAge) && Objects.deepEquals(this.actionNames, other.actionNames);
        }
    }

    public static final class PolicyStats
    implements ToXContentObject,
    Writeable {
        public static final ParseField INDICES_MANAGED_FIELD = new ParseField("indices_managed", new String[0]);
        private final Map<String, PhaseStats> phaseStats;
        private final int indicesManaged;

        public PolicyStats(Map<String, PhaseStats> phaseStats, int numberIndicesManaged) {
            this.phaseStats = phaseStats;
            this.indicesManaged = numberIndicesManaged;
        }

        public PolicyStats(StreamInput in) throws IOException {
            this.phaseStats = in.readMap(StreamInput::readString, PhaseStats::new);
            this.indicesManaged = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.phaseStats, StreamOutput::writeString, (o, p) -> p.writeTo(o));
            out.writeVInt(this.indicesManaged);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(LifecyclePolicy.PHASES_FIELD.getPreferredName(), this.phaseStats);
            builder.field(INDICES_MANAGED_FIELD.getPreferredName(), this.indicesManaged);
            builder.endObject();
            return builder;
        }

        public Map<String, PhaseStats> getPhaseStats() {
            return this.phaseStats;
        }

        public int getIndicesManaged() {
            return this.indicesManaged;
        }

        public int hashCode() {
            return Objects.hash(this.phaseStats, this.indicesManaged);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PolicyStats other = (PolicyStats)obj;
            return Objects.equals(this.phaseStats, other.phaseStats) && Objects.equals(this.indicesManaged, other.indicesManaged);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

