/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;

public class CreateSnapshotStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "create-snapshot";
    private static final Logger logger = LogManager.getLogger(CreateSnapshotStep.class);

    public CreateSnapshotStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    void performDuringNoSnapshot(IndexMetadata indexMetadata, ClusterState currentClusterState, ActionListener<Boolean> listener) {
        String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetadata);
        String policyName = indexMetadata.getSettings().get("index.lifecycle.name");
        String snapshotRepository = lifecycleState.getSnapshotRepository();
        if (!Strings.hasText((String)snapshotRepository)) {
            listener.onFailure((Exception)new IllegalStateException("snapshot repository is not present for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        String snapshotName = lifecycleState.getSnapshotName();
        if (!Strings.hasText((String)snapshotName)) {
            listener.onFailure((Exception)new IllegalStateException("snapshot name was not generated for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        CreateSnapshotRequest request = new CreateSnapshotRequest(snapshotRepository, snapshotName);
        request.indices(new String[]{indexName});
        request.waitForCompletion(true);
        request.includeGlobalState(false);
        request.masterNodeTimeout(TimeValue.MAX_VALUE);
        this.getClient().admin().cluster().createSnapshot(request, ActionListener.wrap(response -> {
            logger.debug("create snapshot response for policy [{}] and index [{}] is: {}", (Object)policyName, (Object)indexName, (Object)Strings.toString((ToXContent)response));
            SnapshotInfo snapInfo = response.getSnapshotInfo();
            if (snapInfo.failedShards() == 0) {
                listener.onResponse((Object)true);
            } else {
                int failures = snapInfo.failedShards();
                int total = snapInfo.totalShards();
                String message = String.format(Locale.ROOT, "failed to create snapshot successfully, %s failures out of %s total shards failed", failures, total);
                logger.warn(message);
                ElasticsearchException failure = new ElasticsearchException(message, (Throwable)snapInfo.shardFailures().stream().findFirst().orElse(null), new Object[0]);
                listener.onFailure((Exception)failure);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

