/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;

public class CleanupSnapshotStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "cleanup-snapshot";

    public CleanupSnapshotStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    void performDuringNoSnapshot(final IndexMetadata indexMetadata, ClusterState currentClusterState, final ActionListener<Boolean> listener) {
        final String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetadata);
        final String repositoryName = lifecycleState.getSnapshotRepository();
        if (!Strings.hasText((String)repositoryName)) {
            listener.onResponse((Object)true);
            return;
        }
        final String snapshotName = lifecycleState.getSnapshotName();
        if (!Strings.hasText((String)snapshotName)) {
            listener.onResponse((Object)true);
            return;
        }
        ((DeleteSnapshotRequestBuilder)this.getClient().admin().cluster().prepareDeleteSnapshot(repositoryName, new String[]{snapshotName}).setMasterNodeTimeout(TimeValue.MAX_VALUE)).execute((ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                if (!acknowledgedResponse.isAcknowledged()) {
                    String policyName = indexMetadata.getSettings().get("index.lifecycle.name");
                    throw new ElasticsearchException("cleanup snapshot step request for repository [" + repositoryName + "] and snapshot [" + snapshotName + "] policy [" + policyName + "] and index [" + indexName + "] failed to be acknowledged", new Object[0]);
                }
                listener.onResponse((Object)true);
            }

            public void onFailure(Exception e) {
                if (e instanceof SnapshotMissingException) {
                    listener.onResponse((Object)true);
                } else if (e instanceof RepositoryMissingException) {
                    String policyName = indexMetadata.getSettings().get("index.lifecycle.name");
                    listener.onFailure((Exception)new IllegalStateException("repository [" + repositoryName + "] is missing. [" + policyName + "] policy for index [" + indexName + "] cannot continue until the repository is created", e));
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }
}

