/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Step;

public class CleanupShrinkIndexStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "cleanup-shrink-index";
    private static final Logger logger = LogManager.getLogger(CleanupShrinkIndexStep.class);

    public CleanupShrinkIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    void performDuringNoSnapshot(IndexMetadata indexMetadata, ClusterState currentClusterState, final ActionListener<Boolean> listener) {
        String shrunkenIndexSource = (String)IndexMetadata.INDEX_RESIZE_SOURCE_NAME.get(indexMetadata.getSettings());
        if (!Strings.isNullOrEmpty((String)shrunkenIndexSource) && currentClusterState.metadata().index(shrunkenIndexSource) == null) {
            String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings());
            logger.warn("managed index [{}] as part of policy [{}] is a shrunk index and the source index [{}] does not exist anymore. will skip the [{}] step", (Object)indexMetadata.getIndex().getName(), (Object)policyName, (Object)shrunkenIndexSource, (Object)NAME);
            listener.onResponse((Object)true);
            return;
        }
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetadata);
        String shrinkIndexName = lifecycleState.getShrinkIndexName();
        if (!Strings.hasText((String)shrinkIndexName)) {
            listener.onResponse((Object)true);
            return;
        }
        this.getClient().admin().indices().delete((DeleteIndexRequest)new DeleteIndexRequest(shrinkIndexName).masterNodeTimeout(TimeValue.MAX_VALUE), (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                listener.onResponse((Object)true);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    listener.onResponse((Object)true);
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }
}

