/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class AsyncActionBranchingStep
extends AsyncActionStep {
    private final AsyncActionStep stepToExecute;
    private Step.StepKey nextKeyOnIncompleteResponse;
    private SetOnce<Boolean> onResponseResult;

    public AsyncActionBranchingStep(AsyncActionStep stepToExecute, Step.StepKey nextKeyOnIncompleteResponse, Client client) {
        super(stepToExecute.getKey(), null, client);
        this.stepToExecute = stepToExecute;
        this.nextKeyOnIncompleteResponse = nextKeyOnIncompleteResponse;
        this.onResponseResult = new SetOnce();
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentClusterState, ClusterStateObserver observer, final ActionListener<Boolean> listener) {
        this.stepToExecute.performAction(indexMetadata, currentClusterState, observer, new ActionListener<Boolean>(){

            public void onResponse(Boolean complete) {
                AsyncActionBranchingStep.this.onResponseResult.set((Object)complete);
                listener.onResponse((Object)complete);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    @Override
    public final Step.StepKey getNextStepKey() {
        if (this.onResponseResult.get() == null) {
            throw new IllegalStateException("cannot call getNextStepKey before performAction");
        }
        return (Boolean)this.onResponseResult.get() != false ? this.stepToExecute.getNextStepKey() : this.nextKeyOnIncompleteResponse;
    }

    AsyncActionStep getStepToExecute() {
        return this.stepToExecute;
    }

    Step.StepKey getNextKeyOnIncompleteResponse() {
        return this.nextKeyOnIncompleteResponse;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AsyncActionBranchingStep that = (AsyncActionBranchingStep)o;
        return super.equals(o) && Objects.equals(this.stepToExecute, that.stepToExecute) && Objects.equals(this.nextKeyOnIncompleteResponse, that.nextKeyOnIncompleteResponse);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.stepToExecute, this.nextKeyOnIncompleteResponse);
    }
}

