/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.util.Locale;
import java.util.OptionalLong;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xpack.ml.MachineLearning;

public final class NativeMemoryCalculator {
    private static final long STATIC_JVM_UPPER_THRESHOLD = ByteSizeValue.ofGb((long)2L).getBytes();
    static final long MINIMUM_AUTOMATIC_NODE_SIZE = ByteSizeValue.ofGb((long)1L).getBytes();
    private static final long OS_OVERHEAD = ByteSizeValue.ofMb((long)200L).getBytes();

    private NativeMemoryCalculator() {
    }

    public static OptionalLong allowedBytesForMl(DiscoveryNode node, Settings settings) {
        return NativeMemoryCalculator.allowedBytesForMl((String)node.getAttributes().get("ml.machine_memory"), (String)node.getAttributes().get("ml.max_jvm_size"), (int)((Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings)), (boolean)((Boolean)MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT.get(settings)));
    }

    public static OptionalLong allowedBytesForMl(DiscoveryNode node, ClusterSettings settings) {
        return NativeMemoryCalculator.allowedBytesForMl((String)node.getAttributes().get("ml.machine_memory"), (String)node.getAttributes().get("ml.max_jvm_size"), (int)((Integer)settings.get(MachineLearning.MAX_MACHINE_MEMORY_PERCENT)), (boolean)((Boolean)settings.get(MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT)));
    }

    public static OptionalLong allowedBytesForMl(DiscoveryNode node, int maxMemoryPercent, boolean useAutoPercent) {
        return NativeMemoryCalculator.allowedBytesForMl((String)node.getAttributes().get("ml.machine_memory"), (String)node.getAttributes().get("ml.max_jvm_size"), maxMemoryPercent, useAutoPercent);
    }

    private static OptionalLong allowedBytesForMl(String nodeBytes, String jvmBytes, int maxMemoryPercent, boolean useAuto) {
        long machineMemory;
        if (nodeBytes == null) {
            return OptionalLong.empty();
        }
        try {
            machineMemory = Long.parseLong(nodeBytes);
        }
        catch (NumberFormatException e) {
            return OptionalLong.empty();
        }
        Long jvmMemory = null;
        try {
            if (!Strings.isNullOrEmpty((String)jvmBytes)) {
                jvmMemory = Long.parseLong(jvmBytes);
            }
        }
        catch (NumberFormatException e) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(NativeMemoryCalculator.allowedBytesForMl(machineMemory, jvmMemory, maxMemoryPercent, useAuto));
    }

    public static long calculateApproxNecessaryNodeSize(long nativeMachineMemory, Long jvmSize, int maxMemoryPercent, boolean useAuto) {
        if (nativeMachineMemory == 0L) {
            return 0L;
        }
        if (useAuto) {
            if ((double)((jvmSize = Long.valueOf(jvmSize == null ? NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromNativeMemorySize(nativeMachineMemory) : jvmSize)) + OS_OVERHEAD) / (double)nativeMachineMemory > 0.1) {
                return Math.max(nativeMachineMemory + jvmSize + OS_OVERHEAD, MINIMUM_AUTOMATIC_NODE_SIZE);
            }
            return Math.round((double)nativeMachineMemory / 0.9);
        }
        return (long)(100.0 / (double)maxMemoryPercent * (double)nativeMachineMemory);
    }

    public static double modelMemoryPercent(long machineMemory, Long jvmSize, int maxMemoryPercent, boolean useAuto) {
        if (useAuto) {
            if (machineMemory - (jvmSize = Long.valueOf(jvmSize == null ? NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromNodeSize(machineMemory) : jvmSize)) < OS_OVERHEAD || machineMemory == 0L) {
                assert (false) : String.format(Locale.ROOT, "machine memory [%d] minus jvm [%d] is less than overhead [%d]", machineMemory, jvmSize, OS_OVERHEAD);
                return maxMemoryPercent;
            }
            return Math.min(90.0, (double)(machineMemory - jvmSize - OS_OVERHEAD) / (double)machineMemory * 100.0);
        }
        return maxMemoryPercent;
    }

    static long allowedBytesForMl(long machineMemory, Long jvmSize, int maxMemoryPercent, boolean useAuto) {
        if (useAuto && jvmSize != null) {
            if (machineMemory - jvmSize <= OS_OVERHEAD || machineMemory == 0L) {
                return machineMemory / 100L;
            }
            double memoryProportion = Math.min(0.9, (double)(machineMemory - jvmSize - OS_OVERHEAD) / (double)machineMemory);
            return Math.round((double)machineMemory * memoryProportion);
        }
        return (long)((double)machineMemory * ((double)maxMemoryPercent / 100.0));
    }

    public static long allowedBytesForMl(long machineMemory, int maxMemoryPercent, boolean useAuto) {
        return NativeMemoryCalculator.allowedBytesForMl(machineMemory, useAuto ? NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromNodeSize(machineMemory) : machineMemory / 2L, maxMemoryPercent, useAuto);
    }

    public static long dynamicallyCalculateJvmSizeFromNodeSize(long nodeSize) {
        if (nodeSize < ByteSizeValue.ofMb((long)1280L).getBytes()) {
            return (long)((double)nodeSize * 0.4);
        }
        if (nodeSize < ByteSizeValue.ofGb((long)8L).getBytes()) {
            return (long)((double)nodeSize * 0.25);
        }
        return STATIC_JVM_UPPER_THRESHOLD;
    }

    public static long dynamicallyCalculateJvmSizeFromNativeMemorySize(long nativeMachineMemory) {
        long nativeAndOverhead = nativeMachineMemory + OS_OVERHEAD;
        if ((double)nativeAndOverhead < (double)ByteSizeValue.ofGb((long)2L).getBytes() * 0.6) {
            return Math.round((double)nativeAndOverhead / 0.6 * 0.4);
        }
        if ((double)nativeAndOverhead < (double)ByteSizeValue.ofGb((long)8L).getBytes() * 0.75) {
            return Math.round((double)nativeAndOverhead / 0.75 * 0.25);
        }
        return STATIC_JVM_UPPER_THRESHOLD;
    }
}

