/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.process;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ml.process.ControllerResponse;
import org.elasticsearch.xpack.ml.process.ProcessPipes;
import org.elasticsearch.xpack.ml.process.ProcessResultsParser;
import org.elasticsearch.xpack.ml.process.logging.CppLogMessageHandler;
import org.elasticsearch.xpack.ml.utils.NamedPipeHelper;

public class NativeController {
    private static final Logger LOGGER = LogManager.getLogger(NativeController.class);
    private static final String CONTROLLER = "controller";
    private static final Duration CONTROLLER_CONNECT_TIMEOUT = Duration.ofSeconds(10L);
    private static final String START_COMMAND = "start";
    private static final String KILL_COMMAND = "kill";
    public static final Map<String, Object> UNKNOWN_NATIVE_CODE_INFO;
    private final String localNodeName;
    private final CppLogMessageHandler cppLogHandler;
    private final OutputStream commandStream;
    private final InputStream responseStream;
    private final NamedXContentRegistry xContentRegistry;
    private final Map<Integer, ResponseTracker> responseTrackers = new ConcurrentHashMap<Integer, ResponseTracker>();
    private final SetOnce<Iterator<ControllerResponse>> responseIteratorHolder = new SetOnce();
    private int nextCommandId = 1;

    NativeController(String localNodeName, Environment env, NamedPipeHelper namedPipeHelper, NamedXContentRegistry xContentRegistry) throws IOException {
        this.localNodeName = localNodeName;
        ProcessPipes processPipes = new ProcessPipes(env, namedPipeHelper, CONTROLLER_CONNECT_TIMEOUT, CONTROLLER, null, null, true, false, true, false, false);
        processPipes.connectLogStream();
        this.cppLogHandler = processPipes.getLogStreamHandler();
        NativeController.tailLogsInThread(this.cppLogHandler);
        processPipes.connectOtherStreams();
        this.commandStream = new BufferedOutputStream(processPipes.getCommandStream().get());
        this.responseStream = processPipes.getProcessOutStream().get();
        this.xContentRegistry = xContentRegistry;
    }

    static void tailLogsInThread(CppLogMessageHandler cppLogHandler) {
        Thread logTailThread = new Thread(() -> {
            try (CppLogMessageHandler h = cppLogHandler;){
                h.tailStream();
            }
            catch (IOException e) {
                LOGGER.error("Error tailing C++ controller logs", (Throwable)e);
            }
            LOGGER.info("Native controller process has stopped - no new native processes can be started");
        }, "ml-cpp-log-tail-thread");
        logTailThread.setDaemon(true);
        logTailThread.start();
    }

    public long getPid() throws TimeoutException {
        return this.cppLogHandler.getPid(CONTROLLER_CONNECT_TIMEOUT);
    }

    public Map<String, Object> getNativeCodeInfo() throws TimeoutException {
        return this.cppLogHandler.getNativeCodeInfo(CONTROLLER_CONNECT_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess(List<String> command) throws IOException, InterruptedException {
        if (command.isEmpty()) {
            throw new IllegalArgumentException("Cannot start process: no command supplied");
        }
        for (String arg : command) {
            if (arg.contains("\t")) {
                throw new IllegalArgumentException("argument contains a tab character: " + arg + " in " + command);
            }
            if (!arg.contains("\n")) continue;
            throw new IllegalArgumentException("argument contains a newline character: " + arg + " in " + command);
        }
        if (this.cppLogHandler.hasLogStreamEnded()) {
            String msg = "Cannot start process [" + command.get(0) + "]: native controller process has stopped on node [" + this.localNodeName + "]";
            LOGGER.error(msg);
            throw new ElasticsearchException(msg, new Object[0]);
        }
        int commandId = -1;
        try {
            OutputStream outputStream = this.commandStream;
            synchronized (outputStream) {
                commandId = this.nextCommandId++;
                this.setupResponseTracker(commandId);
                LOGGER.debug("Command [{}]: starting process with command {}", (Object)commandId, command);
                this.commandStream.write(Integer.toString(commandId).getBytes(StandardCharsets.UTF_8));
                this.commandStream.write(9);
                this.commandStream.write(START_COMMAND.getBytes(StandardCharsets.UTF_8));
                for (String arg : command) {
                    this.commandStream.write(9);
                    this.commandStream.write(arg.getBytes(StandardCharsets.UTF_8));
                }
                this.commandStream.write(10);
                this.commandStream.flush();
            }
            this.awaitCompletion(commandId);
        }
        finally {
            this.removeResponseTracker(commandId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killProcess(long pid, boolean awaitCompletion) throws TimeoutException, IOException, InterruptedException {
        if (pid <= 0L) {
            throw new IllegalArgumentException("invalid PID to kill: " + pid);
        }
        if (pid == this.getPid()) {
            throw new IllegalArgumentException("native controller will not kill self: " + pid);
        }
        if (this.cppLogHandler.hasLogStreamEnded()) {
            String msg = "Cannot kill process with PID [" + pid + "]: native controller process has stopped on node [" + this.localNodeName + "]";
            LOGGER.error(msg);
            throw new ElasticsearchException(msg, new Object[0]);
        }
        int commandId = -1;
        try {
            OutputStream outputStream = this.commandStream;
            synchronized (outputStream) {
                commandId = this.nextCommandId++;
                if (awaitCompletion) {
                    this.setupResponseTracker(commandId);
                }
                LOGGER.debug("Command [{}]: killing process with PID [{}]", (Object)commandId, (Object)pid);
                this.commandStream.write(Integer.toString(commandId).getBytes(StandardCharsets.UTF_8));
                this.commandStream.write(9);
                this.commandStream.write(KILL_COMMAND.getBytes(StandardCharsets.UTF_8));
                this.commandStream.write(9);
                this.commandStream.write(Long.toString(pid).getBytes(StandardCharsets.UTF_8));
                this.commandStream.write(10);
                this.commandStream.flush();
            }
            if (awaitCompletion) {
                this.awaitCompletion(commandId);
            }
        }
        finally {
            if (awaitCompletion) {
                this.removeResponseTracker(commandId);
            }
        }
    }

    public void stop() throws IOException {
        this.commandStream.close();
    }

    private void setupResponseTracker(int commandId) {
        ResponseTracker tracker = new ResponseTracker();
        ResponseTracker previous = this.responseTrackers.put(commandId, tracker);
        assert (previous == null);
    }

    private void removeResponseTracker(int commandId) {
        this.responseTrackers.remove(commandId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitCompletion(int commandId) throws IOException, InterruptedException {
        ResponseTracker ourResponseTracker = this.responseTrackers.get(commandId);
        assert (ourResponseTracker != null);
        if (!ourResponseTracker.hasResponded()) {
            SetOnce<Iterator<ControllerResponse>> setOnce = this.responseIteratorHolder;
            synchronized (setOnce) {
                Iterator<ControllerResponse> responseIterator = (Iterator<ControllerResponse>)this.responseIteratorHolder.get();
                if (responseIterator == null) {
                    responseIterator = new ProcessResultsParser<ControllerResponse>(ControllerResponse.PARSER, this.xContentRegistry).parseResults(this.responseStream);
                    this.responseIteratorHolder.set(responseIterator);
                }
                while (!ourResponseTracker.hasResponded()) {
                    if (!responseIterator.hasNext()) {
                        throw new IOException("ML controller response stream ended while awaiting response for command [" + commandId + "]");
                    }
                    ControllerResponse response = (ControllerResponse)responseIterator.next();
                    ResponseTracker respondedTracker = this.responseTrackers.get(response.getCommandId());
                    if (respondedTracker == null) continue;
                    respondedTracker.setResponse(response);
                }
            }
        }
        ControllerResponse ourResponse = ourResponseTracker.getResponse();
        assert (ourResponse.getCommandId() == commandId);
        if (!ourResponse.isSuccess()) {
            throw new IOException("ML controller failed to execute command [" + commandId + "]: [" + ourResponse.getReason() + "]");
        }
        LOGGER.debug("ML controller successfully executed command [" + commandId + "]: [" + ourResponse.getReason() + "]");
    }

    static {
        HashMap<String, String> unknownInfo = new HashMap<String, String>(2);
        unknownInfo.put("version", "N/A");
        unknownInfo.put("build_hash", "N/A");
        UNKNOWN_NATIVE_CODE_INFO = Collections.unmodifiableMap(unknownInfo);
    }

    private static class ResponseTracker {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final SetOnce<ControllerResponse> responseHolder = new SetOnce();

        private ResponseTracker() {
        }

        boolean hasResponded() {
            return this.latch.getCount() < 1L;
        }

        void setResponse(ControllerResponse response) {
            this.responseHolder.set((Object)response);
            this.latch.countDown();
        }

        ControllerResponse getResponse() throws InterruptedException {
            this.latch.await();
            return (ControllerResponse)this.responseHolder.get();
        }
    }
}

