/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.task;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.decider.EnableAssignmentDecider;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.ResetJobAction;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.job.config.Blocked;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.JobNodeSelector;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.task.JobTask;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.task.AbstractJobPersistentTasksExecutor;

public class OpenJobPersistentTasksExecutor
extends AbstractJobPersistentTasksExecutor<OpenJobAction.JobParams> {
    private static final Logger logger = LogManager.getLogger(OpenJobPersistentTasksExecutor.class);
    private static final Version MIN_MASTER_NODE_VERSION_FOR_REVERTING_TO_CURRENT_SNAPSHOT = Version.V_7_11_0;
    private final AutodetectProcessManager autodetectProcessManager;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final Client client;
    private final JobResultsProvider jobResultsProvider;
    private final AnomalyDetectionAuditor auditor;
    private volatile ClusterState clusterState;

    public static String[] indicesOfInterest(String resultsIndex) {
        if (resultsIndex == null) {
            return new String[]{AnomalyDetectorsIndex.jobStateIndexPattern(), MlMetaIndex.indexName(), MlConfigIndex.indexName()};
        }
        return new String[]{AnomalyDetectorsIndex.jobStateIndexPattern(), resultsIndex, MlMetaIndex.indexName(), MlConfigIndex.indexName()};
    }

    public OpenJobPersistentTasksExecutor(Settings settings, ClusterService clusterService, AutodetectProcessManager autodetectProcessManager, DatafeedConfigProvider datafeedConfigProvider, MlMemoryTracker memoryTracker, Client client, IndexNameExpressionResolver expressionResolver) {
        super("xpack/ml/job", "ml_utility", settings, clusterService, memoryTracker, expressionResolver);
        this.autodetectProcessManager = Objects.requireNonNull(autodetectProcessManager);
        this.datafeedConfigProvider = Objects.requireNonNull(datafeedConfigProvider);
        this.client = Objects.requireNonNull(client);
        this.jobResultsProvider = new JobResultsProvider(client, settings, expressionResolver);
        this.auditor = new AnomalyDetectionAuditor(client, clusterService);
        clusterService.addListener(event -> {
            this.clusterState = event.state();
        });
    }

    public PersistentTasksCustomMetadata.Assignment getAssignment(OpenJobAction.JobParams params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState) {
        Job job = params.getJob();
        if (job == null) {
            return AWAITING_MIGRATION;
        }
        boolean isMemoryTrackerRecentlyRefreshed = this.memoryTracker.isRecentlyRefreshed();
        Optional<PersistentTasksCustomMetadata.Assignment> optionalAssignment = this.getPotentialAssignment(params, clusterState, isMemoryTrackerRecentlyRefreshed);
        if (optionalAssignment.isPresent()) {
            return optionalAssignment.get();
        }
        JobNodeSelector jobNodeSelector = new JobNodeSelector(clusterState, candidateNodes, params.getJobId(), "xpack/ml/job", this.memoryTracker, job.allowLazyOpen() ? Integer.MAX_VALUE : this.maxLazyMLNodes, node -> OpenJobPersistentTasksExecutor.nodeFilter(node, job));
        PersistentTasksCustomMetadata.Assignment assignment = jobNodeSelector.selectNode(this.maxOpenJobs, this.maxConcurrentJobAllocations, this.maxMachineMemoryPercent, this.maxNodeMemory, this.useAutoMemoryPercentage);
        this.auditRequireMemoryIfNecessary(params.getJobId(), this.auditor, assignment, jobNodeSelector, isMemoryTrackerRecentlyRefreshed);
        return assignment;
    }

    private static boolean nodeSupportsModelSnapshotVersion(DiscoveryNode node, Job job) {
        if (job.getModelSnapshotId() == null || job.getModelSnapshotMinVersion() == null) {
            return true;
        }
        return node.getVersion().onOrAfter(job.getModelSnapshotMinVersion());
    }

    public static String nodeFilter(DiscoveryNode node, Job job) {
        String jobId = job.getId();
        if (!OpenJobPersistentTasksExecutor.nodeSupportsModelSnapshotVersion(node, job)) {
            return "Not opening job [" + jobId + "] on node [" + JobNodeSelector.nodeNameAndVersion(node) + "], because the job's model snapshot requires a node of version [" + job.getModelSnapshotMinVersion() + "] or higher";
        }
        if (!Job.getCompatibleJobTypes((Version)node.getVersion()).contains(job.getJobType())) {
            return "Not opening job [" + jobId + "] on node [" + JobNodeSelector.nodeNameAndVersion(node) + "], because this node does not support jobs of type [" + job.getJobType() + "]";
        }
        return null;
    }

    static void validateJobAndId(String jobId, Job job) {
        if (job == null) {
            throw ExceptionsHelper.missingJobException((String)jobId);
        }
        if (job.getBlocked().getReason() != Blocked.Reason.NONE) {
            throw ExceptionsHelper.conflictStatusException((String)"Cannot open job [{}] because it is executing [{}]", (Object[])new Object[]{jobId, job.getBlocked().getReason()});
        }
        if (job.getJobVersion() == null) {
            throw ExceptionsHelper.badRequestException((String)"Cannot open job [{}] because jobs created prior to version 5.5 are not supported", (Object[])new Object[]{jobId});
        }
    }

    public void validate(OpenJobAction.JobParams params, ClusterState clusterState) {
        Job job = params.getJob();
        String jobId = params.getJobId();
        OpenJobPersistentTasksExecutor.validateJobAndId(jobId, job);
        PersistentTasksCustomMetadata.Assignment assignment = this.getAssignment(params, (Collection<DiscoveryNode>)clusterState.nodes().getAllNodes(), clusterState);
        if (assignment.equals((Object)MlTasks.AWAITING_UPGRADE)) {
            throw OpenJobPersistentTasksExecutor.makeCurrentlyBeingUpgradedException(logger, params.getJobId());
        }
        if (assignment.getExecutorNode() == null && !assignment.equals((Object)JobNodeSelector.AWAITING_LAZY_ASSIGNMENT)) {
            throw OpenJobPersistentTasksExecutor.makeNoSuitableNodesException(logger, params.getJobId(), assignment.getExplanation());
        }
    }

    protected void nodeOperation(AllocatedPersistentTask task, OpenJobAction.JobParams params, PersistentTaskState state) {
        JobTask jobTask = (JobTask)task;
        jobTask.setAutodetectProcessManager(this.autodetectProcessManager);
        JobTaskState jobTaskState = (JobTaskState)state;
        JobState jobState = jobTaskState == null ? null : jobTaskState.getState();
        ActionListener resultsMappingUpdateHandler = ActionListener.wrap(mappingsUpdate -> this.jobResultsProvider.setRunningForecastsToFailed(params.getJobId(), (ActionListener<Boolean>)ActionListener.wrap(r -> this.runJob(jobTask, jobState, params), e -> {
            logger.warn((Message)new ParameterizedMessage("[{}] failed to set forecasts to failed", (Object)params.getJobId()), (Throwable)e);
            this.runJob(jobTask, jobState, params);
        })), e -> {
            logger.error((Message)new ParameterizedMessage("[{}] Failed to update results mapping", (Object)params.getJobId()), (Throwable)e);
            jobTask.markAsFailed((Exception)e);
        });
        ElasticsearchMappings.addDocMappingIfMissing((String)AnomalyDetectorsIndex.jobResultsAliasedName((String)params.getJobId()), AnomalyDetectorsIndex::wrappedResultsMapping, (Client)this.client, (ClusterState)this.clusterState, (TimeValue)MlTasks.PERSISTENT_TASK_MASTER_NODE_TIMEOUT, (ActionListener)resultsMappingUpdateHandler);
    }

    private void runJob(JobTask jobTask, JobState jobState, OpenJobAction.JobParams params) {
        if (JobState.CLOSING.equals((Object)jobState)) {
            logger.info("[{}] job got reassigned while stopping. Marking as completed", (Object)params.getJobId());
            jobTask.markAsCompleted();
            return;
        }
        if (JobState.FAILED.equals((Object)jobState)) {
            return;
        }
        ActionListener hasRunningDatafeedTaskListener = ActionListener.wrap(hasRunningDatafeed -> {
            if (hasRunningDatafeed.booleanValue() && this.isMasterNodeVersionOnOrAfter(MIN_MASTER_NODE_VERSION_FOR_REVERTING_TO_CURRENT_SNAPSHOT)) {
                this.revertToCurrentSnapshot(jobTask.getJobId(), (ActionListener<Boolean>)ActionListener.wrap(response -> this.openJob(jobTask), arg_0 -> ((JobTask)jobTask).markAsFailed(arg_0)));
            } else {
                this.openJob(jobTask);
            }
        }, arg_0 -> ((JobTask)jobTask).markAsFailed(arg_0));
        this.hasRunningDatafeedTask(jobTask.getJobId(), (ActionListener<Boolean>)hasRunningDatafeedTaskListener);
    }

    private boolean isMasterNodeVersionOnOrAfter(Version version) {
        return this.clusterState.nodes().getMasterNode().getVersion().onOrAfter(version);
    }

    private void hasRunningDatafeedTask(String jobId, ActionListener<Boolean> listener) {
        ActionListener datafeedListener = ActionListener.wrap(datafeeds -> {
            PersistentTasksCustomMetadata tasks;
            assert (datafeeds.size() <= 1);
            if (datafeeds.isEmpty()) {
                listener.onResponse((Object)false);
                return;
            }
            String datafeedId = (String)datafeeds.iterator().next();
            PersistentTasksCustomMetadata.PersistentTask datafeedTask = MlTasks.getDatafeedTask((String)datafeedId, (PersistentTasksCustomMetadata)(tasks = (PersistentTasksCustomMetadata)this.clusterState.getMetadata().custom("persistent_tasks")));
            listener.onResponse((Object)(datafeedTask != null ? 1 : 0));
        }, arg_0 -> listener.onFailure(arg_0));
        this.datafeedConfigProvider.findDatafeedsForJobIds(Collections.singleton(jobId), (ActionListener<Set<String>>)datafeedListener);
    }

    private void revertToCurrentSnapshot(String jobId, ActionListener<Boolean> listener) {
        ActionListener jobListener = ActionListener.wrap(jobResponse -> {
            List jobPage = jobResponse.getResponse().results();
            assert (jobPage.size() == 1);
            String jobSnapshotId = ((Job)jobPage.get(0)).getModelSnapshotId();
            if (jobSnapshotId == null && this.isMasterNodeVersionOnOrAfter(ResetJobAction.VERSION_INTRODUCED)) {
                logger.info("[{}] job has running datafeed task; resetting as no snapshot exists", (Object)jobId);
                ResetJobAction.Request request = new ResetJobAction.Request(jobId);
                request.setSkipJobStateValidation(true);
                request.masterNodeTimeout(MlTasks.PERSISTENT_TASK_MASTER_NODE_TIMEOUT);
                request.timeout(MlTasks.PERSISTENT_TASK_MASTER_NODE_TIMEOUT);
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)ResetJobAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> listener.onResponse((Object)true), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                logger.info("[{}] job has running datafeed task; reverting to current snapshot", (Object)jobId);
                RevertModelSnapshotAction.Request request = new RevertModelSnapshotAction.Request(jobId, jobSnapshotId == null ? ModelSnapshot.EMPTY_SNAPSHOT_ID : jobSnapshotId);
                request.setForce(true);
                request.setDeleteInterveningResults(true);
                request.masterNodeTimeout(MlTasks.PERSISTENT_TASK_MASTER_NODE_TIMEOUT);
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)RevertModelSnapshotAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> listener.onResponse((Object)true), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, error -> listener.onFailure((Exception)ExceptionsHelper.serverError((String)"[{}] error getting job", (Throwable)error, (Object[])new Object[]{jobId})));
        GetJobsAction.Request request = new GetJobsAction.Request(jobId);
        request.masterNodeTimeout(MlTasks.PERSISTENT_TASK_MASTER_NODE_TIMEOUT);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetJobsAction.INSTANCE, (ActionRequest)request, (ActionListener)jobListener);
    }

    private void openJob(JobTask jobTask) {
        String jobId = jobTask.getJobId();
        this.autodetectProcessManager.openJob(jobTask, this.clusterState, MlTasks.PERSISTENT_TASK_MASTER_NODE_TIMEOUT, (e2, shouldFinalizeJob) -> {
            if (e2 == null) {
                if (shouldFinalizeJob.booleanValue()) {
                    FinalizeJobExecutionAction.Request finalizeRequest = new FinalizeJobExecutionAction.Request(new String[]{jobId});
                    finalizeRequest.masterNodeTimeout(MlTasks.PERSISTENT_TASK_MASTER_NODE_TIMEOUT);
                    ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)FinalizeJobExecutionAction.INSTANCE, (ActionRequest)finalizeRequest, (ActionListener)ActionListener.wrap(response -> jobTask.markAsCompleted(), e -> {
                        logger.error((Message)new ParameterizedMessage("[{}] error finalizing job", (Object)jobId), (Throwable)e);
                        Throwable unwrapped = ExceptionsHelper.unwrapCause((Throwable)e);
                        if (unwrapped instanceof DocumentMissingException || unwrapped instanceof ResourceNotFoundException) {
                            jobTask.markAsCompleted();
                        } else {
                            jobTask.markAsFailed((Exception)e);
                        }
                    }));
                } else {
                    jobTask.markAsCompleted();
                }
            } else {
                jobTask.markAsFailed((Exception)e2);
            }
        });
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<OpenJobAction.JobParams> persistentTask, Map<String, String> headers) {
        return new JobTask(((OpenJobAction.JobParams)persistentTask.getParams()).getJobId(), id, type, action, parentTaskId, headers);
    }

    public static Optional<ElasticsearchException> checkAssignmentState(PersistentTasksCustomMetadata.Assignment assignment, String jobId, Logger logger) {
        if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetadata.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
            if (assignment.equals((Object)MlTasks.AWAITING_UPGRADE)) {
                return Optional.of(OpenJobPersistentTasksExecutor.makeCurrentlyBeingUpgradedException(logger, jobId));
            }
            if (assignment.getExplanation().contains("[no persistent task assignments are allowed due to cluster settings]")) {
                return Optional.of(OpenJobPersistentTasksExecutor.makeAssignmentsNotAllowedException(logger, jobId));
            }
            return Optional.of(OpenJobPersistentTasksExecutor.makeNoSuitableNodesException(logger, jobId, assignment.getExplanation()));
        }
        return Optional.empty();
    }

    static ElasticsearchException makeNoSuitableNodesException(Logger logger, String jobId, String explanation) {
        String msg = "Could not open job because no suitable nodes were found, allocation explanation [" + explanation + "]";
        logger.warn("[{}] {}", (Object)jobId, (Object)msg);
        IllegalStateException detail = new IllegalStateException(msg);
        return new ElasticsearchStatusException("Could not open job because no ML nodes with sufficient capacity were found", RestStatus.TOO_MANY_REQUESTS, (Throwable)detail, new Object[0]);
    }

    static ElasticsearchException makeAssignmentsNotAllowedException(Logger logger, String jobId) {
        String msg = "Cannot open jobs because persistent task assignment is disabled by the [" + EnableAssignmentDecider.CLUSTER_TASKS_ALLOCATION_ENABLE_SETTING.getKey() + "] setting";
        logger.warn("[{}] {}", (Object)jobId, (Object)msg);
        return new ElasticsearchStatusException(msg, RestStatus.TOO_MANY_REQUESTS, new Object[0]);
    }

    static ElasticsearchException makeCurrentlyBeingUpgradedException(Logger logger, String jobId) {
        String msg = "Cannot open jobs when upgrade mode is enabled";
        logger.warn("[{}] {}", (Object)jobId, (Object)msg);
        return new ElasticsearchStatusException(msg, RestStatus.TOO_MANY_REQUESTS, new Object[0]);
    }

    @Override
    protected String[] indicesOfInterest(OpenJobAction.JobParams params) {
        return OpenJobPersistentTasksExecutor.indicesOfInterest(AnomalyDetectorsIndex.resultsWriteAlias((String)params.getJobId()));
    }

    @Override
    protected String getJobId(OpenJobAction.JobParams params) {
        return params.getJobId();
    }
}

