/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.ml.job.process.ProcessBuilderUtils;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectBuilder;

public class NormalizerBuilder {
    public static final String NORMALIZE = "normalize";
    static final String NORMALIZE_PATH = "./normalize";
    public static final String BUCKET_SPAN_ARG = "--bucketspan=";
    private final Environment env;
    private final String jobId;
    private final String quantilesState;
    private final Integer bucketSpan;

    public NormalizerBuilder(Environment env, String jobId, String quantilesState, Integer bucketSpan) {
        this.env = env;
        this.jobId = jobId;
        this.quantilesState = quantilesState;
        this.bucketSpan = bucketSpan;
    }

    public List<String> build() throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(NORMALIZE_PATH);
        ProcessBuilderUtils.addIfNotNull(this.bucketSpan, BUCKET_SPAN_ARG, command);
        command.add("--lengthEncodedInput");
        if (this.quantilesState != null) {
            Path quantilesStateFilePath = AutodetectBuilder.writeNormalizerInitState(this.jobId, this.quantilesState, this.env);
            String stateFileArg = "--quantilesState=" + quantilesStateFilePath;
            command.add(stateFileArg);
            command.add("--deleteStateFiles");
        }
        if (ProcessBuilderUtils.modelConfigFilePresent(this.env)) {
            String modelConfigFile = XPackPlugin.resolveConfigFile((Environment)this.env, (String)"mlmodel.conf").toString();
            command.add("--modelconfig=" + modelConfigFile);
        }
        return command;
    }
}

