/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.modelsize;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.FrequencyEncoding;
import org.elasticsearch.xpack.ml.inference.modelsize.PreprocessorSize;
import org.elasticsearch.xpack.ml.inference.modelsize.SizeEstimatorHelper;

public class FrequencyEncodingSize
implements PreprocessorSize {
    private static final ConstructingObjectParser<FrequencyEncodingSize, Void> PARSER = new ConstructingObjectParser("frequency_encoding_size", false, a -> new FrequencyEncodingSize((Integer)a[0], (Integer)a[1], (List)a[2]));
    private final int fieldLength;
    private final int featureNameLength;
    private final int[] fieldValueLengths;

    public static FrequencyEncodingSize fromXContent(XContentParser parser) {
        return (FrequencyEncodingSize)PARSER.apply(parser, null);
    }

    FrequencyEncodingSize(int fieldLength, int featureNameLength, List<Integer> fieldValueLengths) {
        this.fieldLength = fieldLength;
        this.featureNameLength = featureNameLength;
        this.fieldValueLengths = fieldValueLengths.stream().mapToInt(Integer::intValue).toArray();
    }

    public long ramBytesUsed() {
        long sizeOfDoubleObject = RamUsageEstimator.shallowSizeOfInstance(Double.class);
        long size = FrequencyEncoding.SHALLOW_SIZE;
        size += SizeEstimatorHelper.sizeOfString(this.fieldLength);
        size += SizeEstimatorHelper.sizeOfString(this.featureNameLength);
        return RamUsageEstimator.alignObjectSize((long)(size += SizeEstimatorHelper.sizeOfHashMap(Arrays.stream(this.fieldValueLengths).mapToLong(SizeEstimatorHelper::sizeOfString).boxed().collect(Collectors.toList()), Stream.generate(() -> sizeOfDoubleObject).limit(this.fieldValueLengths.length).collect(Collectors.toList()))));
    }

    @Override
    public String getName() {
        return FrequencyEncoding.NAME.getPreferredName();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD_LENGTH.getPreferredName(), this.fieldLength);
        builder.field(FEATURE_NAME_LENGTH.getPreferredName(), this.featureNameLength);
        builder.field(FIELD_VALUE_LENGTHS.getPreferredName(), (Object)this.fieldValueLengths);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrequencyEncodingSize that = (FrequencyEncodingSize)o;
        return this.fieldLength == that.fieldLength && this.featureNameLength == that.featureNameLength && Arrays.equals(this.fieldValueLengths, that.fieldValueLengths);
    }

    public int hashCode() {
        int result = Objects.hash(this.fieldLength, this.featureNameLength);
        result = 31 * result + Arrays.hashCode(this.fieldValueLengths);
        return result;
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), FIELD_LENGTH);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), FEATURE_NAME_LENGTH);
        PARSER.declareIntArray(ConstructingObjectParser.constructorArg(), FIELD_VALUE_LENGTHS);
    }
}

