/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.modelsize;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.LogisticRegression;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.inference.EnsembleInferenceModel;
import org.elasticsearch.xpack.ml.inference.modelsize.SizeEstimatorHelper;
import org.elasticsearch.xpack.ml.inference.modelsize.TrainedModelSizeInfo;
import org.elasticsearch.xpack.ml.inference.modelsize.TreeSizeInfo;

public class EnsembleSizeInfo
implements TrainedModelSizeInfo {
    public static final ParseField NAME = new ParseField("ensemble_model_size", new String[0]);
    private static final ParseField TREE_SIZES = new ParseField("tree_sizes", new String[0]);
    private static final ParseField FEATURE_NAME_LENGTHS = new ParseField("feature_name_lengths", new String[0]);
    private static final ParseField NUM_OUTPUT_PROCESSOR_WEIGHTS = new ParseField("num_output_processor_weights", new String[0]);
    private static final ParseField NUM_CLASSIFICATION_WEIGHTS = new ParseField("num_classification_weights", new String[0]);
    private static final ParseField NUM_OPERATIONS = new ParseField("num_operations", new String[0]);
    private static final ParseField NUM_CLASSES = new ParseField("num_classes", new String[0]);
    static ConstructingObjectParser<EnsembleSizeInfo, Void> PARSER = new ConstructingObjectParser("ensemble_size", false, a -> new EnsembleSizeInfo((List)a[0], (Integer)a[1], (List)a[2], a[3] == null ? 0 : (Integer)a[3], a[4] == null ? 0 : (Integer)a[4], a[5] == null ? 0 : (Integer)a[5]));
    private final List<TreeSizeInfo> treeSizeInfos;
    private final int numOperations;
    private final int[] featureNameLengths;
    private final int numOutputProcessorWeights;
    private final int numClassificationWeights;
    private final int numClasses;

    public static EnsembleSizeInfo fromXContent(XContentParser parser) {
        return (EnsembleSizeInfo)PARSER.apply(parser, null);
    }

    public EnsembleSizeInfo(List<TreeSizeInfo> treeSizeInfos, int numOperations, List<Integer> featureNameLengths, int numOutputProcessorWeights, int numClassificationWeights, int numClasses) {
        this.treeSizeInfos = treeSizeInfos;
        this.numOperations = numOperations;
        this.featureNameLengths = featureNameLengths.stream().mapToInt(Integer::intValue).toArray();
        this.numOutputProcessorWeights = numOutputProcessorWeights;
        this.numClassificationWeights = numClassificationWeights;
        this.numClasses = numClasses;
    }

    public int getNumOperations() {
        return this.numOperations;
    }

    public long ramBytesUsed() {
        long size = EnsembleInferenceModel.SHALLOW_SIZE;
        this.treeSizeInfos.forEach(t -> t.setNumClasses(this.numClasses).ramBytesUsed());
        size += RamUsageEstimator.sizeOfCollection(this.treeSizeInfos);
        size += SizeEstimatorHelper.sizeOfStringCollection(this.featureNameLengths);
        size += LogisticRegression.SHALLOW_SIZE + SizeEstimatorHelper.sizeOfDoubleArray(this.numOutputProcessorWeights);
        return RamUsageEstimator.alignObjectSize((long)(size += SizeEstimatorHelper.sizeOfDoubleArray(this.numClassificationWeights)));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TREE_SIZES.getPreferredName(), this.treeSizeInfos);
        builder.field(NUM_OPERATIONS.getPreferredName(), this.numOperations);
        builder.field(NUM_CLASSES.getPreferredName(), this.numClasses);
        builder.field(FEATURE_NAME_LENGTHS.getPreferredName(), (Object)this.featureNameLengths);
        builder.field(NUM_CLASSIFICATION_WEIGHTS.getPreferredName(), this.numClassificationWeights);
        builder.field(NUM_OUTPUT_PROCESSOR_WEIGHTS.getPreferredName(), this.numOutputProcessorWeights);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnsembleSizeInfo that = (EnsembleSizeInfo)o;
        return this.numOperations == that.numOperations && this.numOutputProcessorWeights == that.numOutputProcessorWeights && this.numClassificationWeights == that.numClassificationWeights && this.numClasses == that.numClasses && Objects.equals(this.treeSizeInfos, that.treeSizeInfos) && Arrays.equals(this.featureNameLengths, that.featureNameLengths);
    }

    public int hashCode() {
        int result = Objects.hash(this.treeSizeInfos, this.numOperations, this.numOutputProcessorWeights, this.numClassificationWeights, this.numClasses);
        result = 31 * result + Arrays.hashCode(this.featureNameLengths);
        return result;
    }

    public String getName() {
        return NAME.getPreferredName();
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> TreeSizeInfo.PARSER.apply(arg_0, arg_1), TREE_SIZES);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), NUM_OPERATIONS);
        PARSER.declareIntArray(ConstructingObjectParser.constructorArg(), FEATURE_NAME_LENGTHS);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_OUTPUT_PROCESSOR_WEIGHTS);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_CLASSIFICATION_WEIGHTS);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_CLASSES);
    }
}

