/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsBuilder;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessConfig;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessFactory;
import org.elasticsearch.xpack.ml.dataframe.process.NativeMemoryUsageEstimationProcess;
import org.elasticsearch.xpack.ml.dataframe.process.results.MemoryUsageEstimationResult;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.ProcessPipes;
import org.elasticsearch.xpack.ml.utils.NamedPipeHelper;

public class NativeMemoryUsageEstimationProcessFactory
implements AnalyticsProcessFactory<MemoryUsageEstimationResult> {
    private static final Logger LOGGER = LogManager.getLogger(NativeMemoryUsageEstimationProcessFactory.class);
    private static final NamedPipeHelper NAMED_PIPE_HELPER = new NamedPipeHelper();
    private final Environment env;
    private final NativeController nativeController;
    private final AtomicLong counter;
    private volatile Duration processConnectTimeout;

    public NativeMemoryUsageEstimationProcessFactory(Environment env, NativeController nativeController, ClusterService clusterService) {
        this.env = Objects.requireNonNull(env);
        this.nativeController = Objects.requireNonNull(nativeController);
        this.counter = new AtomicLong(0L);
        this.setProcessConnectTimeout((TimeValue)MachineLearning.PROCESS_CONNECT_TIMEOUT.get(env.settings()));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.PROCESS_CONNECT_TIMEOUT, this::setProcessConnectTimeout);
    }

    void setProcessConnectTimeout(TimeValue processConnectTimeout) {
        this.processConnectTimeout = Duration.ofMillis(processConnectTimeout.getMillis());
    }

    public NativeMemoryUsageEstimationProcess createAnalyticsProcess(DataFrameAnalyticsConfig config, AnalyticsProcessConfig analyticsProcessConfig, boolean hasState, ExecutorService executorService, Consumer<String> onProcessCrash) {
        ArrayList<Path> filesToDelete = new ArrayList<Path>();
        ProcessPipes processPipes = new ProcessPipes(this.env, NAMED_PIPE_HELPER, this.processConnectTimeout, "data_frame_analyzer", config.getId(), this.counter.incrementAndGet(), false, false, true, false, false);
        this.createNativeProcess(config.getId(), analyticsProcessConfig, filesToDelete, processPipes);
        NativeMemoryUsageEstimationProcess process = new NativeMemoryUsageEstimationProcess(config.getId(), processPipes, 0, filesToDelete, onProcessCrash);
        try {
            process.start(executorService);
            return process;
        }
        catch (IOException | EsRejectedExecutionException e) {
            String msg = "Failed to connect to data frame analytics memory usage estimation process for job " + config.getId();
            LOGGER.error(msg);
            try {
                IOUtils.close((Closeable)process);
            }
            catch (IOException ioe) {
                LOGGER.error("Can't close data frame analytics memory usage estimation process", (Throwable)ioe);
            }
            throw ExceptionsHelper.serverError((String)msg, (Throwable)e);
        }
    }

    private void createNativeProcess(String jobId, AnalyticsProcessConfig analyticsProcessConfig, List<Path> filesToDelete, ProcessPipes processPipes) {
        AnalyticsBuilder analyticsBuilder = new AnalyticsBuilder(() -> ((Environment)this.env).tmpFile(), this.nativeController, processPipes, analyticsProcessConfig, filesToDelete).performMemoryUsageEstimationOnly();
        try {
            analyticsBuilder.build();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("[{}] Interrupted while launching data frame analytics memory usage estimation process", (Object)jobId);
        }
        catch (IOException e) {
            String msg = "[" + jobId + "] Failed to launch data frame analytics memory usage estimation process";
            LOGGER.error(msg);
            throw ExceptionsHelper.serverError((String)msg, (Throwable)e);
        }
    }
}

