/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.scroll;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;

class SearchHitToJsonProcessor
implements Releasable {
    private final ExtractedFields fields;
    private final XContentBuilder jsonBuilder;

    SearchHitToJsonProcessor(ExtractedFields fields, OutputStream outputStream) throws IOException {
        this.fields = Objects.requireNonNull(fields);
        this.jsonBuilder = new XContentBuilder((XContent)JsonXContent.jsonXContent, outputStream);
    }

    public void process(SearchHit hit) throws IOException {
        this.jsonBuilder.startObject();
        for (ExtractedField field : this.fields.getAllFields()) {
            this.writeKeyValue(field.getName(), field.value(hit));
        }
        this.jsonBuilder.endObject();
    }

    private void writeKeyValue(String key, Object ... values) throws IOException {
        if (values.length == 0) {
            return;
        }
        if (values.length == 1) {
            this.jsonBuilder.field(key, values[0]);
        } else {
            this.jsonBuilder.array(key, values);
        }
    }

    public void close() {
        this.jsonBuilder.close();
    }
}

