/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.task.JobTask;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;

public class TransportCloseJobAction
extends TransportTasksAction<JobTask, CloseJobAction.Request, CloseJobAction.Response, CloseJobAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportCloseJobAction.class);
    private final ThreadPool threadPool;
    private final Client client;
    private final ClusterService clusterService;
    private final AnomalyDetectionAuditor auditor;
    private final PersistentTasksService persistentTasksService;
    private final JobConfigProvider jobConfigProvider;
    private final DatafeedConfigProvider datafeedConfigProvider;

    @Inject
    public TransportCloseJobAction(TransportService transportService, Client client, ThreadPool threadPool, ActionFilters actionFilters, ClusterService clusterService, AnomalyDetectionAuditor auditor, PersistentTasksService persistentTasksService, JobConfigProvider jobConfigProvider, DatafeedConfigProvider datafeedConfigProvider) {
        super("cluster:admin/xpack/ml/job/close", clusterService, transportService, actionFilters, CloseJobAction.Request::new, CloseJobAction.Response::new, CloseJobAction.Response::new, "same");
        this.threadPool = threadPool;
        this.client = client;
        this.clusterService = clusterService;
        this.auditor = auditor;
        this.persistentTasksService = persistentTasksService;
        this.jobConfigProvider = jobConfigProvider;
        this.datafeedConfigProvider = datafeedConfigProvider;
    }

    protected void doExecute(Task task, CloseJobAction.Request request, ActionListener<CloseJobAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!request.isLocal() && !nodes.isLocalNodeElectedMaster()) {
            if (nodes.getMasterNode() == null) {
                listener.onFailure((Exception)new MasterNotDiscoveredException("no known master node"));
            } else {
                this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, CloseJobAction.Response::new));
            }
        } else {
            boolean isForce = request.isForce();
            TimeValue timeout = request.getCloseTimeout();
            PersistentTasksCustomMetadata tasksMetadata = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
            this.jobConfigProvider.expandJobsIds(request.getJobId(), request.allowNoMatch(), true, tasksMetadata, isForce, (ActionListener<SortedSet<String>>)ActionListener.wrap(expandedJobIds -> this.validate((Collection<String>)expandedJobIds, isForce, tasksMetadata, (ActionListener<OpenAndClosingIds>)ActionListener.wrap(response -> this.stopDatafeedsIfNecessary((OpenAndClosingIds)response, isForce, timeout, tasksMetadata, (ActionListener<Boolean>)ActionListener.wrap(bool -> {
                request.setOpenJobIds(response.openJobIds.toArray(new String[0]));
                if (response.openJobIds.isEmpty() && response.closingJobIds.isEmpty()) {
                    listener.onResponse((Object)new CloseJobAction.Response(true));
                    return;
                }
                if (isForce) {
                    ArrayList<String> jobIdsToForceClose = new ArrayList<String>(response.openJobIds);
                    jobIdsToForceClose.addAll(response.closingJobIds);
                    this.forceCloseJob(state, request, jobIdsToForceClose, listener);
                } else {
                    HashSet<String> executorNodes = new HashSet<String>();
                    PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
                    for (String resolvedJobId : request.getOpenJobIds()) {
                        PersistentTasksCustomMetadata.PersistentTask jobTask = MlTasks.getJobTask((String)resolvedJobId, (PersistentTasksCustomMetadata)tasks);
                        if (jobTask == null) {
                            String msg = "Requested job [" + resolvedJobId + "] be stopped, but job's task could not be found.";
                            assert (jobTask != null) : msg;
                            logger.error(msg);
                            continue;
                        }
                        if (jobTask.isAssigned()) {
                            executorNodes.add(jobTask.getExecutorNode());
                            continue;
                        }
                        this.persistentTasksService.sendRemoveRequest(jobTask.getId(), ActionListener.wrap(r -> logger.trace(() -> new ParameterizedMessage("[{}] removed task to close unassigned job", (Object)resolvedJobId)), e -> logger.error(() -> new ParameterizedMessage("[{}] failed to remove task to close unassigned job", (Object)resolvedJobId), (Throwable)e)));
                    }
                    request.setNodes(executorNodes.toArray(new String[0]));
                    this.normalCloseJob(state, task, request, response.openJobIds, response.closingJobIds, listener);
                }
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    void validate(Collection<String> expandedJobIds, boolean forceClose, PersistentTasksCustomMetadata tasksMetadata, ActionListener<OpenAndClosingIds> listener) {
        OpenAndClosingIds ids = new OpenAndClosingIds();
        ArrayList<String> failedJobs = new ArrayList<String>();
        for (String jobId : expandedJobIds) {
            TransportCloseJobAction.addJobAccordingToState(jobId, tasksMetadata, ids.openJobIds, ids.closingJobIds, failedJobs);
        }
        if (!forceClose && failedJobs.size() > 0) {
            if (expandedJobIds.size() == 1) {
                listener.onFailure((Exception)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)"cannot close job [{}] because it failed, use force close", (Object[])new Object[]{expandedJobIds.iterator().next()}));
                return;
            }
            listener.onFailure((Exception)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)"one or more jobs have state failed, use force close", (Object[])new Object[0]));
            return;
        }
        ids.openJobIds.addAll(failedJobs);
        listener.onResponse((Object)ids);
    }

    void stopDatafeedsIfNecessary(OpenAndClosingIds jobIds, boolean isForce, TimeValue timeout, PersistentTasksCustomMetadata tasksMetadata, ActionListener<Boolean> listener) {
        this.datafeedConfigProvider.findDatafeedsForJobIds(jobIds.openJobIds, (ActionListener<Set<String>>)ActionListener.wrap(datafeedIds -> {
            List<String> runningDatafeedIds = datafeedIds.stream().filter(datafeedId -> MlTasks.getDatafeedState((String)datafeedId, (PersistentTasksCustomMetadata)tasksMetadata) != DatafeedState.STOPPED).collect(Collectors.toList());
            if (runningDatafeedIds.isEmpty()) {
                listener.onResponse((Object)false);
            } else if (isForce) {
                this.isolateDatafeeds(jobIds.openJobIds, runningDatafeedIds, (ActionListener<Void>)ActionListener.wrap(r -> this.stopDatafeeds(runningDatafeedIds, true, timeout, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                this.stopDatafeeds(runningDatafeedIds, false, timeout, listener);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void stopDatafeeds(List<String> runningDatafeedIds, boolean isForce, TimeValue timeout, ActionListener<Boolean> listener) {
        StopDatafeedAction.Request request = new StopDatafeedAction.Request(String.join((CharSequence)",", runningDatafeedIds));
        request.setForce(isForce);
        request.setStopTimeout(timeout);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)StopDatafeedAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)r.isStopped()), e -> listener.onFailure((Exception)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)"failed to close jobs as one or more had started datafeeds that could not be stopped: started datafeeds [{}], error stopping them [{}]", (Throwable)e, (Object[])new Object[]{request.getDatafeedId(), e.getMessage()}))));
    }

    void isolateDatafeeds(List<String> openJobs, List<String> runningDatafeedIds, ActionListener<Void> listener) {
        GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.wrap(c -> listener.onResponse(null), e -> {
            logger.info("could not isolate all datafeeds while force closing jobs " + openJobs, (Throwable)e);
            listener.onResponse(null);
        }), runningDatafeedIds.size());
        for (String runningDatafeedId : runningDatafeedIds) {
            IsolateDatafeedAction.Request request = new IsolateDatafeedAction.Request(runningDatafeedId);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IsolateDatafeedAction.INSTANCE, (ActionRequest)request, (ActionListener)groupedListener);
        }
    }

    static void addJobAccordingToState(String jobId, PersistentTasksCustomMetadata tasksMetadata, List<String> openJobs, List<String> closingJobs, List<String> failedJobs) {
        JobState jobState = MlTasks.getJobState((String)jobId, (PersistentTasksCustomMetadata)tasksMetadata);
        switch (jobState) {
            case CLOSING: {
                closingJobs.add(jobId);
                break;
            }
            case FAILED: {
                failedJobs.add(jobId);
                break;
            }
            case OPENING: 
            case OPENED: {
                openJobs.add(jobId);
                break;
            }
        }
    }

    static WaitForCloseRequest buildWaitForCloseRequest(List<String> openJobIds, List<String> closingJobIds, PersistentTasksCustomMetadata tasks, AnomalyDetectionAuditor auditor) {
        PersistentTasksCustomMetadata.PersistentTask jobTask;
        WaitForCloseRequest waitForCloseRequest = new WaitForCloseRequest();
        for (String jobId : openJobIds) {
            jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
            if (jobTask == null) continue;
            auditor.info(jobId, "Job is closing");
            waitForCloseRequest.persistentTaskIds.add(jobTask.getId());
            waitForCloseRequest.jobsToFinalize.add(jobId);
        }
        for (String jobId : closingJobIds) {
            jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
            if (jobTask == null) continue;
            waitForCloseRequest.persistentTaskIds.add(jobTask.getId());
        }
        return waitForCloseRequest;
    }

    protected void taskOperation(final CloseJobAction.Request request, final JobTask jobTask, final ActionListener<CloseJobAction.Response> listener) {
        JobTaskState taskState = new JobTaskState(JobState.CLOSING, jobTask.getAllocationId(), "close job (api)");
        jobTask.updatePersistentTaskState((PersistentTaskState)taskState, ActionListener.wrap(task -> this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                if (org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException && Strings.isAllOrWildcard((String)request.getJobId())) {
                    logger.trace(() -> new ParameterizedMessage("[{}] [{}] failed to close job due to resource not found exception", (Object)jobTask.getJobId(), (Object)jobTask.getId()), (Throwable)e);
                    jobTask.closeJob("close job (api)");
                    listener.onResponse((Object)new CloseJobAction.Response(true));
                } else {
                    listener.onFailure(e);
                }
            }

            protected void doRun() {
                jobTask.closeJob("close job (api)");
                listener.onResponse((Object)new CloseJobAction.Response(true));
            }
        }), e -> {
            if (org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException && Strings.isAllOrWildcard((String)request.getJobId())) {
                logger.trace(() -> new ParameterizedMessage("[{}] [{}] failed to update job to closing due to resource not found exception", (Object)jobTask.getJobId(), (Object)jobTask.getId()), (Throwable)e);
                listener.onResponse((Object)new CloseJobAction.Response(true));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    protected CloseJobAction.Response newResponse(CloseJobAction.Request request, List<CloseJobAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (request.getOpenJobIds().length != tasks.size()) {
            if (!taskOperationFailures.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
            }
            return new CloseJobAction.Response(true);
        }
        return new CloseJobAction.Response(tasks.stream().allMatch(CloseJobAction.Response::isClosed));
    }

    private void forceCloseJob(ClusterState currentState, final CloseJobAction.Request request, List<String> jobIdsToForceClose, final ActionListener<CloseJobAction.Response> listener) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)currentState.getMetadata().custom("persistent_tasks");
        final int numberOfJobs = jobIdsToForceClose.size();
        final AtomicInteger counter = new AtomicInteger();
        final AtomicArray failures = new AtomicArray(numberOfJobs);
        for (String jobId : jobIdsToForceClose) {
            PersistentTasksCustomMetadata.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
            if (jobTask == null) continue;
            this.auditor.info(jobId, "Job is closing (forced)");
            this.persistentTasksService.sendRemoveRequest(jobTask.getId(), new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

                public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> task) {
                    if (counter.incrementAndGet() == numberOfJobs) {
                        this.sendResponseOrFailure(request.getJobId(), (ActionListener<CloseJobAction.Response>)listener, (AtomicArray<Exception>)failures);
                    }
                }

                public void onFailure(Exception e) {
                    int slot = counter.incrementAndGet();
                    if (!(org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException && Strings.isAllOrWildcard((String[])new String[]{request.getJobId()}))) {
                        failures.set(slot - 1, (Object)e);
                    }
                    if (slot == numberOfJobs) {
                        this.sendResponseOrFailure(request.getJobId(), (ActionListener<CloseJobAction.Response>)listener, (AtomicArray<Exception>)failures);
                    }
                }

                private void sendResponseOrFailure(String jobId, ActionListener<CloseJobAction.Response> listener2, AtomicArray<Exception> failures2) {
                    List caughtExceptions = failures2.asList();
                    if (caughtExceptions.size() == 0) {
                        listener2.onResponse((Object)new CloseJobAction.Response(true));
                        return;
                    }
                    String msg = "Failed to force close job [" + jobId + "] with [" + caughtExceptions.size() + "] failures, rethrowing last, all Exceptions: [" + caughtExceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(", ")) + "]";
                    ElasticsearchException e = new ElasticsearchException(msg, (Throwable)caughtExceptions.get(0), new Object[0]);
                    listener2.onFailure((Exception)e);
                }
            });
        }
    }

    private void normalCloseJob(ClusterState currentState, Task task, CloseJobAction.Request request, List<String> openJobIds, List<String> closingJobIds, ActionListener<CloseJobAction.Response> listener) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)currentState.getMetadata().custom("persistent_tasks");
        WaitForCloseRequest waitForCloseRequest = TransportCloseJobAction.buildWaitForCloseRequest(openJobIds, closingJobIds, tasks, this.auditor);
        if (!waitForCloseRequest.hasJobsToWaitFor()) {
            listener.onResponse((Object)new CloseJobAction.Response(true));
            return;
        }
        boolean noOpenJobsToClose = openJobIds.isEmpty();
        if (noOpenJobsToClose) {
            this.waitForJobClosed(request, waitForCloseRequest, new CloseJobAction.Response(true), listener);
            return;
        }
        ActionListener finalListener = ActionListener.wrap(r -> this.waitForJobClosed(request, waitForCloseRequest, (CloseJobAction.Response)r, listener), arg_0 -> listener.onFailure(arg_0));
        super.doExecute(task, (BaseTasksRequest)request, finalListener);
    }

    void waitForJobClosed(CloseJobAction.Request request, WaitForCloseRequest waitForCloseRequest, CloseJobAction.Response response, ActionListener<CloseJobAction.Response> listener) {
        this.persistentTasksService.waitForPersistentTasksCondition(persistentTasksCustomMetadata -> {
            for (String persistentTaskId : waitForCloseRequest.persistentTaskIds) {
                if (persistentTasksCustomMetadata.getTask(persistentTaskId) == null) continue;
                return false;
            }
            return true;
        }, request.getCloseTimeout(), listener.delegateFailure((l, r) -> l.onResponse((Object)response)));
    }

    static class OpenAndClosingIds {
        List<String> openJobIds = new ArrayList<String>();
        List<String> closingJobIds = new ArrayList<String>();

        OpenAndClosingIds() {
        }
    }

    static class WaitForCloseRequest {
        List<String> persistentTaskIds = new ArrayList<String>();
        List<String> jobsToFinalize = new ArrayList<String>();

        WaitForCloseRequest() {
        }

        public boolean hasJobsToWaitFor() {
            return !this.persistentTaskIds.isEmpty();
        }
    }
}

