/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.util.Holder;
import org.elasticsearch.xpack.sql.plan.physical.LimitExec;
import org.elasticsearch.xpack.sql.plan.physical.OrderExec;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.Unexecutable;
import org.elasticsearch.xpack.sql.plan.physical.UnplannedExec;

abstract class Verifier {
    Verifier() {
    }

    static List<Failure> verifyMappingPlan(PhysicalPlan plan) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        plan.forEachUp(p -> {
            if (p instanceof UnplannedExec) {
                failures.add(Failure.fail((Node)p, (String)"Unplanned item", (Object[])new Object[0]));
            }
            p.forEachExpressionUp(e -> {
                if (e.childrenResolved() && !e.resolved()) {
                    failures.add(Failure.fail((Node)e, (String)"Unresolved expression", (Object[])new Object[0]));
                }
            });
        });
        Verifier.checkForNonCollapsableSubselects(plan, failures);
        return failures;
    }

    static List<Failure> verifyExecutingPlan(PhysicalPlan plan) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        plan.forEachUp(p -> {
            if (p instanceof Unexecutable) {
                failures.add(Failure.fail((Node)p, (String)"Unexecutable item", (Object[])new Object[0]));
            }
            p.forEachExpressionUp(e -> {
                if (e.childrenResolved() && !e.resolved()) {
                    failures.add(Failure.fail((Node)e, (String)"Unresolved expression", (Object[])new Object[0]));
                }
            });
        });
        return failures;
    }

    private static void checkForNonCollapsableSubselects(PhysicalPlan plan, List<Failure> failures) {
        Holder hasLimit = new Holder((Object)Boolean.FALSE);
        Holder orderBy = new Holder();
        plan.forEachUp(p -> {
            if (!((Boolean)hasLimit.get()).booleanValue() && p instanceof LimitExec) {
                hasLimit.set((Object)Boolean.TRUE);
                return;
            }
            if (p instanceof OrderExec) {
                if (((Boolean)hasLimit.get()).booleanValue() && orderBy.get() != null && !((OrderExec)p).order().equals(orderBy.get())) {
                    failures.add(Failure.fail((Node)p, (String)"Cannot use ORDER BY on top of a subquery with ORDER BY and LIMIT", (Object[])new Object[0]));
                } else {
                    orderBy.set(((OrderExec)p).order());
                }
            }
        });
    }
}

