/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.ReindexSslConfig;
import org.elasticsearch.index.reindex.ReindexValidator;
import org.elasticsearch.index.reindex.Reindexer;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportReindexAction
extends HandledTransportAction<ReindexRequest, BulkByScrollResponse> {
    public static final Setting<List<String>> REMOTE_CLUSTER_WHITELIST = Setting.listSetting((String)"reindex.remote.whitelist", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    protected final ReindexValidator reindexValidator;
    private final Reindexer reindexer;
    protected final Client client;

    @Inject
    public TransportReindexAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, ScriptService scriptService, AutoCreateIndex autoCreateIndex, Client client, TransportService transportService, ReindexSslConfig sslConfig) {
        this("indices:data/write/reindex", settings, threadPool, actionFilters, indexNameExpressionResolver, clusterService, scriptService, autoCreateIndex, client, transportService, sslConfig);
    }

    protected TransportReindexAction(String name, Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, ScriptService scriptService, AutoCreateIndex autoCreateIndex, Client client, TransportService transportService, ReindexSslConfig sslConfig) {
        super(name, transportService, actionFilters, ReindexRequest::new);
        this.client = client;
        this.reindexValidator = new ReindexValidator(settings, clusterService, indexNameExpressionResolver, autoCreateIndex);
        this.reindexer = new Reindexer(clusterService, client, threadPool, scriptService, sslConfig);
    }

    protected void doExecute(Task task, ReindexRequest request, ActionListener<BulkByScrollResponse> listener) {
        this.validate(request);
        BulkByScrollTask bulkByScrollTask = (BulkByScrollTask)task;
        this.reindexer.initTask(bulkByScrollTask, request, (ActionListener<Void>)listener.delegateFailure((l, v) -> this.reindexer.execute(bulkByScrollTask, request, this.getBulkClient(), (ActionListener<BulkByScrollResponse>)l)));
    }

    protected Client getBulkClient() {
        return this.client;
    }

    protected void validate(ReindexRequest request) {
        this.reindexValidator.initialValidation(request);
    }
}

