/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LeaveLockdownModeTask
extends Task {
    static final String LEAVE_LOCKDOWN_MODE_TASK_CLASS = "com.unboundid.directory.server.tasks.LeaveLockdownModeTask";
    private static final String ATTR_LEAVE_LOCKDOWN_REASON = "ds-task-leave-lockdown-reason";
    private static final TaskProperty PROPERTY_LEAVE_LOCKDOWN_REASON = new TaskProperty("ds-task-leave-lockdown-reason", TaskMessages.INFO_DISPLAY_NAME_LEAVE_LOCKDOWN_REASON.get(), TaskMessages.INFO_DESCRIPTION_LEAVE_LOCKDOWN_REASON.get(), String.class, false, false, false);
    private static final String OC_LEAVE_LOCKDOWN_MODE_TASK = "ds-task-leave-lockdown-mode";
    private static final long serialVersionUID = -1353712468653879793L;
    private final String reason;

    public LeaveLockdownModeTask() {
        this.reason = null;
    }

    public LeaveLockdownModeTask(String taskID) {
        this(taskID, (String)null);
    }

    public LeaveLockdownModeTask(String taskID, String reason) {
        this(taskID, reason, null, null, null, null, null);
    }

    public LeaveLockdownModeTask(String taskID, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        this(taskID, null, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
    }

    public LeaveLockdownModeTask(String taskID, String reason, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        this(taskID, reason, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public LeaveLockdownModeTask(String taskID, String reason, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnStart, List<String> notifyOnCompletion, List<String> notifyOnSuccess, List<String> notifyOnError, Boolean alertOnStart, Boolean alertOnSuccess, Boolean alertOnError) {
        super(taskID, LEAVE_LOCKDOWN_MODE_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        this.reason = reason;
    }

    public LeaveLockdownModeTask(Entry entry) throws TaskException {
        super(entry);
        this.reason = entry.getAttributeValue(ATTR_LEAVE_LOCKDOWN_REASON);
    }

    public LeaveLockdownModeTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(LEAVE_LOCKDOWN_MODE_TASK_CLASS, properties);
        String r = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (!attrName.equalsIgnoreCase(ATTR_LEAVE_LOCKDOWN_REASON)) continue;
            r = LeaveLockdownModeTask.parseString(p, values, null);
            break;
        }
        this.reason = r;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_LEAVE_LOCKDOWN_MODE.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_LEAVE_LOCKDOWN_MODE.get();
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_LEAVE_LOCKDOWN_MODE_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
        if (this.reason != null) {
            attrs.add(new Attribute(ATTR_LEAVE_LOCKDOWN_REASON, this.reason));
        }
        return attrs;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        List<TaskProperty> propList = Collections.singletonList(PROPERTY_LEAVE_LOCKDOWN_REASON);
        return Collections.unmodifiableList(propList);
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(10);
        if (this.reason != null) {
            props.put(PROPERTY_LEAVE_LOCKDOWN_REASON, Collections.singletonList(this.reason));
        }
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

