/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination.votingonly;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.coordination.Join;
import org.elasticsearch.cluster.coordination.votingonly.VotingOnlyNodeFeatureSet;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;

public class VotingOnlyNodePlugin
extends Plugin
implements DiscoveryPlugin,
NetworkPlugin,
ActionPlugin {
    private static final Setting<Boolean> VOTING_ONLY_NODE_SETTING = Setting.boolSetting((String)"node.voting_only", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope});
    private static final String VOTING_ONLY_ELECTION_STRATEGY = "supports_voting_only";
    static DiscoveryNodeRole VOTING_ONLY_NODE_ROLE = new DiscoveryNodeRole("voting_only", "v"){

        public Setting<Boolean> legacySetting() {
            return VOTING_ONLY_NODE_SETTING;
        }

        public boolean isEnabledByDefault(Settings settings) {
            return false;
        }
    };
    private final Settings settings;
    private final SetOnce<ThreadPool> threadPool;
    private final boolean isVotingOnlyNode;
    private final boolean transportClientMode;

    public VotingOnlyNodePlugin(Settings settings) {
        this.settings = settings;
        this.threadPool = new SetOnce();
        this.isVotingOnlyNode = DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)VOTING_ONLY_NODE_ROLE);
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    public static boolean isVotingOnlyNode(DiscoveryNode discoveryNode) {
        return discoveryNode.getRoles().contains(VOTING_ONLY_NODE_ROLE);
    }

    public static boolean isFullMasterNode(DiscoveryNode discoveryNode) {
        return discoveryNode.isMasterNode() && !discoveryNode.getRoles().contains(VOTING_ONLY_NODE_ROLE);
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(VOTING_ONLY_NODE_SETTING);
    }

    public Set<DiscoveryNodeRole> getRoles() {
        if (this.isVotingOnlyNode && !DiscoveryNode.isMasterNode((Settings)this.settings)) {
            throw new IllegalStateException("voting-only node must be master-eligible");
        }
        return Collections.singleton(VOTING_ONLY_NODE_ROLE);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.threadPool.set((Object)threadPool);
        return Collections.emptyList();
    }

    public Collection<Module> createGuiceModules() {
        if (this.transportClientMode) {
            return Collections.emptyList();
        }
        return Collections.singleton(b -> XPackPlugin.bindFeatureSet((Binder)b, VotingOnlyNodeFeatureSet.class));
    }

    public Map<String, ElectionStrategy> getElectionStrategies() {
        return Collections.singletonMap(VOTING_ONLY_ELECTION_STRATEGY, new VotingOnlyNodeElectionStrategy());
    }

    public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
        if (this.isVotingOnlyNode) {
            return Collections.singletonList(new TransportInterceptor(){

                public TransportInterceptor.AsyncSender interceptSender(TransportInterceptor.AsyncSender sender) {
                    return new VotingOnlyNodeAsyncSender(sender, () -> ((SetOnce)VotingOnlyNodePlugin.this.threadPool).get());
                }
            });
        }
        return Collections.emptyList();
    }

    public Settings additionalSettings() {
        return Settings.builder().put(DiscoveryModule.ELECTION_STRATEGY_SETTING.getKey(), VOTING_ONLY_ELECTION_STRATEGY).build();
    }

    static class VotingOnlyNodeElectionStrategy
    extends ElectionStrategy {
        VotingOnlyNodeElectionStrategy() {
        }

        public boolean satisfiesAdditionalQuorumConstraints(DiscoveryNode localNode, long localCurrentTerm, long localAcceptedTerm, long localAcceptedVersion, CoordinationMetadata.VotingConfiguration lastCommittedConfiguration, CoordinationMetadata.VotingConfiguration lastAcceptedConfiguration, CoordinationState.VoteCollection joinVotes) {
            if (VotingOnlyNodePlugin.isVotingOnlyNode(localNode)) {
                if (joinVotes.nodes().stream().filter(DiscoveryNode::isMasterNode).allMatch(VotingOnlyNodePlugin::isVotingOnlyNode)) {
                    return false;
                }
                if (joinVotes.getJoins().stream().anyMatch(VotingOnlyNodeElectionStrategy.fullMasterWithSameState(localAcceptedTerm, localAcceptedVersion)) && localAcceptedTerm > 0L && joinVotes.getJoins().stream().noneMatch(VotingOnlyNodeElectionStrategy.fullMasterWithOlderState(localAcceptedTerm, localAcceptedVersion))) {
                    return false;
                }
            }
            return true;
        }

        private static Predicate<Join> fullMasterWithSameState(long localAcceptedTerm, long localAcceptedVersion) {
            return join -> VotingOnlyNodePlugin.isFullMasterNode(join.getSourceNode()) && join.getLastAcceptedTerm() == localAcceptedTerm && join.getLastAcceptedVersion() == localAcceptedVersion;
        }

        private static Predicate<Join> fullMasterWithOlderState(long localAcceptedTerm, long localAcceptedVersion) {
            return join -> VotingOnlyNodePlugin.isFullMasterNode(join.getSourceNode()) && (join.getLastAcceptedTerm() < localAcceptedTerm || join.getLastAcceptedTerm() == localAcceptedTerm && join.getLastAcceptedVersion() < localAcceptedVersion);
        }
    }

    static class VotingOnlyNodeAsyncSender
    implements TransportInterceptor.AsyncSender {
        private final TransportInterceptor.AsyncSender sender;
        private final Supplier<ThreadPool> threadPoolSupplier;

        VotingOnlyNodeAsyncSender(TransportInterceptor.AsyncSender sender, Supplier<ThreadPool> threadPoolSupplier) {
            this.sender = sender;
            this.threadPoolSupplier = threadPoolSupplier;
        }

        public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, final TransportResponseHandler<T> handler) {
            if (action.equals("internal:cluster/coordination/publish_state")) {
                DiscoveryNode destinationNode = connection.getNode();
                if (VotingOnlyNodePlugin.isFullMasterNode(destinationNode)) {
                    this.sender.sendRequest(connection, action, request, options, new TransportResponseHandler<T>(){

                        public void handleResponse(TransportResponse response) {
                            handler.handleException(new TransportException((Throwable)new ElasticsearchException("ignoring successful publish response used purely for state transfer: " + response, new Object[0])));
                        }

                        public void handleException(TransportException exp) {
                            handler.handleException(exp);
                        }

                        public String executor() {
                            return handler.executor();
                        }

                        public T read(StreamInput in) throws IOException {
                            return (TransportResponse)handler.read(in);
                        }
                    });
                } else {
                    this.threadPoolSupplier.get().generic().execute(() -> handler.handleException(new TransportException((Throwable)new ElasticsearchException("voting-only node skipping publication to " + destinationNode, new Object[0]))));
                }
            } else {
                this.sender.sendRequest(connection, action, request, options, handler);
            }
        }
    }
}

