/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.results;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetCategoriesAction;
import org.elasticsearch.xpack.core.ml.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestGetCategoriesAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetCategoriesAction.class));

    public RestGetCategoriesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/categories/{" + GetCategoriesAction.Request.CATEGORY_ID.getPreferredName() + "}", (RestHandler)this, RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/categories/{" + GetCategoriesAction.Request.CATEGORY_ID.getPreferredName() + "}", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/categories", (RestHandler)this, RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/categories", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/categories/{" + GetCategoriesAction.Request.CATEGORY_ID.getPreferredName() + "}", (RestHandler)this, RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/categories/{" + GetCategoriesAction.Request.CATEGORY_ID.getPreferredName() + "}", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/categories", (RestHandler)this, RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/categories", deprecationLogger);
    }

    public String getName() {
        return "ml_get_catagories_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetCategoriesAction.Request request;
        Long categoryId;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        Long l = categoryId = restRequest.hasParam(GetCategoriesAction.Request.CATEGORY_ID.getPreferredName()) ? Long.valueOf(Long.parseLong(restRequest.param(GetCategoriesAction.Request.CATEGORY_ID.getPreferredName()))) : null;
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            request = GetCategoriesAction.Request.parseRequest((String)jobId, (XContentParser)parser);
            if (categoryId != null) {
                request.setCategoryId(categoryId);
            }
        } else {
            request = new GetCategoriesAction.Request(jobId);
            if (categoryId != null) {
                request.setCategoryId(categoryId);
            }
            if (restRequest.hasParam(GetCategoriesAction.Request.FROM.getPreferredName()) || restRequest.hasParam(GetCategoriesAction.Request.SIZE.getPreferredName()) || categoryId == null) {
                request.setPageParams(new PageParams(restRequest.paramAsInt(GetCategoriesAction.Request.FROM.getPreferredName(), 0), restRequest.paramAsInt(GetCategoriesAction.Request.SIZE.getPreferredName(), 100)));
            }
        }
        return channel -> client.execute((Action)GetCategoriesAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

