/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.calendar;

import java.io.IOException;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.PutCalendarAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;

public class RestPutCalendarAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestPutCalendarAction.class));

    public RestPutCalendarAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, "/_ml/calendars/{" + Calendar.ID.getPreferredName() + "}", (RestHandler)this, RestRequest.Method.PUT, "/_xpack/ml/calendars/{" + Calendar.ID.getPreferredName() + "}", deprecationLogger);
    }

    public String getName() {
        return "ml_put_calendar_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        PutCalendarAction.Request putCalendarRequest;
        String calendarId = restRequest.param(Calendar.ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            putCalendarRequest = PutCalendarAction.Request.parseRequest((String)calendarId, (XContentParser)parser);
        } else {
            putCalendarRequest = new PutCalendarAction.Request(new Calendar(calendarId, Collections.emptyList(), null));
        }
        return channel -> client.execute((Action)PutCalendarAction.INSTANCE, (ActionRequest)putCalendarRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

