/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.TreeSet;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.PutFilterAction;
import org.elasticsearch.xpack.core.ml.action.UpdateFilterAction;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.JobManager;

public class TransportUpdateFilterAction
extends HandledTransportAction<UpdateFilterAction.Request, PutFilterAction.Response> {
    private final Client client;
    private final JobManager jobManager;

    @Inject
    public TransportUpdateFilterAction(TransportService transportService, ActionFilters actionFilters, Client client, JobManager jobManager) {
        super("cluster:admin/xpack/ml/filters/update", transportService, actionFilters, UpdateFilterAction.Request::new);
        this.client = client;
        this.jobManager = jobManager;
    }

    protected void doExecute(Task task, UpdateFilterAction.Request request, ActionListener<PutFilterAction.Response> listener) {
        ActionListener filterListener = ActionListener.wrap(filterWithVersion -> this.updateFilter((FilterWithVersion)filterWithVersion, request, listener), arg_0 -> listener.onFailure(arg_0));
        this.getFilterWithVersion(request.getFilterId(), (ActionListener<FilterWithVersion>)filterListener);
    }

    private void updateFilter(FilterWithVersion filterWithVersion, UpdateFilterAction.Request request, ActionListener<PutFilterAction.Response> listener) {
        MlFilter filter = filterWithVersion.filter;
        if (request.isNoop()) {
            listener.onResponse((Object)new PutFilterAction.Response(filter));
            return;
        }
        String description = request.getDescription() == null ? filter.getDescription() : request.getDescription();
        TreeSet items = new TreeSet(filter.getItems());
        items.addAll(request.getAddItems());
        for (String toRemove : request.getRemoveItems()) {
            boolean wasPresent = items.remove(toRemove);
            if (wasPresent) continue;
            listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)("Cannot remove item [" + toRemove + "] as it is not present in filter [" + filter.getId() + "]"), (Object[])new Object[0]));
            return;
        }
        MlFilter updatedFilter = MlFilter.builder((String)filter.getId()).setDescription(description).setItems(items).build();
        this.indexUpdatedFilter(updatedFilter, filterWithVersion.version, request, listener);
    }

    private void indexUpdatedFilter(final MlFilter filter, long version, final UpdateFilterAction.Request request, final ActionListener<PutFilterAction.Response> listener) {
        IndexRequest indexRequest = new IndexRequest(".ml-meta", "doc", filter.documentId());
        indexRequest.version(version);
        indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("include_type", "true"));
            indexRequest.source(filter.toXContent(builder, (ToXContent.Params)params));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialise filter with id [" + filter.getId() + "]", e);
        }
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)IndexAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                TransportUpdateFilterAction.this.jobManager.notifyFilterChanged(filter, request.getAddItems(), request.getRemoveItems());
                listener.onResponse((Object)new PutFilterAction.Response(filter));
            }

            public void onFailure(Exception e) {
                Object reportedException = e instanceof VersionConflictEngineException ? ExceptionsHelper.conflictStatusException((String)("Error updating filter with id [" + filter.getId() + "] because it was modified while the update was in progress"), (Throwable)e, (Object[])new Object[0]) : ExceptionsHelper.serverError((String)("Error updating filter with id [" + filter.getId() + "]"), (Throwable)e);
                listener.onFailure((Exception)reportedException);
            }
        });
    }

    private void getFilterWithVersion(final String filterId, final ActionListener<FilterWithVersion> listener) {
        GetRequest getRequest = new GetRequest(".ml-meta", "doc", MlFilter.documentId((String)filterId));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getDocResponse) {
                block15: {
                    try {
                        if (getDocResponse.isExists()) {
                            BytesReference docSource = getDocResponse.getSourceAsBytesRef();
                            try (StreamInput stream = docSource.streamInput();
                                 XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                                MlFilter filter = ((MlFilter.Builder)MlFilter.LENIENT_PARSER.apply(parser, null)).build();
                                listener.onResponse((Object)new FilterWithVersion(filter, getDocResponse.getVersion()));
                                break block15;
                            }
                        }
                        this.onFailure((Exception)new ResourceNotFoundException(Messages.getMessage((String)"No filter with id [{0}] exists", (Object[])new Object[]{filterId}), new Object[0]));
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private static class FilterWithVersion {
        private final MlFilter filter;
        private final long version;

        private FilterWithVersion(MlFilter filter, long version) {
            this.filter = filter;
            this.version = version;
        }
    }
}

