/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.rollup.action.GetRollupIndexCapsAction;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.support.Exceptions;

public class TransportPutDatafeedAction
extends TransportMasterNodeAction<PutDatafeedAction.Request, PutDatafeedAction.Response> {
    private final XPackLicenseState licenseState;
    private final Client client;
    private final SecurityContext securityContext;

    @Inject
    public TransportPutDatafeedAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Client client, XPackLicenseState licenseState, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/ml/datafeeds/put", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, PutDatafeedAction.Request::new);
        this.licenseState = licenseState;
        this.client = client;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
    }

    protected String executor() {
        return "same";
    }

    protected PutDatafeedAction.Response newResponse() {
        return new PutDatafeedAction.Response();
    }

    protected void masterOperation(PutDatafeedAction.Request request, ClusterState state, ActionListener<PutDatafeedAction.Response> listener) {
        if (this.licenseState.isAuthAllowed()) {
            String[] indices = request.getDatafeed().getIndices().toArray(new String[0]);
            String username = this.securityContext.getUser().principal();
            HasPrivilegesRequest privRequest = new HasPrivilegesRequest();
            privRequest.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
            privRequest.username(username);
            privRequest.clusterPrivileges(Strings.EMPTY_ARRAY);
            RoleDescriptor.IndicesPrivileges.Builder indicesPrivilegesBuilder = RoleDescriptor.IndicesPrivileges.builder().indices(indices);
            ActionListener privResponseListener = ActionListener.wrap(r -> this.handlePrivsResponse(username, request, (HasPrivilegesResponse)r, listener), arg_0 -> listener.onFailure(arg_0));
            ActionListener getRollupIndexCapsActionHandler = ActionListener.wrap(response -> {
                if (response.getJobs().isEmpty()) {
                    indicesPrivilegesBuilder.privileges(new String[]{"indices:data/read/search"});
                } else {
                    indicesPrivilegesBuilder.privileges(new String[]{"indices:data/read/search", "indices:admin/xpack/rollup/search"});
                }
                privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{indicesPrivilegesBuilder.build()});
                this.client.execute((Action)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    indicesPrivilegesBuilder.privileges(new String[]{"indices:data/read/search"});
                    privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{indicesPrivilegesBuilder.build()});
                    this.client.execute((Action)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
                } else {
                    listener.onFailure(e);
                }
            });
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)GetRollupIndexCapsAction.INSTANCE, (ActionRequest)new GetRollupIndexCapsAction.Request(indices), (ActionListener)getRollupIndexCapsActionHandler);
        } else {
            this.putDatafeed(request, (Map<String, String>)this.threadPool.getThreadContext().getHeaders(), listener);
        }
    }

    private void handlePrivsResponse(String username, PutDatafeedAction.Request request, HasPrivilegesResponse response, ActionListener<PutDatafeedAction.Response> listener) throws IOException {
        if (response.isCompleteMatch()) {
            this.putDatafeed(request, (Map<String, String>)this.threadPool.getThreadContext().getHeaders(), listener);
        } else {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            for (HasPrivilegesResponse.ResourcePrivileges index : response.getIndexPrivileges()) {
                builder.field(index.getResource());
                builder.map(index.getPrivileges());
            }
            builder.endObject();
            listener.onFailure((Exception)Exceptions.authorizationError((String)"Cannot create datafeed [{}] because user {} lacks permissions on the indices: {}", (Object[])new Object[]{request.getDatafeed().getId(), username, Strings.toString((XContentBuilder)builder)}));
        }
    }

    private void putDatafeed(final PutDatafeedAction.Request request, final Map<String, String> headers, ActionListener<PutDatafeedAction.Response> listener) {
        DatafeedConfig.validateAggregations((AggregatorFactories.Builder)request.getDatafeed().getParsedAggregations());
        this.clusterService.submitStateUpdateTask("put-datafeed-" + request.getDatafeed().getId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<PutDatafeedAction.Response>((AckedRequest)request, listener){

            protected PutDatafeedAction.Response newResponse(boolean acknowledged) {
                if (acknowledged) {
                    TransportPutDatafeedAction.this.logger.info("Created datafeed [{}]", (Object)request.getDatafeed().getId());
                }
                return new PutDatafeedAction.Response(request.getDatafeed());
            }

            public ClusterState execute(ClusterState currentState) {
                return TransportPutDatafeedAction.this.putDatafeed(request, (Map<String, String>)headers, currentState);
            }
        });
    }

    private ClusterState putDatafeed(PutDatafeedAction.Request request, Map<String, String> headers, ClusterState clusterState) {
        XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
        MlMetadata currentMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
        MlMetadata newMetadata = new MlMetadata.Builder(currentMetadata).putDatafeed(request.getDatafeed(), headers).build();
        return ClusterState.builder((ClusterState)clusterState).metaData(MetaData.builder((MetaData)clusterState.getMetaData()).putCustom("ml", (MetaData.Custom)newMetadata).build()).build();
    }

    protected ClusterBlockException checkBlock(PutDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void doExecute(Task task, PutDatafeedAction.Request request, ActionListener<PutDatafeedAction.Response> listener) {
        if (this.licenseState.isMachineLearningAllowed()) {
            super.doExecute(task, (MasterNodeRequest)request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }
}

