/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.core.ml.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.notifications.Auditor;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;

public class TransportDeleteJobAction
extends TransportMasterNodeAction<DeleteJobAction.Request, AcknowledgedResponse> {
    private static final int MAX_SNAPSHOTS_TO_DELETE = 10000;
    private final Client client;
    private final PersistentTasksService persistentTasksService;
    private final Auditor auditor;
    private final JobResultsProvider jobResultsProvider;
    private final Map<String, List<ActionListener<AcknowledgedResponse>>> listenersByJobId;

    @Inject
    public TransportDeleteJobAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, PersistentTasksService persistentTasksService, Client client, Auditor auditor, JobResultsProvider jobResultsProvider) {
        super("cluster:admin/xpack/ml/job/delete", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, DeleteJobAction.Request::new);
        this.client = client;
        this.persistentTasksService = persistentTasksService;
        this.auditor = auditor;
        this.jobResultsProvider = jobResultsProvider;
        this.listenersByJobId = new HashMap<String, List<ActionListener<AcknowledgedResponse>>>();
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    protected ClusterBlockException checkBlock(DeleteJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(DeleteJobAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        throw new UnsupportedOperationException("the Task parameter is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void masterOperation(Task task, DeleteJobAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.logger.debug("Deleting job '{}'", (Object)request.getJobId());
        JobManager.getJobOrThrowIfUnknown(request.getJobId(), state);
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ParentTaskAssigningClient parentTaskClient = new ParentTaskAssigningClient(this.client, taskId);
        Map<String, List<ActionListener<AcknowledgedResponse>>> map = this.listenersByJobId;
        synchronized (map) {
            if (this.listenersByJobId.containsKey(request.getJobId())) {
                this.logger.debug("[{}] Deletion task [{}] will wait for existing deletion task to complete", (Object)request.getJobId(), (Object)task.getId());
                this.listenersByJobId.get(request.getJobId()).add(listener);
                return;
            }
            ArrayList<ActionListener<AcknowledgedResponse>> listeners = new ArrayList<ActionListener<AcknowledgedResponse>>();
            listeners.add(listener);
            this.listenersByJobId.put(request.getJobId(), listeners);
        }
        this.auditor.info(request.getJobId(), Messages.getMessage((String)"Deleting job by task with id ''{0}''", (Object[])new Object[]{taskId}));
        ActionListener finalListener = ActionListener.wrap(ack -> this.notifyListeners(request.getJobId(), (AcknowledgedResponse)ack, null), e -> this.notifyListeners(request.getJobId(), null, (Exception)e));
        ActionListener markAsDeletingListener = ActionListener.wrap(response -> {
            if (request.isForce()) {
                this.forceDeleteJob(parentTaskClient, request, (ActionListener<AcknowledgedResponse>)finalListener);
            } else {
                this.normalDeleteJob(parentTaskClient, request, (ActionListener<AcknowledgedResponse>)finalListener);
            }
        }, e -> {
            this.auditor.error(request.getJobId(), Messages.getMessage((String)"Error deleting job: {0}", (Object[])new Object[]{e.getMessage()}));
            finalListener.onFailure(e);
        });
        this.markJobAsDeleting(request.getJobId(), (ActionListener<Boolean>)markAsDeletingListener, request.isForce());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String jobId, @Nullable AcknowledgedResponse ack, @Nullable Exception error) {
        Map<String, List<ActionListener<AcknowledgedResponse>>> map = this.listenersByJobId;
        synchronized (map) {
            List<ActionListener<AcknowledgedResponse>> listeners = this.listenersByJobId.remove(jobId);
            if (listeners == null) {
                this.logger.error("[{}] No deletion job listeners could be found", (Object)jobId);
                return;
            }
            for (ActionListener<AcknowledgedResponse> listener : listeners) {
                if (error != null) {
                    listener.onFailure(error);
                    continue;
                }
                listener.onResponse((Object)ack);
            }
        }
    }

    private void normalDeleteJob(ParentTaskAssigningClient parentTaskClient, DeleteJobAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        final String jobId = request.getJobId();
        CheckedConsumer apiResponseHandler = jobDeleted -> {
            if (jobDeleted.booleanValue()) {
                this.logger.info("Job [" + jobId + "] deleted");
                this.auditor.info(jobId, Messages.getMessage((String)"Job deleted"));
                listener.onResponse((Object)new AcknowledgedResponse(true));
            } else {
                listener.onResponse((Object)new AcknowledgedResponse(false));
            }
        };
        CheckedConsumer deleteJobStateHandler = response -> this.clusterService.submitStateUpdateTask("delete-job-" + jobId, (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<Boolean>((AckedRequest)request, ActionListener.wrap((CheckedConsumer)apiResponseHandler, arg_0 -> ((ActionListener)listener).onFailure(arg_0))){

            protected Boolean newResponse(boolean acknowledged) {
                return acknowledged && response != false;
            }

            public ClusterState execute(ClusterState currentState) {
                MlMetadata currentMlMetadata = MlMetadata.getMlMetadata((ClusterState)currentState);
                if (!currentMlMetadata.getJobs().containsKey(jobId)) {
                    return currentState;
                }
                MlMetadata.Builder builder = new MlMetadata.Builder(currentMlMetadata);
                builder.deleteJob(jobId, (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks"));
                return TransportDeleteJobAction.buildNewClusterState(currentState, builder);
            }
        });
        CheckedConsumer removeFromCalendarsHandler = response -> this.jobResultsProvider.removeJobFromCalendars(jobId, (ActionListener<Boolean>)ActionListener.wrap(arg_0 -> ((CheckedConsumer)deleteJobStateHandler).accept(arg_0), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        this.deleteJobDocuments(parentTaskClient, jobId, (CheckedConsumer<Boolean, Exception>)removeFromCalendarsHandler, arg_0 -> listener.onFailure(arg_0));
    }

    private void deleteJobDocuments(ParentTaskAssigningClient parentTaskClient, String jobId, CheckedConsumer<Boolean, Exception> finishedHandler, Consumer<Exception> failureHandler) {
        String indexName = AnomalyDetectorsIndex.getPhysicalIndexFromState((ClusterState)this.clusterService.state(), (String)jobId);
        String indexPattern = indexName + "-*";
        ActionListener completionHandler = ActionListener.wrap(response -> finishedHandler.accept((Object)response.isAcknowledged()), failureHandler);
        ActionListener dbqHandler = ActionListener.wrap(bulkByScrollResponse -> {
            if (bulkByScrollResponse == null) {
                completionHandler.onResponse((Object)new AcknowledgedResponse(true));
            } else {
                if (bulkByScrollResponse.isTimedOut()) {
                    this.logger.warn("[{}] DeleteByQuery for indices [{}, {}] timed out.", (Object)jobId, (Object)indexName, (Object)indexPattern);
                }
                if (!bulkByScrollResponse.getBulkFailures().isEmpty()) {
                    this.logger.warn("[{}] {} failures and {} conflicts encountered while running DeleteByQuery on indices [{}, {}].", (Object)jobId, (Object)bulkByScrollResponse.getBulkFailures().size(), (Object)bulkByScrollResponse.getVersionConflicts(), (Object)indexName, (Object)indexPattern);
                    for (BulkItemResponse.Failure failure : bulkByScrollResponse.getBulkFailures()) {
                        this.logger.warn("DBQ failure: " + failure);
                    }
                }
                this.deleteAliases(parentTaskClient, jobId, (ActionListener<AcknowledgedResponse>)completionHandler);
            }
        }, failureHandler);
        ActionListener deleteByQueryExecutor = ActionListener.wrap(response -> {
            if (response.booleanValue()) {
                this.logger.info("Running DBQ on [" + indexName + "," + indexPattern + "] for job [" + jobId + "]");
                DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexName, indexPattern});
                ConstantScoreQueryBuilder query = new ConstantScoreQueryBuilder((QueryBuilder)new TermQueryBuilder(Job.ID.getPreferredName(), jobId));
                request.setQuery((QueryBuilder)query);
                request.setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen()));
                request.setSlices(5);
                request.setAbortOnVersionConflict(false);
                request.setRefresh(true);
                ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (Action)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)dbqHandler);
            } else {
                dbqHandler.onResponse(null);
            }
        }, failureHandler);
        ActionListener customIndexSearchHandler = ActionListener.wrap(searchResponse -> {
            if (searchResponse == null || searchResponse.getHits().getTotalHits().value > 0L) {
                deleteByQueryExecutor.onResponse((Object)true);
            } else {
                this.logger.info("Running DELETE Index on [" + indexName + "] for job [" + jobId + "]");
                DeleteIndexRequest request = new DeleteIndexRequest(indexName);
                request.indicesOptions(IndicesOptions.lenientExpandOpen());
                ClientHelper.executeAsyncWithOrigin((ThreadContext)parentTaskClient.threadPool().getThreadContext(), (String)"ml", (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> deleteByQueryExecutor.onResponse((Object)false), (Consumer)failureHandler), (arg_0, arg_1) -> ((IndicesAdminClient)parentTaskClient.admin().indices()).delete(arg_0, arg_1));
            }
        }, failure -> {
            if (failure.getClass() == IndexNotFoundException.class) {
                deleteByQueryExecutor.onResponse((Object)false);
            } else {
                failureHandler.accept((Exception)failure);
            }
        });
        ActionListener deleteCategorizerStateHandler = ActionListener.wrap(response -> {
            if (indexName.equals(".ml-anomalies-shared")) {
                customIndexSearchHandler.onResponse(null);
            } else {
                SearchSourceBuilder source = new SearchSourceBuilder().size(1).trackTotalHits(true).query((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)jobId))));
                SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
                searchRequest.source(source);
                ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (Action)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)customIndexSearchHandler);
            }
        }, failureHandler);
        ActionListener deleteQuantilesHandler = ActionListener.wrap(response -> this.deleteCategorizerState(parentTaskClient, jobId, 1, (ActionListener<Boolean>)deleteCategorizerStateHandler), failureHandler);
        ActionListener deleteStateHandler = ActionListener.wrap(bulkResponse -> this.deleteQuantiles(parentTaskClient, jobId, (ActionListener<Boolean>)deleteQuantilesHandler), failureHandler);
        this.deleteModelState(parentTaskClient, jobId, (ActionListener<BulkResponse>)deleteStateHandler);
    }

    private void deleteQuantiles(ParentTaskAssigningClient parentTaskClient, String jobId, ActionListener<Boolean> finishedHandler) {
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexName()});
        IdsQueryBuilder query = new IdsQueryBuilder().addIds(new String[]{Quantiles.documentId((String)jobId), Quantiles.v54DocumentId((String)jobId)});
        request.setQuery((QueryBuilder)query);
        request.setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen()));
        request.setAbortOnVersionConflict(false);
        request.setRefresh(true);
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (Action)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> finishedHandler.onResponse((Object)true), e -> {
            if (e instanceof IndexNotFoundException) {
                finishedHandler.onResponse((Object)true);
            } else {
                finishedHandler.onFailure(e);
            }
        }));
    }

    private void deleteModelState(ParentTaskAssigningClient parentTaskClient, String jobId, ActionListener<BulkResponse> listener) {
        GetModelSnapshotsAction.Request request = new GetModelSnapshotsAction.Request(jobId, null);
        request.setPageParams(new PageParams(0, 10000));
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (Action)GetModelSnapshotsAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> {
            List deleteCandidates = response.getPage().results();
            JobDataDeleter deleter = new JobDataDeleter((Client)parentTaskClient, jobId);
            deleter.deleteModelSnapshots(deleteCandidates, listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void deleteCategorizerState(ParentTaskAssigningClient parentTaskClient, String jobId, int docNum, ActionListener<Boolean> finishedHandler) {
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexName()});
        IdsQueryBuilder query = new IdsQueryBuilder().addIds(new String[]{CategorizerState.documentId((String)jobId, (int)docNum), CategorizerState.v54DocumentId((String)jobId, (int)docNum)});
        request.setQuery((QueryBuilder)query);
        request.setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen()));
        request.setAbortOnVersionConflict(false);
        request.setRefresh(true);
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (Action)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> {
            if (response.getDeleted() > 0L) {
                this.deleteCategorizerState(parentTaskClient, jobId, docNum + 1, finishedHandler);
                return;
            }
            finishedHandler.onResponse((Object)true);
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                finishedHandler.onResponse((Object)true);
            } else {
                finishedHandler.onFailure(e);
            }
        }));
    }

    private void deleteAliases(ParentTaskAssigningClient parentTaskClient, String jobId, ActionListener<AcknowledgedResponse> finishedHandler) {
        String readAliasName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        String writeAliasName = AnomalyDetectorsIndex.resultsWriteAlias((String)jobId);
        GetAliasesRequest aliasesRequest = new GetAliasesRequest().aliases(new String[]{readAliasName, writeAliasName}).indicesOptions(IndicesOptions.lenientExpandOpen());
        ClientHelper.executeAsyncWithOrigin((ThreadContext)parentTaskClient.threadPool().getThreadContext(), (String)"ml", (ActionRequest)aliasesRequest, (ActionListener)ActionListener.wrap(getAliasesResponse -> {
            IndicesAliasesRequest removeRequest = this.buildRemoveAliasesRequest((GetAliasesResponse)getAliasesResponse);
            if (removeRequest == null) {
                finishedHandler.onResponse((Object)new AcknowledgedResponse(true));
                return;
            }
            ClientHelper.executeAsyncWithOrigin((ThreadContext)parentTaskClient.threadPool().getThreadContext(), (String)"ml", (ActionRequest)removeRequest, (ActionListener)ActionListener.wrap(arg_0 -> ((ActionListener)finishedHandler).onResponse(arg_0), arg_0 -> ((ActionListener)finishedHandler).onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)parentTaskClient.admin().indices()).aliases(arg_0, arg_1));
        }, arg_0 -> finishedHandler.onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)parentTaskClient.admin().indices()).getAliases(arg_0, arg_1));
    }

    private IndicesAliasesRequest buildRemoveAliasesRequest(GetAliasesResponse getAliasesResponse) {
        HashSet aliases = new HashSet();
        ArrayList<String> indices = new ArrayList<String>();
        for (ObjectObjectCursor entry : getAliasesResponse.getAliases()) {
            if (((List)entry.value).isEmpty()) continue;
            indices.add((String)entry.key);
            ((List)entry.value).forEach(metadata -> aliases.add(metadata.getAlias()));
        }
        return aliases.isEmpty() ? null : new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.remove().aliases(aliases.toArray(new String[aliases.size()])).indices(indices.toArray(new String[indices.size()])));
    }

    private void forceDeleteJob(final ParentTaskAssigningClient parentTaskClient, final DeleteJobAction.Request request, final ActionListener<AcknowledgedResponse> listener) {
        this.logger.debug("Force deleting job [{}]", (Object)request.getJobId());
        ClusterState state = this.clusterService.state();
        String jobId = request.getJobId();
        ActionListener<Boolean> removeTaskListener = new ActionListener<Boolean>(){

            public void onResponse(Boolean response) {
                TransportDeleteJobAction.this.normalDeleteJob(parentTaskClient, request, (ActionListener<AcknowledgedResponse>)listener);
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceNotFoundException) {
                    TransportDeleteJobAction.this.normalDeleteJob(parentTaskClient, request, (ActionListener<AcknowledgedResponse>)listener);
                } else {
                    listener.onFailure(e);
                }
            }
        };
        ActionListener killJobListener = ActionListener.wrap(arg_0 -> this.lambda$forceDeleteJob$23(request, state, (ActionListener)removeTaskListener, arg_0), arg_0 -> this.lambda$forceDeleteJob$24(request, state, (ActionListener)removeTaskListener, listener, arg_0));
        this.killProcess(parentTaskClient, jobId, (ActionListener<KillProcessAction.Response>)killJobListener);
    }

    private void killProcess(ParentTaskAssigningClient parentTaskClient, String jobId, ActionListener<KillProcessAction.Response> listener) {
        KillProcessAction.Request killRequest = new KillProcessAction.Request(jobId);
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (Action)KillProcessAction.INSTANCE, (ActionRequest)killRequest, listener);
    }

    private void removePersistentTask(String jobId, ClusterState currentState, final ActionListener<Boolean> listener) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
        PersistentTasksCustomMetaData.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetaData)tasks);
        if (jobTask == null) {
            listener.onResponse(null);
        } else {
            this.persistentTasksService.sendRemoveRequest(jobTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                    listener.onResponse((Object)Boolean.TRUE);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    private void markJobAsDeleting(final String jobId, final ActionListener<Boolean> listener, final boolean force) {
        this.clusterService.submitStateUpdateTask("mark-job-as-deleted", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)currentState.metaData().custom("persistent_tasks");
                MlMetadata.Builder builder = new MlMetadata.Builder(MlMetadata.getMlMetadata((ClusterState)currentState));
                builder.markJobAsDeleting(jobId, tasks, force);
                return TransportDeleteJobAction.buildNewClusterState(currentState, builder);
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                TransportDeleteJobAction.this.logger.debug("Job [" + jobId + "] is successfully marked as deleted");
                listener.onResponse((Object)true);
            }
        });
    }

    static boolean jobIsDeletedFromState(String jobId, ClusterState clusterState) {
        return !MlMetadata.getMlMetadata((ClusterState)clusterState).getJobs().containsKey(jobId);
    }

    private static ClusterState buildNewClusterState(ClusterState currentState, MlMetadata.Builder builder) {
        ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
        newState.metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ml", (MetaData.Custom)builder.build()).build());
        return newState.build();
    }

    private /* synthetic */ void lambda$forceDeleteJob$24(DeleteJobAction.Request request, ClusterState state, ActionListener removeTaskListener, ActionListener listener, Exception e) {
        if (e instanceof ElasticsearchStatusException) {
            this.removePersistentTask(request.getJobId(), state, (ActionListener<Boolean>)removeTaskListener);
        } else {
            listener.onFailure(e);
        }
    }

    private /* synthetic */ void lambda$forceDeleteJob$23(DeleteJobAction.Request request, ClusterState state, ActionListener removeTaskListener, KillProcessAction.Response response) throws Exception {
        this.removePersistentTask(request.getJobId(), state, (ActionListener<Boolean>)removeTaskListener);
    }
}

