/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.nio;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.net.ssl.SSLEngine;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.nio.FlushOperation;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.nio.ReadWriteHandler;
import org.elasticsearch.nio.SocketChannelContext;
import org.elasticsearch.nio.WriteOperation;
import org.elasticsearch.xpack.security.transport.nio.SSLDriver;

public final class SSLChannelContext
extends SocketChannelContext {
    private final SSLDriver sslDriver;

    SSLChannelContext(NioSocketChannel channel, NioSelector selector, Consumer<Exception> exceptionHandler, SSLDriver sslDriver, ReadWriteHandler readWriteHandler, InboundChannelBuffer channelBuffer) {
        this(channel, selector, exceptionHandler, sslDriver, readWriteHandler, channelBuffer, ALWAYS_ALLOW_CHANNEL);
    }

    SSLChannelContext(NioSocketChannel channel, NioSelector selector, Consumer<Exception> exceptionHandler, SSLDriver sslDriver, ReadWriteHandler readWriteHandler, InboundChannelBuffer channelBuffer, Predicate<NioSocketChannel> allowChannelPredicate) {
        super(channel, selector, exceptionHandler, readWriteHandler, channelBuffer, allowChannelPredicate);
        this.sslDriver = sslDriver;
    }

    public void register() throws IOException {
        super.register();
        this.sslDriver.init();
    }

    public void queueWriteOperation(WriteOperation writeOperation) {
        this.getSelector().assertOnSelectorThread();
        if (writeOperation instanceof CloseNotifyOperation) {
            this.sslDriver.initiateClose();
        } else {
            super.queueWriteOperation(writeOperation);
        }
    }

    public void flushChannel() throws IOException {
        if (this.closeNow()) {
            return;
        }
        if (this.sslDriver.hasFlushPending()) {
            this.flushToChannel(this.sslDriver.getNetworkWriteBuffer());
            if (this.sslDriver.hasFlushPending()) {
                return;
            }
        }
        if (this.sslDriver.readyForApplicationWrites()) {
            FlushOperation currentFlush;
            while (!this.sslDriver.hasFlushPending() && (currentFlush = this.getPendingFlush()) != null) {
                if (currentFlush.isFullyFlushed()) {
                    this.currentFlushOperationComplete();
                    continue;
                }
                try {
                    int bytesEncrypted = this.sslDriver.applicationWrite(currentFlush.getBuffersToWrite());
                    if (bytesEncrypted != 0) {
                        currentFlush.incrementIndex(bytesEncrypted);
                        this.flushToChannel(this.sslDriver.getNetworkWriteBuffer());
                        continue;
                    }
                    break;
                }
                catch (IOException e) {
                    this.currentFlushOperationFailed(e);
                    throw e;
                }
            }
        } else {
            while (!this.sslDriver.hasFlushPending() && this.sslDriver.needsNonApplicationWrite()) {
                this.sslDriver.nonApplicationWrite();
                if (!this.sslDriver.hasFlushPending()) continue;
                this.flushToChannel(this.sslDriver.getNetworkWriteBuffer());
            }
        }
    }

    public boolean readyForFlush() {
        this.getSelector().assertOnSelectorThread();
        if (this.sslDriver.readyForApplicationWrites()) {
            return this.sslDriver.hasFlushPending() || super.readyForFlush();
        }
        return this.sslDriver.hasFlushPending() || this.sslDriver.needsNonApplicationWrite();
    }

    public int read() throws IOException {
        int bytesRead = 0;
        if (this.closeNow()) {
            return bytesRead;
        }
        bytesRead = this.readFromChannel(this.sslDriver.getNetworkReadBuffer());
        if (bytesRead == 0) {
            return bytesRead;
        }
        this.sslDriver.read(this.channelBuffer);
        this.handleReadBytes();
        return bytesRead;
    }

    public boolean selectorShouldClose() {
        return this.closeNow() || this.sslDriver.isClosed();
    }

    public void closeChannel() {
        if (this.isClosing.compareAndSet(false, true)) {
            CloseNotifyOperation writeOperation = new CloseNotifyOperation(this);
            NioSelector selector = this.getSelector();
            if (!selector.isOnCurrentThread()) {
                selector.queueWrite((WriteOperation)writeOperation);
                return;
            }
            selector.writeToChannel((WriteOperation)writeOperation);
        }
    }

    public void closeFromSelector() throws IOException {
        this.getSelector().assertOnSelectorThread();
        if (this.channel.isOpen()) {
            Closeable[] closeableArray = new Closeable[2];
            closeableArray[0] = () -> super.closeFromSelector();
            closeableArray[1] = this.sslDriver::close;
            IOUtils.close((Closeable[])closeableArray);
        }
    }

    public SSLEngine getSSLEngine() {
        return this.sslDriver.getSSLEngine();
    }

    private static class CloseNotifyOperation
    implements WriteOperation {
        private static final BiConsumer<Void, Exception> LISTENER = (v, t) -> {};
        private static final Object WRITE_OBJECT = new Object();
        private final SocketChannelContext channelContext;

        private CloseNotifyOperation(SocketChannelContext channelContext) {
            this.channelContext = channelContext;
        }

        public BiConsumer<Void, Exception> getListener() {
            return LISTENER;
        }

        public SocketChannelContext getChannel() {
            return this.channelContext;
        }

        public Object getObject() {
            return WRITE_OBJECT;
        }
    }
}

