/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.PutRoleResponse;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class TransportPutRoleAction
extends HandledTransportAction<PutRoleRequest, PutRoleResponse> {
    private final NativeRolesStore rolesStore;

    @Inject
    public TransportPutRoleAction(ActionFilters actionFilters, NativeRolesStore rolesStore, TransportService transportService) {
        super("cluster:admin/xpack/security/role/put", transportService, actionFilters, PutRoleRequest::new);
        this.rolesStore = rolesStore;
    }

    protected void doExecute(Task task, final PutRoleRequest request, final ActionListener<PutRoleResponse> listener) {
        String name = request.roleDescriptor().getName();
        if (ReservedRolesStore.isReserved((String)name)) {
            listener.onFailure((Exception)new IllegalArgumentException("role [" + name + "] is reserved and cannot be modified."));
            return;
        }
        this.rolesStore.putRole(request, request.roleDescriptor(), new ActionListener<Boolean>(){

            public void onResponse(Boolean created) {
                if (created.booleanValue()) {
                    TransportPutRoleAction.this.logger.info("added role [{}]", (Object)request.name());
                } else {
                    TransportPutRoleAction.this.logger.info("updated role [{}]", (Object)request.name());
                }
                listener.onResponse((Object)new PutRoleResponse(created.booleanValue()));
            }

            public void onFailure(Exception t) {
                listener.onFailure(t);
            }
        });
    }
}

