/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.interceptor;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.security.action.interceptor.FieldAndDocumentLevelSecurityRequestInterceptor;

public class SearchRequestInterceptor
extends FieldAndDocumentLevelSecurityRequestInterceptor<SearchRequest> {
    public SearchRequestInterceptor(ThreadPool threadPool, XPackLicenseState licenseState) {
        super(threadPool.getThreadContext(), licenseState);
    }

    @Override
    public void disableFeatures(SearchRequest request, boolean fieldLevelSecurityEnabled, boolean documentLevelSecurityEnabled) {
        request.requestCache(Boolean.valueOf(false));
        if (documentLevelSecurityEnabled) {
            if (request.source() != null && request.source().suggest() != null) {
                throw new ElasticsearchSecurityException("Suggest isn't supported if document level security is enabled", RestStatus.BAD_REQUEST, new Object[0]);
            }
            if (request.source() != null && request.source().profile()) {
                throw new ElasticsearchSecurityException("A search request cannot be profiled if document level security is enabled", RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
    }

    @Override
    public boolean supports(TransportRequest request) {
        return request instanceof SearchRequest;
    }
}

