/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade.actions;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.migration.IndexUpgradeInfoRequest;
import org.elasticsearch.protocol.xpack.migration.IndexUpgradeInfoResponse;
import org.elasticsearch.protocol.xpack.migration.UpgradeActionRequired;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.upgrade.IndexUpgradeService;

public class TransportIndexUpgradeInfoAction
extends TransportMasterNodeReadAction<IndexUpgradeInfoRequest, IndexUpgradeInfoResponse> {
    private final IndexUpgradeService indexUpgradeService;
    private final XPackLicenseState licenseState;

    @Inject
    public TransportIndexUpgradeInfoAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexUpgradeService indexUpgradeService, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState) {
        super("cluster:admin/xpack/upgrade/info", transportService, clusterService, threadPool, actionFilters, IndexUpgradeInfoRequest::new, indexNameExpressionResolver);
        this.indexUpgradeService = indexUpgradeService;
        this.licenseState = licenseState;
    }

    protected String executor() {
        return "generic";
    }

    protected IndexUpgradeInfoResponse newResponse() {
        return new IndexUpgradeInfoResponse();
    }

    protected ClusterBlockException checkBlock(IndexUpgradeInfoRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected final void masterOperation(IndexUpgradeInfoRequest request, ClusterState state, ActionListener<IndexUpgradeInfoResponse> listener) {
        if (this.licenseState.isUpgradeAllowed()) {
            Map<String, UpgradeActionRequired> results = this.indexUpgradeService.upgradeInfo(request.indices(), request.indicesOptions(), state);
            listener.onResponse((Object)new IndexUpgradeInfoResponse(results));
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"upgrade"));
        }
    }
}

