/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleExecutionState;
import org.elasticsearch.xpack.core.indexlifecycle.Step;
import org.elasticsearch.xpack.core.indexlifecycle.action.RetryAction;
import org.elasticsearch.xpack.indexlifecycle.IndexLifecycleService;

public class TransportRetryAction
extends TransportMasterNodeAction<RetryAction.Request, RetryAction.Response> {
    IndexLifecycleService indexLifecycleService;

    @Inject
    public TransportRetryAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexLifecycleService indexLifecycleService) {
        super("indices:admin/ilm/retry", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, RetryAction.Request::new);
        this.indexLifecycleService = indexLifecycleService;
    }

    protected String executor() {
        return "same";
    }

    protected RetryAction.Response newResponse() {
        return new RetryAction.Response();
    }

    protected void masterOperation(final RetryAction.Request request, ClusterState state, ActionListener<RetryAction.Response> listener) {
        this.clusterService.submitStateUpdateTask("ilm-re-run", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<RetryAction.Response>((AckedRequest)request, listener){

            public ClusterState execute(ClusterState currentState) {
                return TransportRetryAction.this.indexLifecycleService.moveClusterStateToFailedStep(currentState, request.indices());
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                for (String index : request.indices()) {
                    IndexMetaData idxMeta = newState.metaData().index(index);
                    LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetaData)idxMeta);
                    Step.StepKey retryStep = new Step.StepKey(lifecycleState.getPhase(), lifecycleState.getAction(), lifecycleState.getStep());
                    if (idxMeta == null) {
                        TransportRetryAction.this.logger.debug("index [" + index + "] has been deleted after moving to step [" + lifecycleState.getStep() + "], skipping async action check");
                        return;
                    }
                    TransportRetryAction.this.indexLifecycleService.maybeRunAsyncAction(newState, idxMeta, retryStep);
                }
            }

            protected RetryAction.Response newResponse(boolean acknowledged) {
                return new RetryAction.Response(acknowledged);
            }
        });
    }

    protected ClusterBlockException checkBlock(RetryAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

