/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.action.ShardFollowTask;
import org.elasticsearch.xpack.core.ccr.action.UnfollowAction;

public class TransportUnfollowAction
extends TransportMasterNodeAction<UnfollowAction.Request, AcknowledgedResponse> {
    @Inject
    public TransportUnfollowAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/xpack/ccr/unfollow", transportService, clusterService, threadPool, actionFilters, UnfollowAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    protected void masterOperation(final UnfollowAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("unfollow_action", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState current) throws Exception {
                String followerIndex = request.getFollowerIndex();
                return TransportUnfollowAction.unfollow(followerIndex, current);
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }
        });
    }

    protected ClusterBlockException checkBlock(UnfollowAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    static ClusterState unfollow(String followerIndex, ClusterState current) {
        IndexMetaData followerIMD = current.metaData().index(followerIndex);
        if (followerIMD == null) {
            throw new IndexNotFoundException(followerIndex);
        }
        if (followerIMD.getCustomData("ccr") == null) {
            throw new IllegalArgumentException("index [" + followerIndex + "] is not a follower index");
        }
        if (followerIMD.getState() != IndexMetaData.State.CLOSE) {
            throw new IllegalArgumentException("cannot convert the follower index [" + followerIndex + "] to a non-follower, because it has not been closed");
        }
        PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)current.metaData().custom("persistent_tasks");
        if (persistentTasks != null) {
            for (PersistentTasksCustomMetaData.PersistentTask persistentTask : persistentTasks.tasks()) {
                ShardFollowTask shardFollowTask;
                if (!persistentTask.getTaskName().equals("xpack/ccr/shard_follow_task") || !(shardFollowTask = (ShardFollowTask)persistentTask.getParams()).getFollowShardId().getIndexName().equals(followerIndex)) continue;
                throw new IllegalArgumentException("cannot convert the follower index [" + followerIndex + "] to a non-follower, because it has not been paused");
            }
        }
        IndexMetaData.Builder newIMD = IndexMetaData.builder((IndexMetaData)followerIMD);
        Settings.Builder builder = Settings.builder();
        builder.put(followerIMD.getSettings());
        builder.remove(CcrSettings.CCR_FOLLOWING_INDEX_SETTING.getKey());
        newIMD.settings(builder);
        newIMD.removeCustom("ccr");
        MetaData newMetaData = MetaData.builder((MetaData)current.metaData()).put(newIMD).build();
        return ClusterState.builder((ClusterState)current).metaData(newMetaData).build();
    }
}

