/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.MaxRetryAllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexingSlowLog;
import org.elasticsearch.index.MergePolicyConfig;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.SearchSlowLog;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesRequestCache;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.action.ResponseHandler;
import org.elasticsearch.xpack.ccr.action.ShardFollowTask;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;

public class TransportResumeFollowAction
extends TransportMasterNodeAction<ResumeFollowAction.Request, AcknowledgedResponse> {
    static final ByteSizeValue DEFAULT_MAX_READ_REQUEST_SIZE = new ByteSizeValue(32L, ByteSizeUnit.MB);
    static final ByteSizeValue DEFAULT_MAX_WRITE_REQUEST_SIZE = new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES);
    private static final TimeValue DEFAULT_MAX_RETRY_DELAY = new TimeValue(500L);
    private static final int DEFAULT_MAX_OUTSTANDING_WRITE_REQUESTS = 9;
    private static final int DEFAULT_MAX_WRITE_BUFFER_COUNT = Integer.MAX_VALUE;
    private static final ByteSizeValue DEFAULT_MAX_WRITE_BUFFER_SIZE = new ByteSizeValue(512L, ByteSizeUnit.MB);
    private static final int DEFAULT_MAX_READ_REQUEST_OPERATION_COUNT = 5120;
    private static final int DEFAULT_MAX_WRITE_REQUEST_OPERATION_COUNT = 5120;
    private static final int DEFAULT_MAX_OUTSTANDING_READ_REQUESTS = 12;
    static final TimeValue DEFAULT_READ_POLL_TIMEOUT = TimeValue.timeValueMinutes((long)1L);
    private final Client client;
    private final ThreadPool threadPool;
    private final PersistentTasksService persistentTasksService;
    private final IndicesService indicesService;
    private final CcrLicenseChecker ccrLicenseChecker;
    static final Set<Setting<?>> WHITE_LISTED_SETTINGS;

    @Inject
    public TransportResumeFollowAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, PersistentTasksService persistentTasksService, IndicesService indicesService, CcrLicenseChecker ccrLicenseChecker) {
        super("cluster:admin/xpack/ccr/resume_follow", true, transportService, clusterService, threadPool, actionFilters, ResumeFollowAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        this.threadPool = threadPool;
        this.persistentTasksService = persistentTasksService;
        this.indicesService = indicesService;
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    protected ClusterBlockException checkBlock(ResumeFollowAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(ResumeFollowAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        IndexMetaData followerIndexMetadata = state.getMetaData().index(request.getFollowerIndex());
        if (followerIndexMetadata == null) {
            listener.onFailure((Exception)new IndexNotFoundException(request.getFollowerIndex()));
            return;
        }
        Map ccrMetadata = followerIndexMetadata.getCustomData("ccr");
        if (ccrMetadata == null) {
            throw new IllegalArgumentException("follow index [" + request.getFollowerIndex() + "] does not have ccr metadata");
        }
        String leaderCluster = (String)ccrMetadata.get("remote_cluster_name");
        this.client.getRemoteClusterClient(leaderCluster);
        String leaderIndex = (String)ccrMetadata.get("leader_index_name");
        this.ccrLicenseChecker.checkRemoteClusterLicenseAndFetchLeaderIndexMetadataAndHistoryUUIDs(this.client, leaderCluster, leaderIndex, arg_0 -> listener.onFailure(arg_0), (leaderHistoryUUID, leaderIndexMetadata) -> {
            try {
                this.start(request, leaderCluster, (IndexMetaData)leaderIndexMetadata, followerIndexMetadata, (String[])leaderHistoryUUID, listener);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        });
    }

    void start(ResumeFollowAction.Request request, String clusterNameAlias, IndexMetaData leaderIndexMetadata, IndexMetaData followIndexMetadata, String[] leaderIndexHistoryUUIDs, ActionListener<AcknowledgedResponse> listener) throws IOException {
        MapperService mapperService = followIndexMetadata != null ? this.indicesService.createIndexMapperService(followIndexMetadata) : null;
        TransportResumeFollowAction.validate(request, leaderIndexMetadata, followIndexMetadata, leaderIndexHistoryUUIDs, mapperService);
        int numShards = followIndexMetadata.getNumberOfShards();
        ResponseHandler handler = new ResponseHandler(numShards, listener);
        Map<String, String> filteredHeaders = this.threadPool.getThreadContext().getHeaders().entrySet().stream().filter(e -> ShardFollowTask.HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (int shardId = 0; shardId < numShards; ++shardId) {
            String taskId = followIndexMetadata.getIndexUUID() + "-" + shardId;
            ShardFollowTask shardFollowTask = TransportResumeFollowAction.createShardFollowTask(shardId, clusterNameAlias, request, leaderIndexMetadata, followIndexMetadata, filteredHeaders);
            this.persistentTasksService.sendStartRequest(taskId, "xpack/ccr/shard_follow_task", (PersistentTaskParams)shardFollowTask, handler.getActionListener(shardId));
        }
    }

    static void validate(ResumeFollowAction.Request request, IndexMetaData leaderIndex, IndexMetaData followIndex, String[] leaderIndexHistoryUUID, MapperService followerMapperService) {
        Settings followerSettings;
        String recordedLeaderIndexUUID;
        Map ccrIndexMetadata = followIndex.getCustomData("ccr");
        if (ccrIndexMetadata == null) {
            throw new IllegalArgumentException("follow index [" + followIndex.getIndex().getName() + "] does not have ccr metadata");
        }
        String leaderIndexUUID = leaderIndex.getIndex().getUUID();
        if (!leaderIndexUUID.equals(recordedLeaderIndexUUID = (String)ccrIndexMetadata.get("leader_index_uuid"))) {
            throw new IllegalArgumentException("follow index [" + request.getFollowerIndex() + "] should reference [" + leaderIndexUUID + "] as leader index but instead reference [" + recordedLeaderIndexUUID + "] as leader index");
        }
        String[] recordedHistoryUUIDs = TransportResumeFollowAction.extractLeaderShardHistoryUUIDs(ccrIndexMetadata);
        assert (recordedHistoryUUIDs.length == leaderIndexHistoryUUID.length);
        for (int i = 0; i < leaderIndexHistoryUUID.length; ++i) {
            String recordedLeaderIndexHistoryUUID = recordedHistoryUUIDs[i];
            String actualLeaderIndexHistoryUUID = leaderIndexHistoryUUID[i];
            if (recordedLeaderIndexHistoryUUID.equals(actualLeaderIndexHistoryUUID)) continue;
            throw new IllegalArgumentException("leader shard [" + request.getFollowerIndex() + "][" + i + "] should reference [" + recordedLeaderIndexHistoryUUID + "] as history uuid but instead reference [" + actualLeaderIndexHistoryUUID + "] as history uuid");
        }
        if (!leaderIndex.getSettings().getAsBoolean(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), Boolean.valueOf(((Version)IndexMetaData.SETTING_INDEX_VERSION_CREATED.get(leaderIndex.getSettings())).onOrAfter(Version.V_7_0_0))).booleanValue()) {
            throw new IllegalArgumentException("leader index [" + leaderIndex.getIndex().getName() + "] does not have soft deletes enabled");
        }
        if (!((Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(followIndex.getSettings())).booleanValue()) {
            throw new IllegalArgumentException("follower index [" + request.getFollowerIndex() + "] does not have soft deletes enabled");
        }
        if (leaderIndex.getNumberOfShards() != followIndex.getNumberOfShards()) {
            throw new IllegalArgumentException("leader index primary shards [" + leaderIndex.getNumberOfShards() + "] does not match with the number of shards of the follow index [" + followIndex.getNumberOfShards() + "]");
        }
        if (leaderIndex.getRoutingNumShards() != followIndex.getRoutingNumShards()) {
            throw new IllegalArgumentException("leader index number_of_routing_shards [" + leaderIndex.getRoutingNumShards() + "] does not match with the number_of_routing_shards of the follow index [" + followIndex.getRoutingNumShards() + "]");
        }
        if (leaderIndex.getState() != IndexMetaData.State.OPEN || followIndex.getState() != IndexMetaData.State.OPEN) {
            throw new IllegalArgumentException("leader and follow index must be open");
        }
        if (!((Boolean)CcrSettings.CCR_FOLLOWING_INDEX_SETTING.get(followIndex.getSettings())).booleanValue()) {
            throw new IllegalArgumentException("the following index [" + request.getFollowerIndex() + "] is not ready to follow; the setting [" + CcrSettings.CCR_FOLLOWING_INDEX_SETTING.getKey() + "] must be enabled.");
        }
        Settings leaderSettings = TransportResumeFollowAction.filter(leaderIndex.getSettings());
        if (!leaderSettings.equals((Object)(followerSettings = TransportResumeFollowAction.filter(followIndex.getSettings())))) {
            throw new IllegalArgumentException("the leader and follower index settings must be identical");
        }
        followerMapperService.merge(leaderIndex, MapperService.MergeReason.MAPPING_RECOVERY);
    }

    private static ShardFollowTask createShardFollowTask(int shardId, String clusterAliasName, ResumeFollowAction.Request request, IndexMetaData leaderIndexMetadata, IndexMetaData followIndexMetadata, Map<String, String> filteredHeaders) {
        int maxReadRequestOperationCount = request.getMaxReadRequestOperationCount() != null ? request.getMaxReadRequestOperationCount() : 5120;
        ByteSizeValue maxReadRequestSize = request.getMaxReadRequestSize() != null ? request.getMaxReadRequestSize() : DEFAULT_MAX_READ_REQUEST_SIZE;
        int maxOutstandingReadRequests = request.getMaxOutstandingReadRequests() != null ? request.getMaxOutstandingReadRequests() : 12;
        int maxWriteRequestOperationCount = request.getMaxWriteRequestOperationCount() != null ? request.getMaxWriteRequestOperationCount() : 5120;
        ByteSizeValue maxWriteRequestSize = request.getMaxWriteRequestSize() != null ? request.getMaxWriteRequestSize() : DEFAULT_MAX_WRITE_REQUEST_SIZE;
        int maxOutstandingWriteRequests = request.getMaxOutstandingWriteRequests() != null ? request.getMaxOutstandingWriteRequests() : 9;
        int maxWriteBufferCount = request.getMaxWriteBufferCount() != null ? request.getMaxWriteBufferCount() : Integer.MAX_VALUE;
        ByteSizeValue maxWriteBufferSize = request.getMaxWriteBufferSize() != null ? request.getMaxWriteBufferSize() : DEFAULT_MAX_WRITE_BUFFER_SIZE;
        TimeValue maxRetryDelay = request.getMaxRetryDelay() == null ? DEFAULT_MAX_RETRY_DELAY : request.getMaxRetryDelay();
        TimeValue readPollTimeout = request.getReadPollTimeout() == null ? DEFAULT_READ_POLL_TIMEOUT : request.getReadPollTimeout();
        return new ShardFollowTask(clusterAliasName, new ShardId(followIndexMetadata.getIndex(), shardId), new ShardId(leaderIndexMetadata.getIndex(), shardId), maxReadRequestOperationCount, maxReadRequestSize, maxOutstandingReadRequests, maxWriteRequestOperationCount, maxWriteRequestSize, maxOutstandingWriteRequests, maxWriteBufferCount, maxWriteBufferSize, maxRetryDelay, readPollTimeout, filteredHeaders);
    }

    static String[] extractLeaderShardHistoryUUIDs(Map<String, String> ccrIndexMetaData) {
        String historyUUIDs = ccrIndexMetaData.get("leader_index_shard_history_uuids");
        if (historyUUIDs == null) {
            throw new IllegalArgumentException("leader index shard UUIDs are missing");
        }
        return historyUUIDs.split(",");
    }

    static Settings filter(Settings originalSettings) {
        Settings.Builder settings = Settings.builder().put(originalSettings);
        settings.remove(CcrSettings.CCR_FOLLOWING_INDEX_SETTING.getKey());
        settings.remove(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey());
        settings.remove(IndexMetaData.SETTING_INDEX_VERSION_CREATED.getKey());
        settings.remove("index.uuid");
        settings.remove("index.provided_name");
        settings.remove("index.creation_date");
        Iterator iterator = settings.keys().iterator();
        block0: while (iterator.hasNext()) {
            String key = (String)iterator.next();
            for (Setting<?> whitelistedSetting : WHITE_LISTED_SETTINGS) {
                if (!whitelistedSetting.match(key)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return settings.build();
    }

    static {
        HashSet<Object> whiteListedSettings = new HashSet<Object>();
        whiteListedSettings.add(IndexMetaData.INDEX_NUMBER_OF_REPLICAS_SETTING);
        whiteListedSettings.add(IndexMetaData.INDEX_AUTO_EXPAND_REPLICAS_SETTING);
        whiteListedSettings.add(IndexMetaData.INDEX_ROUTING_EXCLUDE_GROUP_SETTING);
        whiteListedSettings.add(IndexMetaData.INDEX_ROUTING_INCLUDE_GROUP_SETTING);
        whiteListedSettings.add(IndexMetaData.INDEX_ROUTING_REQUIRE_GROUP_SETTING);
        whiteListedSettings.add(IndexMetaData.INDEX_READ_ONLY_SETTING);
        whiteListedSettings.add(IndexMetaData.INDEX_BLOCKS_READ_SETTING);
        whiteListedSettings.add(IndexMetaData.INDEX_BLOCKS_WRITE_SETTING);
        whiteListedSettings.add(IndexMetaData.INDEX_BLOCKS_METADATA_SETTING);
        whiteListedSettings.add(IndexMetaData.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING);
        whiteListedSettings.add(IndexMetaData.INDEX_PRIORITY_SETTING);
        whiteListedSettings.add(IndexMetaData.SETTING_WAIT_FOR_ACTIVE_SHARDS);
        whiteListedSettings.add(EnableAllocationDecider.INDEX_ROUTING_REBALANCE_ENABLE_SETTING);
        whiteListedSettings.add(EnableAllocationDecider.INDEX_ROUTING_ALLOCATION_ENABLE_SETTING);
        whiteListedSettings.add(ShardsLimitAllocationDecider.INDEX_TOTAL_SHARDS_PER_NODE_SETTING);
        whiteListedSettings.add(MaxRetryAllocationDecider.SETTING_ALLOCATION_MAX_RETRY);
        whiteListedSettings.add(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING);
        whiteListedSettings.add(IndexSettings.MAX_RESULT_WINDOW_SETTING);
        whiteListedSettings.add(IndexSettings.INDEX_WARMER_ENABLED_SETTING);
        whiteListedSettings.add(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING);
        whiteListedSettings.add(IndexSettings.MAX_RESCORE_WINDOW_SETTING);
        whiteListedSettings.add(IndexSettings.MAX_INNER_RESULT_WINDOW_SETTING);
        whiteListedSettings.add(IndexSettings.DEFAULT_FIELD_SETTING);
        whiteListedSettings.add(IndexSettings.QUERY_STRING_LENIENT_SETTING);
        whiteListedSettings.add(IndexSettings.QUERY_STRING_ANALYZE_WILDCARD);
        whiteListedSettings.add(IndexSettings.QUERY_STRING_ALLOW_LEADING_WILDCARD);
        whiteListedSettings.add(IndexSettings.ALLOW_UNMAPPED);
        whiteListedSettings.add(IndexSettings.INDEX_SEARCH_IDLE_AFTER);
        whiteListedSettings.add(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING);
        whiteListedSettings.add(IndexSettings.MAX_SCRIPT_FIELDS_SETTING);
        whiteListedSettings.add(IndexSettings.MAX_REGEX_LENGTH_SETTING);
        whiteListedSettings.add(IndexSettings.MAX_TERMS_COUNT_SETTING);
        whiteListedSettings.add(IndexSettings.MAX_ANALYZED_OFFSET_SETTING);
        whiteListedSettings.add(IndexSettings.MAX_DOCVALUE_FIELDS_SEARCH_SETTING);
        whiteListedSettings.add(IndexSettings.MAX_TOKEN_COUNT_SETTING);
        whiteListedSettings.add(IndexSettings.MAX_SLICES_PER_SCROLL);
        whiteListedSettings.add(IndexSettings.MAX_ADJACENCY_MATRIX_FILTERS_SETTING);
        whiteListedSettings.add(IndexSettings.DEFAULT_PIPELINE);
        whiteListedSettings.add(IndexSettings.INDEX_SEARCH_THROTTLED);
        whiteListedSettings.add(IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING);
        whiteListedSettings.add(IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING);
        whiteListedSettings.add(IndexSettings.INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING);
        whiteListedSettings.add(IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING);
        whiteListedSettings.add(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING);
        whiteListedSettings.add(IndexSettings.INDEX_GC_DELETES_SETTING);
        whiteListedSettings.add(IndexSettings.MAX_REFRESH_LISTENERS_PER_SHARD);
        whiteListedSettings.add(IndicesRequestCache.INDEX_CACHE_REQUEST_ENABLED_SETTING);
        whiteListedSettings.add(BitsetFilterCache.INDEX_LOAD_RANDOM_ACCESS_FILTERS_EAGERLY_SETTING);
        whiteListedSettings.add(SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG_SETTING);
        whiteListedSettings.add(SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN_SETTING);
        whiteListedSettings.add(SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO_SETTING);
        whiteListedSettings.add(SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE_SETTING);
        whiteListedSettings.add(SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN_SETTING);
        whiteListedSettings.add(SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG_SETTING);
        whiteListedSettings.add(SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO_SETTING);
        whiteListedSettings.add(SearchSlowLog.INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE_SETTING);
        whiteListedSettings.add(SearchSlowLog.INDEX_SEARCH_SLOWLOG_LEVEL);
        whiteListedSettings.add(IndexingSlowLog.INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN_SETTING);
        whiteListedSettings.add(IndexingSlowLog.INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG_SETTING);
        whiteListedSettings.add(IndexingSlowLog.INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO_SETTING);
        whiteListedSettings.add(IndexingSlowLog.INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE_SETTING);
        whiteListedSettings.add(IndexingSlowLog.INDEX_INDEXING_SLOWLOG_LEVEL_SETTING);
        whiteListedSettings.add(IndexingSlowLog.INDEX_INDEXING_SLOWLOG_REFORMAT_SETTING);
        whiteListedSettings.add(IndexingSlowLog.INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG_SETTING);
        whiteListedSettings.add(MergePolicyConfig.INDEX_COMPOUND_FORMAT_SETTING);
        whiteListedSettings.add(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING);
        whiteListedSettings.add(MergePolicyConfig.INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING);
        whiteListedSettings.add(MergePolicyConfig.INDEX_MERGE_POLICY_DELETES_PCT_ALLOWED_SETTING);
        whiteListedSettings.add(MergePolicyConfig.INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING);
        whiteListedSettings.add(MergePolicyConfig.INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING);
        whiteListedSettings.add(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT_SETTING);
        whiteListedSettings.add(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING);
        whiteListedSettings.add(MergePolicyConfig.INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT_SETTING);
        whiteListedSettings.add(MergeSchedulerConfig.AUTO_THROTTLE_SETTING);
        whiteListedSettings.add(MergeSchedulerConfig.MAX_MERGE_COUNT_SETTING);
        whiteListedSettings.add(MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING);
        whiteListedSettings.add(EngineConfig.INDEX_CODEC_SETTING);
        WHITE_LISTED_SETTINGS = Collections.unmodifiableSet(whiteListedSettings);
    }
}

