/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.AutoFollowStats;
import org.elasticsearch.xpack.core.ccr.action.PutFollowAction;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;

public class AutoFollowCoordinator
implements ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(AutoFollowCoordinator.class);
    private static final int MAX_AUTO_FOLLOW_ERRORS = 256;
    private final Client client;
    private final ClusterService clusterService;
    private final CcrLicenseChecker ccrLicenseChecker;
    private volatile Map<String, AutoFollower> autoFollowers = Collections.emptyMap();
    private long numberOfSuccessfulIndicesAutoFollowed = 0L;
    private long numberOfFailedIndicesAutoFollowed = 0L;
    private long numberOfFailedRemoteClusterStateRequests = 0L;
    private final LinkedHashMap<String, ElasticsearchException> recentAutoFollowErrors;

    public AutoFollowCoordinator(Client client, ClusterService clusterService, CcrLicenseChecker ccrLicenseChecker) {
        this.client = client;
        this.clusterService = clusterService;
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker, "ccrLicenseChecker");
        clusterService.addListener((ClusterStateListener)this);
        this.recentAutoFollowErrors = new LinkedHashMap<String, ElasticsearchException>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ElasticsearchException> eldest) {
                return this.size() > 256;
            }
        };
    }

    public synchronized AutoFollowStats getStats() {
        return new AutoFollowStats(this.numberOfFailedIndicesAutoFollowed, this.numberOfFailedRemoteClusterStateRequests, this.numberOfSuccessfulIndicesAutoFollowed, new TreeMap<String, ElasticsearchException>(this.recentAutoFollowErrors));
    }

    synchronized void updateStats(List<AutoFollowResult> results) {
        for (AutoFollowResult result : results) {
            if (result.clusterStateFetchException != null) {
                this.recentAutoFollowErrors.put(result.autoFollowPatternName, new ElasticsearchException((Throwable)result.clusterStateFetchException));
                ++this.numberOfFailedRemoteClusterStateRequests;
                LOGGER.warn((Message)new ParameterizedMessage("failure occurred while fetching cluster state for auto follow pattern [{}]", (Object)result.autoFollowPatternName), (Throwable)result.clusterStateFetchException);
                continue;
            }
            for (Map.Entry<Index, Exception> entry : result.autoFollowExecutionResults.entrySet()) {
                if (entry.getValue() != null) {
                    ++this.numberOfFailedIndicesAutoFollowed;
                    this.recentAutoFollowErrors.put(result.autoFollowPatternName + ":" + entry.getKey().getName(), ExceptionsHelper.convertToElastic((Exception)entry.getValue()));
                    LOGGER.warn((Message)new ParameterizedMessage("failure occurred while auto following index [{}] for auto follow pattern [{}]", (Object)entry.getKey(), (Object)result.autoFollowPatternName), (Throwable)entry.getValue());
                    continue;
                }
                ++this.numberOfSuccessfulIndicesAutoFollowed;
            }
        }
    }

    void updateAutoFollowers(ClusterState followerClusterState) {
        AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)followerClusterState.getMetaData().custom("ccr_auto_follow");
        if (autoFollowMetadata == null) {
            return;
        }
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            LOGGER.warn("skipping auto-follower coordination", (Throwable)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        CopyOnWriteHashMap autoFollowers = CopyOnWriteHashMap.copyOf(this.autoFollowers);
        Set newRemoteClusters = autoFollowMetadata.getPatterns().entrySet().stream().map(entry -> ((AutoFollowMetadata.AutoFollowPattern)entry.getValue()).getRemoteCluster()).filter(remoteCluster -> !autoFollowers.containsKey(remoteCluster)).collect(Collectors.toSet());
        HashMap<String, 2> newAutoFollowers = new HashMap<String, 2>(newRemoteClusters.size());
        for (String remoteCluster2 : newRemoteClusters) {
            AutoFollower autoFollower = new AutoFollower(remoteCluster2, this::updateStats, () -> ((ClusterService)this.clusterService).state()){

                @Override
                void getRemoteClusterState(String remoteCluster, long metadataVersion, BiConsumer<ClusterStateResponse, Exception> handler) {
                    ClusterStateRequest request = new ClusterStateRequest();
                    request.clear();
                    request.metaData(true);
                    request.routingTable(true);
                    request.waitForMetaDataVersion(metadataVersion);
                    AutoFollowCoordinator.this.ccrLicenseChecker.checkRemoteClusterLicenseAndFetchClusterState(AutoFollowCoordinator.this.client, remoteCluster, request, e -> handler.accept((ClusterStateResponse)null, (Exception)e), remoteClusterStateResponse -> handler.accept((ClusterStateResponse)remoteClusterStateResponse, (Exception)null));
                }

                @Override
                void createAndFollow(Map<String, String> headers, PutFollowAction.Request request, Runnable successHandler, Consumer<Exception> failureHandler) {
                    Client followerClient = CcrLicenseChecker.wrapClient(AutoFollowCoordinator.this.client, headers);
                    followerClient.execute((Action)PutFollowAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> successHandler.run(), failureHandler));
                }

                @Override
                void updateAutoFollowMetadata(final Function<ClusterState, ClusterState> updateFunction, final Consumer<Exception> handler) {
                    AutoFollowCoordinator.this.clusterService.submitStateUpdateTask("update_auto_follow_metadata", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                        public ClusterState execute(ClusterState currentState) throws Exception {
                            return (ClusterState)updateFunction.apply(currentState);
                        }

                        public void onFailure(String source, Exception e) {
                            handler.accept(e);
                        }

                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            handler.accept(null);
                        }
                    });
                }
            };
            newAutoFollowers.put(remoteCluster2, autoFollower);
            autoFollower.start();
        }
        ArrayList<String> removedRemoteClusters = new ArrayList<String>();
        for (String remoteCluster3 : autoFollowers.keySet()) {
            boolean exist = autoFollowMetadata.getPatterns().values().stream().anyMatch(pattern -> pattern.getRemoteCluster().equals(remoteCluster3));
            if (exist) continue;
            removedRemoteClusters.add(remoteCluster3);
        }
        this.autoFollowers = autoFollowers.copyAndPutAll(newAutoFollowers).copyAndRemoveAll(removedRemoteClusters);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.localNodeMaster()) {
            this.updateAutoFollowers(event.state());
        }
    }

    static class AutoFollowResult {
        final String autoFollowPatternName;
        final Exception clusterStateFetchException;
        final Map<Index, Exception> autoFollowExecutionResults;

        AutoFollowResult(String autoFollowPatternName, List<Tuple<Index, Exception>> results) {
            this.autoFollowPatternName = autoFollowPatternName;
            HashMap<Index, Exception> autoFollowExecutionResults = new HashMap<Index, Exception>();
            for (Tuple<Index, Exception> result : results) {
                autoFollowExecutionResults.put((Index)result.v1(), (Exception)result.v2());
            }
            this.clusterStateFetchException = null;
            this.autoFollowExecutionResults = Collections.unmodifiableMap(autoFollowExecutionResults);
        }

        AutoFollowResult(String autoFollowPatternName, Exception e) {
            this.autoFollowPatternName = autoFollowPatternName;
            this.clusterStateFetchException = e;
            this.autoFollowExecutionResults = Collections.emptyMap();
        }

        AutoFollowResult(String autoFollowPatternName) {
            this(autoFollowPatternName, (Exception)null);
        }
    }

    static abstract class AutoFollower {
        private final String remoteCluster;
        private final Consumer<List<AutoFollowResult>> statsUpdater;
        private final Supplier<ClusterState> followerClusterStateSupplier;
        private volatile long metadataVersion = 0L;
        private volatile CountDown autoFollowPatternsCountDown;
        private volatile AtomicArray<AutoFollowResult> autoFollowResults;

        AutoFollower(String remoteCluster, Consumer<List<AutoFollowResult>> statsUpdater, Supplier<ClusterState> followerClusterStateSupplier) {
            this.remoteCluster = remoteCluster;
            this.statsUpdater = statsUpdater;
            this.followerClusterStateSupplier = followerClusterStateSupplier;
        }

        void start() {
            ClusterState clusterState = this.followerClusterStateSupplier.get();
            AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)clusterState.metaData().custom("ccr_auto_follow");
            if (autoFollowMetadata == null) {
                LOGGER.info("AutoFollower for cluster [{}] has stopped, because there is no autofollow metadata", (Object)this.remoteCluster);
                return;
            }
            List patterns = autoFollowMetadata.getPatterns().entrySet().stream().filter(entry -> ((AutoFollowMetadata.AutoFollowPattern)entry.getValue()).getRemoteCluster().equals(this.remoteCluster)).map(Map.Entry::getKey).collect(Collectors.toList());
            if (patterns.isEmpty()) {
                LOGGER.info("AutoFollower for cluster [{}] has stopped, because there are no more patterns", (Object)this.remoteCluster);
                return;
            }
            this.autoFollowPatternsCountDown = new CountDown(patterns.size());
            this.autoFollowResults = new AtomicArray(patterns.size());
            this.getRemoteClusterState(this.remoteCluster, this.metadataVersion + 1L, (remoteClusterStateResponse, remoteError) -> {
                if (remoteClusterStateResponse != null) {
                    assert (remoteError == null);
                    if (remoteClusterStateResponse.isWaitForTimedOut()) {
                        this.start();
                        return;
                    }
                    ClusterState remoteClusterState = remoteClusterStateResponse.getState();
                    this.metadataVersion = remoteClusterState.metaData().version();
                    this.autoFollowIndices(autoFollowMetadata, clusterState, remoteClusterState, patterns);
                } else {
                    assert (remoteError != null);
                    for (int i = 0; i < patterns.size(); ++i) {
                        String autoFollowPatternName = (String)patterns.get(i);
                        this.finalise(i, new AutoFollowResult(autoFollowPatternName, (Exception)remoteError));
                    }
                }
            });
        }

        private void autoFollowIndices(AutoFollowMetadata autoFollowMetadata, ClusterState clusterState, ClusterState remoteClusterState, List<String> patterns) {
            int i = 0;
            for (String autoFollowPatternName : patterns) {
                int slot = i;
                AutoFollowMetadata.AutoFollowPattern autoFollowPattern = (AutoFollowMetadata.AutoFollowPattern)autoFollowMetadata.getPatterns().get(autoFollowPatternName);
                Map headers = (Map)autoFollowMetadata.getHeaders().get(autoFollowPatternName);
                List followedIndices = (List)autoFollowMetadata.getFollowedLeaderIndexUUIDs().get(autoFollowPatternName);
                List<Index> leaderIndicesToFollow = AutoFollower.getLeaderIndicesToFollow(autoFollowPattern, remoteClusterState, clusterState, followedIndices);
                if (leaderIndicesToFollow.isEmpty()) {
                    this.finalise(slot, new AutoFollowResult(autoFollowPatternName));
                } else {
                    List<Tuple<String, AutoFollowMetadata.AutoFollowPattern>> patternsForTheSameRemoteCluster = autoFollowMetadata.getPatterns().entrySet().stream().filter(item -> !autoFollowPatternName.equals(item.getKey())).filter(item -> this.remoteCluster.equals(((AutoFollowMetadata.AutoFollowPattern)item.getValue()).getRemoteCluster())).map(item -> new Tuple((Object)((String)item.getKey()), (Object)((AutoFollowMetadata.AutoFollowPattern)item.getValue()))).collect(Collectors.toList());
                    Consumer<AutoFollowResult> resultHandler = result -> this.finalise(slot, (AutoFollowResult)result);
                    this.checkAutoFollowPattern(autoFollowPatternName, this.remoteCluster, autoFollowPattern, leaderIndicesToFollow, headers, patternsForTheSameRemoteCluster, resultHandler);
                }
                ++i;
            }
            this.cleanFollowedRemoteIndices(remoteClusterState, patterns);
        }

        private void checkAutoFollowPattern(String autoFollowPattenName, String remoteCluster, AutoFollowMetadata.AutoFollowPattern autoFollowPattern, List<Index> leaderIndicesToFollow, Map<String, String> headers, List<Tuple<String, AutoFollowMetadata.AutoFollowPattern>> patternsForTheSameRemoteCluster, Consumer<AutoFollowResult> resultHandler) {
            CountDown leaderIndicesCountDown = new CountDown(leaderIndicesToFollow.size());
            AtomicArray results = new AtomicArray(leaderIndicesToFollow.size());
            for (int i = 0; i < leaderIndicesToFollow.size(); ++i) {
                Index indexToFollow = leaderIndicesToFollow.get(i);
                int slot = i;
                List otherMatchingPatterns = patternsForTheSameRemoteCluster.stream().filter(otherPattern -> ((AutoFollowMetadata.AutoFollowPattern)otherPattern.v2()).match(indexToFollow.getName())).map(Tuple::v1).collect(Collectors.toList());
                if (otherMatchingPatterns.size() != 0) {
                    results.set(slot, (Object)new Tuple((Object)indexToFollow, (Object)new ElasticsearchException("index to follow [" + indexToFollow.getName() + "] for pattern [" + autoFollowPattenName + "] matches with other patterns " + otherMatchingPatterns + "", new Object[0])));
                    if (!leaderIndicesCountDown.countDown()) continue;
                    resultHandler.accept(new AutoFollowResult(autoFollowPattenName, results.asList()));
                    continue;
                }
                this.followLeaderIndex(autoFollowPattenName, remoteCluster, indexToFollow, autoFollowPattern, headers, error -> {
                    results.set(slot, (Object)new Tuple((Object)indexToFollow, error));
                    if (leaderIndicesCountDown.countDown()) {
                        resultHandler.accept(new AutoFollowResult(autoFollowPattenName, results.asList()));
                    }
                });
            }
        }

        private void followLeaderIndex(String autoFollowPattenName, String remoteCluster, Index indexToFollow, AutoFollowMetadata.AutoFollowPattern pattern, Map<String, String> headers, Consumer<Exception> onResult) {
            String leaderIndexName = indexToFollow.getName();
            String followIndexName = AutoFollower.getFollowerIndexName(pattern, leaderIndexName);
            ResumeFollowAction.Request followRequest = new ResumeFollowAction.Request();
            followRequest.setFollowerIndex(followIndexName);
            followRequest.setMaxReadRequestOperationCount(pattern.getMaxReadRequestOperationCount());
            followRequest.setMaxReadRequestSize(pattern.getMaxReadRequestSize());
            followRequest.setMaxOutstandingReadRequests(pattern.getMaxOutstandingReadRequests());
            followRequest.setMaxWriteRequestOperationCount(pattern.getMaxWriteRequestOperationCount());
            followRequest.setMaxWriteRequestSize(pattern.getMaxWriteRequestSize());
            followRequest.setMaxOutstandingWriteRequests(pattern.getMaxOutstandingWriteRequests());
            followRequest.setMaxWriteBufferCount(pattern.getMaxWriteBufferCount());
            followRequest.setMaxWriteBufferSize(pattern.getMaxWriteBufferSize());
            followRequest.setMaxRetryDelay(pattern.getMaxRetryDelay());
            followRequest.setReadPollTimeout(pattern.getPollTimeout());
            PutFollowAction.Request request = new PutFollowAction.Request();
            request.setRemoteCluster(remoteCluster);
            request.setLeaderIndex(indexToFollow.getName());
            request.setFollowRequest(followRequest);
            Runnable successHandler = () -> {
                LOGGER.info("Auto followed leader index [{}] as follow index [{}]", (Object)leaderIndexName, (Object)followIndexName);
                Function<ClusterState, ClusterState> function = AutoFollower.recordLeaderIndexAsFollowFunction(autoFollowPattenName, indexToFollow);
                this.updateAutoFollowMetadata(function, onResult);
            };
            this.createAndFollow(headers, request, successHandler, onResult);
        }

        private void finalise(int slot, AutoFollowResult result) {
            assert (this.autoFollowResults.get(slot) == null);
            this.autoFollowResults.set(slot, (Object)result);
            if (this.autoFollowPatternsCountDown.countDown()) {
                this.statsUpdater.accept(this.autoFollowResults.asList());
                this.start();
            }
        }

        static List<Index> getLeaderIndicesToFollow(AutoFollowMetadata.AutoFollowPattern autoFollowPattern, ClusterState remoteClusterState, ClusterState followerClusterState, List<String> followedIndexUUIDs) {
            ArrayList<Index> leaderIndicesToFollow = new ArrayList<Index>();
            for (IndexMetaData leaderIndexMetaData : remoteClusterState.getMetaData()) {
                Settings leaderIndexSettings;
                IndexRoutingTable indexRoutingTable;
                if (!autoFollowPattern.match(leaderIndexMetaData.getIndex().getName()) || (indexRoutingTable = remoteClusterState.routingTable().index(leaderIndexMetaData.getIndex())) == null || !indexRoutingTable.allPrimaryShardsActive() || followedIndexUUIDs.contains(leaderIndexMetaData.getIndex().getUUID()) || !(leaderIndexSettings = leaderIndexMetaData.getSettings()).getAsBoolean(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), Boolean.valueOf(((Version)IndexMetaData.SETTING_INDEX_VERSION_CREATED.get(leaderIndexSettings)).onOrAfter(Version.V_7_0_0))).booleanValue()) continue;
                leaderIndicesToFollow.add(leaderIndexMetaData.getIndex());
            }
            return leaderIndicesToFollow;
        }

        static String getFollowerIndexName(AutoFollowMetadata.AutoFollowPattern autoFollowPattern, String leaderIndexName) {
            if (autoFollowPattern.getFollowIndexPattern() != null) {
                return autoFollowPattern.getFollowIndexPattern().replace("{{leader_index}}", leaderIndexName);
            }
            return leaderIndexName;
        }

        static Function<ClusterState, ClusterState> recordLeaderIndexAsFollowFunction(String name, Index indexToFollow) {
            return currentState -> {
                AutoFollowMetadata currentAutoFollowMetadata = (AutoFollowMetadata)currentState.metaData().custom("ccr_auto_follow");
                HashMap<String, List> newFollowedIndexUUIDS = new HashMap<String, List>(currentAutoFollowMetadata.getFollowedLeaderIndexUUIDs());
                if (!newFollowedIndexUUIDS.containsKey(name)) {
                    return currentState;
                }
                newFollowedIndexUUIDS.compute(name, (key, existingUUIDs) -> {
                    assert (existingUUIDs != null);
                    ArrayList<String> newUUIDs = new ArrayList<String>((Collection<String>)existingUUIDs);
                    newUUIDs.add(indexToFollow.getUUID());
                    return Collections.unmodifiableList(newUUIDs);
                });
                AutoFollowMetadata newAutoFollowMetadata = new AutoFollowMetadata(currentAutoFollowMetadata.getPatterns(), newFollowedIndexUUIDS, currentAutoFollowMetadata.getHeaders());
                return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ccr_auto_follow", (MetaData.Custom)newAutoFollowMetadata).build()).build();
            };
        }

        void cleanFollowedRemoteIndices(ClusterState remoteClusterState, List<String> patterns) {
            this.updateAutoFollowMetadata(AutoFollower.cleanFollowedRemoteIndices(remoteClusterState.metaData(), patterns), e -> {
                if (e != null) {
                    LOGGER.warn("Error occured while cleaning followed leader indices", (Throwable)e);
                }
            });
        }

        static Function<ClusterState, ClusterState> cleanFollowedRemoteIndices(MetaData remoteMetadata, List<String> autoFollowPatternNames) {
            return currentState -> {
                AutoFollowMetadata currentAutoFollowMetadata = (AutoFollowMetadata)currentState.metaData().custom("ccr_auto_follow");
                HashMap autoFollowPatternNameToFollowedIndexUUIDs = new HashMap(currentAutoFollowMetadata.getFollowedLeaderIndexUUIDs());
                HashSet remoteIndexUUIDS = new HashSet();
                remoteMetadata.getIndices().values().forEach(value -> remoteIndexUUIDS.add(value.getIndexUUID()));
                boolean requiresCSUpdate = false;
                for (String autoFollowPatternName : autoFollowPatternNames) {
                    if (!autoFollowPatternNameToFollowedIndexUUIDs.containsKey(autoFollowPatternName)) continue;
                    ArrayList<String> followedIndexUUIDs = new ArrayList<String>((Collection)autoFollowPatternNameToFollowedIndexUUIDs.get(autoFollowPatternName));
                    boolean entriesRemoved = followedIndexUUIDs.removeIf(followedLeaderIndexUUID -> !remoteIndexUUIDS.contains(followedLeaderIndexUUID));
                    if (entriesRemoved) {
                        requiresCSUpdate = true;
                    }
                    autoFollowPatternNameToFollowedIndexUUIDs.put(autoFollowPatternName, followedIndexUUIDs);
                }
                if (requiresCSUpdate) {
                    AutoFollowMetadata newAutoFollowMetadata = new AutoFollowMetadata(currentAutoFollowMetadata.getPatterns(), autoFollowPatternNameToFollowedIndexUUIDs, currentAutoFollowMetadata.getHeaders());
                    return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ccr_auto_follow", (MetaData.Custom)newAutoFollowMetadata).build()).build();
                }
                return currentState;
            };
        }

        abstract void getRemoteClusterState(String var1, long var2, BiConsumer<ClusterStateResponse, Exception> var4);

        abstract void createAndFollow(Map<String, String> var1, PutFollowAction.Request var2, Runnable var3, Consumer<Exception> var4);

        abstract void updateAutoFollowMetadata(Function<ClusterState, ClusterState> var1, Consumer<Exception> var2);
    }
}

