/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.script.mustache.SearchTemplateAction;
import org.elasticsearch.script.mustache.SearchTemplateRequest;

public class RestSearchTemplateAction
extends BaseRestHandler {
    public static final String TYPED_KEYS_PARAM = "typed_keys";
    private static final Set<String> RESPONSE_PARAMS;

    public RestSearchTemplateAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_search/template", (RestHandler)this);
    }

    public String getName() {
        return "search_template_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchTemplateRequest searchTemplateRequest;
        SearchRequest searchRequest = new SearchRequest();
        RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)request, null, size -> searchRequest.source().size(size));
        try (XContentParser parser = request.contentOrSourceParamParser();){
            searchTemplateRequest = SearchTemplateRequest.fromXContent(parser);
        }
        searchTemplateRequest.setRequest(searchRequest);
        return channel -> client.execute((Action)SearchTemplateAction.INSTANCE, (ActionRequest)searchTemplateRequest, (ActionListener)new RestStatusToXContentListener(channel));
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList(TYPED_KEYS_PARAM, "rest_total_hits_as_int"));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

