/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PruneUnneededConnectionsLDAPConnectionPoolHealthCheck
extends LDAPConnectionPoolHealthCheck {
    private final AtomicReference<Long> earliestTimeWithMoreThanMinAvailableConnections;
    private final int minAvailableConnections;
    private final long minDurationMillisExceedingMinAvailableConnections;

    public PruneUnneededConnectionsLDAPConnectionPoolHealthCheck(int minAvailableConnections, long minDurationMillisExceedingMinAvailableConnections) {
        this.minAvailableConnections = Math.max(0, minAvailableConnections);
        this.minDurationMillisExceedingMinAvailableConnections = Math.max(0L, minDurationMillisExceedingMinAvailableConnections);
        this.earliestTimeWithMoreThanMinAvailableConnections = new AtomicReference();
    }

    public int getMinAvailableConnections() {
        return this.minAvailableConnections;
    }

    public long getMinDurationMillisExceedingMinAvailableConnections() {
        return this.minDurationMillisExceedingMinAvailableConnections;
    }

    @Override
    public void performPoolMaintenance(AbstractConnectionPool pool) {
        if (!(pool instanceof LDAPConnectionPool)) {
            Debug.debug(Level.WARNING, DebugType.CONNECT, "Only " + LDAPConnectionPool.class.getName() + " instances may be used in conjunction with the " + "PruneUnneededConnectionsLDAPConnectionPoolHealthCheck.  " + "The provided pool had an incompatible type of " + pool.getClass().getName() + '.');
            this.earliestTimeWithMoreThanMinAvailableConnections.set(null);
            return;
        }
        int availableConnections = pool.getCurrentAvailableConnections();
        if (availableConnections <= this.minAvailableConnections) {
            this.earliestTimeWithMoreThanMinAvailableConnections.set(null);
            return;
        }
        Long earliestTime = this.earliestTimeWithMoreThanMinAvailableConnections.get();
        if (earliestTime == null) {
            if (this.minDurationMillisExceedingMinAvailableConnections <= 0L) {
                ((LDAPConnectionPool)pool).shrinkPool(this.minAvailableConnections);
            } else {
                this.earliestTimeWithMoreThanMinAvailableConnections.set(System.currentTimeMillis());
            }
        } else {
            long millisWithMoreThanMinAvailableConnections = System.currentTimeMillis() - earliestTime;
            if (millisWithMoreThanMinAvailableConnections >= this.minDurationMillisExceedingMinAvailableConnections) {
                ((LDAPConnectionPool)pool).shrinkPool(this.minAvailableConnections);
                this.earliestTimeWithMoreThanMinAvailableConnections.set(null);
            }
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("PruneUnneededConnectionsLDAPConnectionPoolHealthCheck(minAvailableConnections=");
        buffer.append(this.minAvailableConnections);
        buffer.append(", minDurationMillisExceedingMinAvailableConnections=");
        buffer.append(this.minDurationMillisExceedingMinAvailableConnections);
        buffer.append(')');
    }
}

