/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.Debug;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class FastestConnectThread
extends Thread {
    private final AtomicBoolean connectionSelected;
    private final BindRequest bindRequest;
    private final BlockingQueue<Object> resultQueue;
    private final int port;
    private final LDAPConnection connection;
    private final LDAPConnectionPoolHealthCheck healthCheck;
    private final PostConnectProcessor postConnectProcessor;
    private final String address;

    FastestConnectThread(String address, int port, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, BindRequest bindRequest, PostConnectProcessor postConnectProcessor, LDAPConnectionPoolHealthCheck healthCheck, BlockingQueue<Object> resultQueue, AtomicBoolean connectionSelected) {
        super("Fastest Connect Thread for " + address + ':' + port);
        this.setDaemon(true);
        this.address = address;
        this.port = port;
        this.bindRequest = bindRequest;
        this.postConnectProcessor = postConnectProcessor;
        this.healthCheck = healthCheck;
        this.resultQueue = resultQueue;
        this.connectionSelected = connectionSelected;
        this.connection = new LDAPConnection(socketFactory, connectionOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean returned = false;
        try {
            this.connection.connect(this.address, this.port);
            ServerSet.doBindPostConnectAndHealthCheckProcessing(this.connection, this.bindRequest, this.postConnectProcessor, this.healthCheck);
            returned = this.connectionSelected.compareAndSet(false, true) && this.resultQueue.offer(this.connection);
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.resultQueue.offer(e);
        }
        finally {
            if (!returned) {
                this.connection.close();
            }
        }
    }
}

