/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.CollectionUtils;

public class X509KeyPairSettings {
    static final Function<String, Setting<Optional<String>>> KEYSTORE_PATH_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    static final Function<String, Setting<SecureString>> LEGACY_KEYSTORE_PASSWORD_TEMPLATE = key -> new Setting(key, "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
    static final Function<String, Setting<SecureString>> KEYSTORE_PASSWORD_TEMPLATE = key -> SecureSetting.secureString((String)key, LEGACY_KEYSTORE_PASSWORD_TEMPLATE.apply(key.replace("keystore.secure_password", "keystore.password")), (Setting.Property[])new Setting.Property[0]);
    static final Function<String, Setting<String>> KEY_STORE_ALGORITHM_TEMPLATE = key -> new Setting(key, s -> KeyManagerFactory.getDefaultAlgorithm(), Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    static final Function<String, Setting<Optional<String>>> KEY_STORE_TYPE_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    static final Function<String, Setting<SecureString>> LEGACY_KEYSTORE_KEY_PASSWORD_TEMPLATE = key -> new Setting(key, "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
    static final Function<String, Setting<SecureString>> KEYSTORE_KEY_PASSWORD_TEMPLATE = key -> SecureSetting.secureString((String)key, LEGACY_KEYSTORE_KEY_PASSWORD_TEMPLATE.apply(key.replace("keystore.secure_key_password", "keystore.key_password")), (Setting.Property[])new Setting.Property[0]);
    static final Function<String, Setting<Optional<String>>> KEY_PATH_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    static final Function<String, Setting<Optional<String>>> CERT_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    static final Function<String, Setting<SecureString>> LEGACY_KEY_PASSWORD_TEMPLATE = key -> new Setting(key, "", SecureString::new, new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.Filtered, Setting.Property.NodeScope});
    static final Function<String, Setting<SecureString>> KEY_PASSWORD_TEMPLATE = key -> SecureSetting.secureString((String)key, LEGACY_KEY_PASSWORD_TEMPLATE.apply(key.replace("secure_key_passphrase", "key_passphrase")), (Setting.Property[])new Setting.Property[0]);
    final Setting<Optional<String>> keystorePath;
    final Setting<SecureString> keystorePassword;
    final Setting<String> keystoreAlgorithm;
    final Setting<Optional<String>> keystoreType;
    final Setting<SecureString> keystoreKeyPassword;
    final Setting<Optional<String>> keyPath;
    final Setting<SecureString> keyPassword;
    final Setting<Optional<String>> certificatePath;
    final Setting<SecureString> legacyKeystorePassword;
    final Setting<SecureString> legacyKeystoreKeyPassword;
    final Setting<SecureString> legacyKeyPassword;
    private final List<Setting<?>> allSettings;

    private X509KeyPairSettings(boolean acceptNonSecurePasswords, SettingFactory factory) {
        this.keystorePath = factory.apply("keystore.path", KEYSTORE_PATH_TEMPLATE);
        this.keystorePassword = factory.apply("keystore.secure_password", KEYSTORE_PASSWORD_TEMPLATE);
        this.keystoreAlgorithm = factory.apply("keystore.algorithm", KEY_STORE_ALGORITHM_TEMPLATE);
        this.keystoreType = factory.apply("keystore.type", KEY_STORE_TYPE_TEMPLATE);
        this.keystoreKeyPassword = factory.apply("keystore.secure_key_password", KEYSTORE_KEY_PASSWORD_TEMPLATE);
        this.keyPath = factory.apply("key", KEY_PATH_TEMPLATE);
        this.keyPassword = factory.apply("secure_key_passphrase", KEY_PASSWORD_TEMPLATE);
        this.certificatePath = factory.apply("certificate", CERT_TEMPLATE);
        this.legacyKeystorePassword = factory.apply("keystore.password", LEGACY_KEYSTORE_PASSWORD_TEMPLATE);
        this.legacyKeystoreKeyPassword = factory.apply("keystore.key_password", LEGACY_KEYSTORE_KEY_PASSWORD_TEMPLATE);
        this.legacyKeyPassword = factory.apply("key_passphrase", LEGACY_KEY_PASSWORD_TEMPLATE);
        ArrayList settings = CollectionUtils.arrayAsArrayList((Object[])new Setting[]{this.keystorePath, this.keystorePassword, this.keystoreAlgorithm, this.keystoreType, this.keystoreKeyPassword, this.keyPath, this.keyPassword, this.certificatePath});
        if (acceptNonSecurePasswords) {
            settings.add(this.legacyKeystorePassword);
            settings.add(this.legacyKeystoreKeyPassword);
            settings.add(this.legacyKeyPassword);
        }
        this.allSettings = Collections.unmodifiableList(settings);
    }

    public static X509KeyPairSettings withPrefix(final String prefix, boolean acceptNonSecurePasswords) {
        return new X509KeyPairSettings(acceptNonSecurePasswords, new SettingFactory(){

            @Override
            public <T> Setting<T> apply(String key, Function<String, Setting<T>> template) {
                return template.apply(prefix + key);
            }
        });
    }

    public static Collection<Setting.AffixSetting<?>> affix(final String prefix, final String suffixPart, boolean acceptNonSecurePasswords) {
        X509KeyPairSettings settings = new X509KeyPairSettings(acceptNonSecurePasswords, new SettingFactory(){

            @Override
            public <T> Setting<T> apply(String keyPart, Function<String, Setting<T>> template) {
                return Setting.affixKeySetting((String)prefix, (String)(suffixPart + keyPart), template, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
            }
        });
        return settings.getAllSettings().stream().map(s -> (Setting.AffixSetting)s).collect(Collectors.toList());
    }

    public Collection<Setting<?>> getAllSettings() {
        return this.allSettings;
    }

    private static interface SettingFactory {
        public <T> Setting<T> apply(String var1, Function<String, Setting<T>> var2);
    }
}

