/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed;

import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DelayedDataCheckConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public final class DatafeedJobValidator {
    private DatafeedJobValidator() {
    }

    public static void validate(DatafeedConfig datafeedConfig, Job job) {
        AnalysisConfig analysisConfig = job.getAnalysisConfig();
        if (analysisConfig.getLatency() != null && analysisConfig.getLatency().seconds() > 0L) {
            throw ExceptionsHelper.badRequestException(Messages.getMessage("A job configured with datafeed cannot support latency"), new Object[0]);
        }
        if (datafeedConfig.hasAggregations()) {
            DatafeedJobValidator.checkSummaryCountFieldNameIsSet(analysisConfig);
            DatafeedJobValidator.checkValidHistogramInterval(datafeedConfig, analysisConfig);
            DatafeedJobValidator.checkFrequencyIsMultipleOfHistogramInterval(datafeedConfig);
        }
        DelayedDataCheckConfig delayedDataCheckConfig = datafeedConfig.getDelayedDataCheckConfig();
        TimeValue bucketSpan = analysisConfig.getBucketSpan();
        if (delayedDataCheckConfig.isEnabled()) {
            DatafeedJobValidator.checkValidDelayedDataCheckConfig(bucketSpan, delayedDataCheckConfig);
        }
    }

    private static void checkValidDelayedDataCheckConfig(TimeValue bucketSpan, DelayedDataCheckConfig delayedDataCheckConfig) {
        TimeValue delayedDataCheckWindow = delayedDataCheckConfig.getCheckWindow();
        if (delayedDataCheckWindow != null) {
            if (delayedDataCheckWindow.compareTo(bucketSpan) < 0) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("delayed_data_check_config: check_window [{0}] must be greater than the bucket_span [{1}]", delayedDataCheckWindow, bucketSpan), new Object[0]);
            }
            if (delayedDataCheckWindow.millis() > bucketSpan.millis() * 10000L) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("delayed_data_check_config: check_window [{0}] must be less than 10,000x the bucket_span [{1}]", delayedDataCheckWindow, bucketSpan), new Object[0]);
            }
        }
    }

    private static void checkSummaryCountFieldNameIsSet(AnalysisConfig analysisConfig) {
        if (Strings.isNullOrEmpty((String)analysisConfig.getSummaryCountFieldName())) {
            throw ExceptionsHelper.badRequestException(Messages.getMessage("A job configured with a datafeed with aggregations must set summary_count_field_name; use doc_count or suitable alternative"), new Object[0]);
        }
    }

    private static void checkValidHistogramInterval(DatafeedConfig datafeedConfig, AnalysisConfig analysisConfig) {
        long bucketSpanMillis;
        long histogramIntervalMillis = datafeedConfig.getHistogramIntervalMillis();
        if (histogramIntervalMillis > (bucketSpanMillis = analysisConfig.getBucketSpan().millis())) {
            throw ExceptionsHelper.badRequestException(Messages.getMessage("Aggregation interval [{0}] must be less than or equal to the bucket_span [{1}]", TimeValue.timeValueMillis((long)histogramIntervalMillis).getStringRep(), TimeValue.timeValueMillis((long)bucketSpanMillis).getStringRep()), new Object[0]);
        }
        if (bucketSpanMillis % histogramIntervalMillis != 0L) {
            throw ExceptionsHelper.badRequestException(Messages.getMessage("Aggregation interval [{0}] must be a divisor of the bucket_span [{1}]", TimeValue.timeValueMillis((long)histogramIntervalMillis).getStringRep(), TimeValue.timeValueMillis((long)bucketSpanMillis).getStringRep()), new Object[0]);
        }
    }

    private static void checkFrequencyIsMultipleOfHistogramInterval(DatafeedConfig datafeedConfig) {
        TimeValue frequency = datafeedConfig.getFrequency();
        if (frequency != null) {
            long histogramIntervalMillis = datafeedConfig.getHistogramIntervalMillis();
            long frequencyMillis = frequency.millis();
            if (frequencyMillis % histogramIntervalMillis != 0L) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Datafeed frequency [{0}] must be a multiple of the aggregation interval [{1}]", frequency, TimeValue.timeValueMillis((long)histogramIntervalMillis).getStringRep()), new Object[0]);
            }
        }
    }
}

