/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FinalizeJobExecutionAction
extends Action<AcknowledgedResponse> {
    public static final FinalizeJobExecutionAction INSTANCE = new FinalizeJobExecutionAction();
    public static final String NAME = "cluster:internal/xpack/ml/job/finalize_job_execution";

    private FinalizeJobExecutionAction() {
        super(NAME);
    }

    public AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, AcknowledgedResponse, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, FinalizeJobExecutionAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private String[] jobIds;

        public Request(String[] jobIds) {
            this.jobIds = jobIds;
        }

        public Request() {
        }

        public String[] getJobIds() {
            return this.jobIds;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobIds = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.jobIds);
        }

        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

