/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.indexlifecycle.LifecyclePolicy;

public class GetLifecycleAction
extends Action<Response> {
    public static final GetLifecycleAction INSTANCE = new GetLifecycleAction();
    public static final String NAME = "cluster:admin/ilm/get";

    protected GetLifecycleAction() {
        super(NAME);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class LifecyclePolicyResponseItem
    implements Writeable {
        private final LifecyclePolicy lifecyclePolicy;
        private final long version;
        private final String modifiedDate;

        public LifecyclePolicyResponseItem(LifecyclePolicy lifecyclePolicy, long version, String modifiedDate) {
            this.lifecyclePolicy = lifecyclePolicy;
            this.version = version;
            this.modifiedDate = modifiedDate;
        }

        LifecyclePolicyResponseItem(StreamInput in) throws IOException {
            this.lifecyclePolicy = new LifecyclePolicy(in);
            this.version = in.readVLong();
            this.modifiedDate = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.lifecyclePolicy.writeTo(out);
            out.writeVLong(this.version);
            out.writeString(this.modifiedDate);
        }

        public LifecyclePolicy getLifecyclePolicy() {
            return this.lifecyclePolicy;
        }

        public long getVersion() {
            return this.version;
        }

        public String getModifiedDate() {
            return this.modifiedDate;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.lifecyclePolicy, this.version, this.modifiedDate});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LifecyclePolicyResponseItem other = (LifecyclePolicyResponseItem)obj;
            return Objects.equals((Object)this.lifecyclePolicy, (Object)other.lifecyclePolicy) && Objects.equals(this.version, other.version) && Objects.equals(this.modifiedDate, other.modifiedDate);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private String[] policyNames;

        public Request(String ... policyNames) {
            if (policyNames == null) {
                throw new IllegalArgumentException("ids cannot be null");
            }
            this.policyNames = policyNames;
        }

        public Request() {
            this.policyNames = Strings.EMPTY_ARRAY;
        }

        public String[] getPolicyNames() {
            return this.policyNames;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.policyNames = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.policyNames);
        }

        public int hashCode() {
            return Arrays.hashCode(this.policyNames);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Arrays.equals(this.policyNames, other.policyNames);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private List<LifecyclePolicyResponseItem> policies;

        public Response() {
        }

        public Response(List<LifecyclePolicyResponseItem> policies) {
            this.policies = policies;
        }

        public List<LifecyclePolicyResponseItem> getPolicies() {
            return this.policies;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            for (LifecyclePolicyResponseItem item : this.policies) {
                builder.startObject(item.getLifecyclePolicy().getName());
                builder.field("version", item.getVersion());
                builder.field("modified_date", item.getModifiedDate());
                builder.field("policy", (ToXContent)item.getLifecyclePolicy());
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.policies = in.readList(LifecyclePolicyResponseItem::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.policies);
        }

        public int hashCode() {
            return Objects.hash(this.policies);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.policies, other.policies);
        }

        public String toString() {
            return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
        }
    }
}

