/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;

public class PutAutoFollowPatternAction
extends Action<AcknowledgedResponse> {
    public static final String NAME = "cluster:admin/xpack/ccr/auto_follow_pattern/put";
    public static final PutAutoFollowPatternAction INSTANCE = new PutAutoFollowPatternAction();

    private PutAutoFollowPatternAction() {
        super(NAME);
    }

    public AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private static final ObjectParser<Request, String> PARSER = new ObjectParser("put_auto_follow_pattern_request", Request::new);
        private static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
        private static final int MAX_NAME_BYTES = 255;
        private String name;
        private String remoteCluster;
        private List<String> leaderIndexPatterns;
        private String followIndexNamePattern;
        private Integer maxReadRequestOperationCount;
        private ByteSizeValue maxReadRequestSize;
        private Integer maxConcurrentReadBatches;
        private Integer maxWriteRequestOperationCount;
        private ByteSizeValue maxWriteRequestSize;
        private Integer maxConcurrentWriteBatches;
        private Integer maxWriteBufferCount;
        private ByteSizeValue maxWriteBufferSize;
        private TimeValue maxRetryDelay;
        private TimeValue readPollTimeout;

        public static Request fromXContent(XContentParser parser, String name) throws IOException {
            Request request = (Request)((Object)PARSER.parse(parser, null));
            if (name != null) {
                if (request.name == null) {
                    request.name = name;
                } else if (!request.name.equals(name)) {
                    throw new IllegalArgumentException("provided name is not equal");
                }
            }
            return request;
        }

        public Request() {
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.name == null) {
                validationException = ValidateActions.addValidationError((String)("[" + NAME_FIELD.getPreferredName() + "] is missing"), validationException);
            }
            if (this.name != null) {
                int byteCount;
                if (this.name.contains(",")) {
                    validationException = ValidateActions.addValidationError((String)("[" + NAME_FIELD.getPreferredName() + "] name must not contain a ','"), (ActionRequestValidationException)validationException);
                }
                if (this.name.startsWith("_")) {
                    validationException = ValidateActions.addValidationError((String)("[" + NAME_FIELD.getPreferredName() + "] name must not start with '_'"), (ActionRequestValidationException)validationException);
                }
                if ((byteCount = this.name.getBytes(StandardCharsets.UTF_8).length) > 255) {
                    validationException = ValidateActions.addValidationError((String)("[" + NAME_FIELD.getPreferredName() + "] name is too long (" + byteCount + " > " + 255 + ")"), (ActionRequestValidationException)validationException);
                }
            }
            if (this.remoteCluster == null) {
                validationException = ValidateActions.addValidationError((String)("[" + AutoFollowMetadata.AutoFollowPattern.REMOTE_CLUSTER_FIELD.getPreferredName() + "] is missing"), (ActionRequestValidationException)validationException);
            }
            if (this.leaderIndexPatterns == null || this.leaderIndexPatterns.isEmpty()) {
                validationException = ValidateActions.addValidationError((String)("[" + AutoFollowMetadata.AutoFollowPattern.LEADER_PATTERNS_FIELD.getPreferredName() + "] is missing"), (ActionRequestValidationException)validationException);
            }
            if (this.maxRetryDelay != null) {
                if (this.maxRetryDelay.millis() <= 0L) {
                    String message = "[" + AutoFollowMetadata.AutoFollowPattern.MAX_RETRY_DELAY.getPreferredName() + "] must be positive but was [" + this.maxRetryDelay.getStringRep() + "]";
                    validationException = ValidateActions.addValidationError((String)message, (ActionRequestValidationException)validationException);
                }
                if (this.maxRetryDelay.millis() > ResumeFollowAction.MAX_RETRY_DELAY.millis()) {
                    String message = "[" + AutoFollowMetadata.AutoFollowPattern.MAX_RETRY_DELAY.getPreferredName() + "] must be less than [" + ResumeFollowAction.MAX_RETRY_DELAY + "] but was [" + this.maxRetryDelay.getStringRep() + "]";
                    validationException = ValidateActions.addValidationError((String)message, (ActionRequestValidationException)validationException);
                }
            }
            return validationException;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRemoteCluster() {
            return this.remoteCluster;
        }

        public void setRemoteCluster(String remoteCluster) {
            this.remoteCluster = remoteCluster;
        }

        public List<String> getLeaderIndexPatterns() {
            return this.leaderIndexPatterns;
        }

        public void setLeaderIndexPatterns(List<String> leaderIndexPatterns) {
            this.leaderIndexPatterns = leaderIndexPatterns;
        }

        public String getFollowIndexNamePattern() {
            return this.followIndexNamePattern;
        }

        public void setFollowIndexNamePattern(String followIndexNamePattern) {
            this.followIndexNamePattern = followIndexNamePattern;
        }

        public Integer getMaxReadRequestOperationCount() {
            return this.maxReadRequestOperationCount;
        }

        public void setMaxReadRequestOperationCount(Integer maxReadRequestOperationCount) {
            this.maxReadRequestOperationCount = maxReadRequestOperationCount;
        }

        public Integer getMaxConcurrentReadBatches() {
            return this.maxConcurrentReadBatches;
        }

        public void setMaxConcurrentReadBatches(Integer maxConcurrentReadBatches) {
            this.maxConcurrentReadBatches = maxConcurrentReadBatches;
        }

        public ByteSizeValue getMaxReadRequestSize() {
            return this.maxReadRequestSize;
        }

        public void setMaxReadRequestSize(ByteSizeValue maxReadRequestSize) {
            this.maxReadRequestSize = maxReadRequestSize;
        }

        public Integer getMaxWriteRequestOperationCount() {
            return this.maxWriteRequestOperationCount;
        }

        public void setMaxWriteRequestOperationCount(Integer maxWriteRequestOperationCount) {
            this.maxWriteRequestOperationCount = maxWriteRequestOperationCount;
        }

        public ByteSizeValue getMaxWriteRequestSize() {
            return this.maxWriteRequestSize;
        }

        public void setMaxWriteRequestSize(ByteSizeValue maxWriteRequestSize) {
            this.maxWriteRequestSize = maxWriteRequestSize;
        }

        public Integer getMaxConcurrentWriteBatches() {
            return this.maxConcurrentWriteBatches;
        }

        public void setMaxConcurrentWriteBatches(Integer maxConcurrentWriteBatches) {
            this.maxConcurrentWriteBatches = maxConcurrentWriteBatches;
        }

        public Integer getMaxWriteBufferCount() {
            return this.maxWriteBufferCount;
        }

        public void setMaxWriteBufferCount(Integer maxWriteBufferCount) {
            this.maxWriteBufferCount = maxWriteBufferCount;
        }

        public ByteSizeValue getMaxWriteBufferSize() {
            return this.maxWriteBufferSize;
        }

        public void setMaxWriteBufferSize(ByteSizeValue maxWriteBufferSize) {
            this.maxWriteBufferSize = maxWriteBufferSize;
        }

        public TimeValue getMaxRetryDelay() {
            return this.maxRetryDelay;
        }

        public void setMaxRetryDelay(TimeValue maxRetryDelay) {
            this.maxRetryDelay = maxRetryDelay;
        }

        public TimeValue getReadPollTimeout() {
            return this.readPollTimeout;
        }

        public void setReadPollTimeout(TimeValue readPollTimeout) {
            this.readPollTimeout = readPollTimeout;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.remoteCluster = in.readString();
            this.leaderIndexPatterns = in.readList(StreamInput::readString);
            this.followIndexNamePattern = in.readOptionalString();
            this.maxReadRequestOperationCount = in.readOptionalVInt();
            this.maxReadRequestSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.maxConcurrentReadBatches = in.readOptionalVInt();
            this.maxWriteRequestOperationCount = in.readOptionalVInt();
            this.maxWriteRequestSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.maxConcurrentWriteBatches = in.readOptionalVInt();
            this.maxWriteBufferCount = in.readOptionalVInt();
            this.maxWriteBufferSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.maxRetryDelay = in.readOptionalTimeValue();
            this.readPollTimeout = in.readOptionalTimeValue();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeString(this.remoteCluster);
            out.writeStringList(this.leaderIndexPatterns);
            out.writeOptionalString(this.followIndexNamePattern);
            out.writeOptionalVInt(this.maxReadRequestOperationCount);
            out.writeOptionalWriteable((Writeable)this.maxReadRequestSize);
            out.writeOptionalVInt(this.maxConcurrentReadBatches);
            out.writeOptionalVInt(this.maxWriteRequestOperationCount);
            out.writeOptionalWriteable((Writeable)this.maxWriteRequestSize);
            out.writeOptionalVInt(this.maxConcurrentWriteBatches);
            out.writeOptionalVInt(this.maxWriteBufferCount);
            out.writeOptionalWriteable((Writeable)this.maxWriteBufferSize);
            out.writeOptionalTimeValue(this.maxRetryDelay);
            out.writeOptionalTimeValue(this.readPollTimeout);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.name);
            builder.field(AutoFollowMetadata.AutoFollowPattern.REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
            builder.field(AutoFollowMetadata.AutoFollowPattern.LEADER_PATTERNS_FIELD.getPreferredName(), this.leaderIndexPatterns);
            if (this.followIndexNamePattern != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.FOLLOW_PATTERN_FIELD.getPreferredName(), this.followIndexNamePattern);
            }
            if (this.maxReadRequestOperationCount != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.MAX_READ_REQUEST_OPERATION_COUNT.getPreferredName(), this.maxReadRequestOperationCount);
            }
            if (this.maxReadRequestSize != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.MAX_READ_REQUEST_SIZE.getPreferredName(), this.maxReadRequestSize.getStringRep());
            }
            if (this.maxWriteRequestOperationCount != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.MAX_WRITE_REQUEST_OPERATION_COUNT.getPreferredName(), this.maxWriteRequestOperationCount);
            }
            if (this.maxWriteRequestSize != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.MAX_WRITE_REQUEST_SIZE.getPreferredName(), this.maxWriteRequestSize.getStringRep());
            }
            if (this.maxWriteBufferCount != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.MAX_WRITE_BUFFER_COUNT.getPreferredName(), this.maxWriteBufferCount);
            }
            if (this.maxWriteBufferSize != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.MAX_WRITE_BUFFER_SIZE.getPreferredName(), this.maxWriteBufferSize.getStringRep());
            }
            if (this.maxConcurrentReadBatches != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.MAX_OUTSTANDING_READ_REQUESTS.getPreferredName(), this.maxConcurrentReadBatches);
            }
            if (this.maxConcurrentWriteBatches != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.MAX_OUTSTANDING_WRITE_REQUESTS.getPreferredName(), this.maxConcurrentWriteBatches);
            }
            if (this.maxRetryDelay != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.MAX_RETRY_DELAY.getPreferredName(), this.maxRetryDelay.getStringRep());
            }
            if (this.readPollTimeout != null) {
                builder.field(AutoFollowMetadata.AutoFollowPattern.READ_POLL_TIMEOUT.getPreferredName(), this.readPollTimeout.getStringRep());
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.name, request.name) && Objects.equals(this.remoteCluster, request.remoteCluster) && Objects.equals(this.leaderIndexPatterns, request.leaderIndexPatterns) && Objects.equals(this.followIndexNamePattern, request.followIndexNamePattern) && Objects.equals(this.maxReadRequestOperationCount, request.maxReadRequestOperationCount) && Objects.equals(this.maxReadRequestSize, request.maxReadRequestSize) && Objects.equals(this.maxConcurrentReadBatches, request.maxConcurrentReadBatches) && Objects.equals(this.maxWriteRequestOperationCount, request.maxWriteRequestOperationCount) && Objects.equals(this.maxWriteRequestSize, request.maxWriteRequestSize) && Objects.equals(this.maxConcurrentWriteBatches, request.maxConcurrentWriteBatches) && Objects.equals(this.maxWriteBufferCount, request.maxWriteBufferCount) && Objects.equals(this.maxWriteBufferSize, request.maxWriteBufferSize) && Objects.equals(this.maxRetryDelay, request.maxRetryDelay) && Objects.equals(this.readPollTimeout, request.readPollTimeout);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.remoteCluster, this.leaderIndexPatterns, this.followIndexNamePattern, this.maxReadRequestOperationCount, this.maxReadRequestSize, this.maxConcurrentReadBatches, this.maxWriteRequestOperationCount, this.maxWriteRequestSize, this.maxConcurrentWriteBatches, this.maxWriteBufferCount, this.maxWriteBufferSize, this.maxRetryDelay, this.readPollTimeout);
        }

        static {
            PARSER.declareString(Request::setName, NAME_FIELD);
            PARSER.declareString(Request::setRemoteCluster, AutoFollowMetadata.AutoFollowPattern.REMOTE_CLUSTER_FIELD);
            PARSER.declareStringArray(Request::setLeaderIndexPatterns, AutoFollowMetadata.AutoFollowPattern.LEADER_PATTERNS_FIELD);
            PARSER.declareString(Request::setFollowIndexNamePattern, AutoFollowMetadata.AutoFollowPattern.FOLLOW_PATTERN_FIELD);
            PARSER.declareInt(Request::setMaxReadRequestOperationCount, AutoFollowMetadata.AutoFollowPattern.MAX_READ_REQUEST_OPERATION_COUNT);
            PARSER.declareField(Request::setMaxReadRequestSize, (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)AutoFollowMetadata.AutoFollowPattern.MAX_READ_REQUEST_SIZE.getPreferredName()), AutoFollowMetadata.AutoFollowPattern.MAX_READ_REQUEST_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareInt(Request::setMaxConcurrentReadBatches, AutoFollowMetadata.AutoFollowPattern.MAX_OUTSTANDING_READ_REQUESTS);
            PARSER.declareInt(Request::setMaxWriteRequestOperationCount, AutoFollowMetadata.AutoFollowPattern.MAX_WRITE_REQUEST_OPERATION_COUNT);
            PARSER.declareField(Request::setMaxWriteRequestSize, (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)AutoFollowMetadata.AutoFollowPattern.MAX_WRITE_REQUEST_SIZE.getPreferredName()), AutoFollowMetadata.AutoFollowPattern.MAX_WRITE_REQUEST_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareInt(Request::setMaxConcurrentWriteBatches, AutoFollowMetadata.AutoFollowPattern.MAX_OUTSTANDING_WRITE_REQUESTS);
            PARSER.declareInt(Request::setMaxWriteBufferCount, AutoFollowMetadata.AutoFollowPattern.MAX_WRITE_BUFFER_COUNT);
            PARSER.declareField(Request::setMaxWriteBufferSize, (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)AutoFollowMetadata.AutoFollowPattern.MAX_WRITE_BUFFER_SIZE.getPreferredName()), AutoFollowMetadata.AutoFollowPattern.MAX_WRITE_BUFFER_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareField(Request::setMaxRetryDelay, (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)AutoFollowMetadata.AutoFollowPattern.MAX_RETRY_DELAY.getPreferredName()), AutoFollowMetadata.AutoFollowPattern.MAX_RETRY_DELAY, ObjectParser.ValueType.STRING);
            PARSER.declareField(Request::setReadPollTimeout, (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)AutoFollowMetadata.AutoFollowPattern.READ_POLL_TIMEOUT.getPreferredName()), AutoFollowMetadata.AutoFollowPattern.READ_POLL_TIMEOUT, ObjectParser.ValueType.STRING);
        }
    }
}

