/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.engine.RewriteCachingDirectoryReader;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.transport.TransportRequest;

public final class FrozenEngine
extends ReadOnlyEngine {
    public static final Setting<Boolean> INDEX_FROZEN = Setting.boolSetting((String)"index.frozen", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex});
    private volatile DirectoryReader lastOpenedReader;
    private final DirectoryReader canMatchReader;

    public FrozenEngine(EngineConfig config) {
        super(config, null, null, true, Function.identity());
        boolean success = false;
        Directory directory = this.store.directory();
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            this.canMatchReader = ElasticsearchDirectoryReader.wrap((DirectoryReader)new RewriteCachingDirectoryReader(directory, reader.leaves()), (ShardId)config.getShardId());
            success = true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!success) {
                this.closeNoLock("failed on construction", new CountDownLatch(1));
            }
        }
    }

    protected DirectoryReader open(final IndexCommit indexCommit) throws IOException {
        return new DirectoryReader(indexCommit.getDirectory(), new LeafReader[0]){

            protected DirectoryReader doOpenIfChanged() {
                return null;
            }

            protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
                return null;
            }

            protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
                return null;
            }

            public long getVersion() {
                return 0L;
            }

            public boolean isCurrent() {
                return true;
            }

            public IndexCommit getIndexCommit() {
                return indexCommit;
            }

            protected void doClose() {
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        };
    }

    @SuppressForbidden(reason="we manage references explicitly here")
    private synchronized void onReaderClosed(IndexReader.CacheKey key) {
        if (this.lastOpenedReader != null && key == this.lastOpenedReader.getReaderCacheHelper().getKey()) {
            assert (this.lastOpenedReader.getRefCount() == 0);
            this.lastOpenedReader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized DirectoryReader getOrOpenReader() throws IOException {
        DirectoryReader directoryReader;
        block6: {
            DirectoryReader reader = null;
            boolean success = false;
            try {
                reader = this.getReader();
                if (reader == null) {
                    for (ReferenceManager.RefreshListener listeners : this.config().getInternalRefreshListener()) {
                        listeners.beforeRefresh();
                    }
                    reader = DirectoryReader.open((Directory)this.engineConfig.getStore().directory());
                    this.processReaders((IndexReader)reader, null);
                    reader = this.lastOpenedReader = this.wrapReader(reader, Function.identity());
                    reader.getReaderCacheHelper().addClosedListener(this::onReaderClosed);
                    for (ReferenceManager.RefreshListener listeners : this.config().getInternalRefreshListener()) {
                        listeners.afterRefresh(true);
                    }
                }
                success = true;
                directoryReader = reader;
                if (success) break block6;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.close((Closeable[])new Closeable[]{reader});
                }
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{reader});
        }
        return directoryReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="we manage references explicitly here")
    private synchronized DirectoryReader getReader() throws IOException {
        DirectoryReader directoryReader;
        block4: {
            DirectoryReader reader = null;
            boolean success = false;
            try {
                if (this.lastOpenedReader != null && this.lastOpenedReader.tryIncRef()) {
                    reader = this.lastOpenedReader;
                }
                success = true;
                directoryReader = reader;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.close((Closeable[])new Closeable[]{reader});
                }
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{reader});
        }
        return directoryReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="we manage references explicitly here")
    public Engine.Searcher acquireSearcher(String source, Engine.SearcherScope scope) throws EngineException {
        this.store.incRef();
        boolean releaseRefeference = true;
        try {
            Engine.Searcher searcher;
            block33: {
                DirectoryReader reader;
                boolean maybeOpenReader;
                switch (source) {
                    case "load_seq_no": 
                    case "load_version": {
                        assert (false) : "this is a read-only engine";
                    }
                    case "doc_stats": {
                        assert (false) : "doc_stats are overwritten";
                    }
                    case "refresh_needed": {
                        assert (false) : "refresh_needed is always false";
                    }
                    case "segments": 
                    case "segments_stats": 
                    case "completion_stats": 
                    case "can_match": {
                        maybeOpenReader = false;
                        break;
                    }
                    default: {
                        maybeOpenReader = true;
                    }
                }
                DirectoryReader directoryReader = reader = maybeOpenReader ? this.getOrOpenReader() : this.getReader();
                if (reader == null) {
                    if ("can_match".equals(source)) {
                        this.canMatchReader.incRef();
                        Engine.Searcher searcher2 = new Engine.Searcher(source, new IndexSearcher((IndexReader)this.canMatchReader), () -> ((DirectoryReader)this.canMatchReader).decRef());
                        return searcher2;
                    }
                    Engine.Searcher searcher3 = super.acquireSearcher(source, scope);
                    return searcher3;
                }
                try {
                    LazyDirectoryReader lazyDirectoryReader = new LazyDirectoryReader(reader, this);
                    Engine.Searcher newSearcher = new Engine.Searcher(source, new IndexSearcher((IndexReader)lazyDirectoryReader), () -> {
                        Closeable[] closeableArray = new Closeable[2];
                        closeableArray[0] = lazyDirectoryReader;
                        closeableArray[1] = () -> ((Store)this.store).decRef();
                        IOUtils.close((Closeable[])closeableArray);
                    });
                    releaseRefeference = false;
                    searcher = newSearcher;
                    if (!releaseRefeference) break block33;
                }
                catch (Throwable throwable) {
                    try {
                        if (releaseRefeference) {
                            reader.decRef();
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                reader.decRef();
            }
            return searcher;
        }
        finally {
            if (releaseRefeference) {
                this.store.decRef();
            }
        }
    }

    static LazyDirectoryReader unwrapLazyReader(DirectoryReader reader) {
        while (reader instanceof FilterDirectoryReader) {
            if (reader instanceof LazyDirectoryReader) {
                return (LazyDirectoryReader)reader;
            }
            reader = ((FilterDirectoryReader)reader).getDelegate();
        }
        return null;
    }

    synchronized boolean isReaderOpen() {
        return this.lastOpenedReader != null;
    }

    static final class LazyLeafReader
    extends FilterLeafReader {
        private volatile LeafReader in;
        private final SegmentCommitInfo info;
        private final int numDocs;
        private final int maxDocs;

        private LazyLeafReader(LeafReader in) {
            super(Lucene.emptyReader((int)in.maxDoc()));
            this.info = Lucene.segmentReader((LeafReader)in).getSegmentInfo();
            this.in = in;
            this.numDocs = in.numDocs();
            this.maxDocs = in.maxDoc();
        }

        private void ensureOpenOrReleased() {
            this.ensureOpen();
            if (this.in == null) {
                throw new AlreadyClosedException("leaf is already released");
            }
        }

        public Bits getLiveDocs() {
            this.ensureOpenOrReleased();
            return this.in.getLiveDocs();
        }

        public FieldInfos getFieldInfos() {
            this.ensureOpenOrReleased();
            return this.in.getFieldInfos();
        }

        public PointValues getPointValues(String field) throws IOException {
            this.ensureOpenOrReleased();
            return this.in.getPointValues(field);
        }

        public Fields getTermVectors(int docID) throws IOException {
            this.ensureOpenOrReleased();
            return this.in.getTermVectors(docID);
        }

        public int numDocs() {
            return this.numDocs;
        }

        public int maxDoc() {
            return this.maxDocs;
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            this.ensureOpenOrReleased();
            this.in.document(docID, visitor);
        }

        protected void doClose() throws IOException {
            this.in.close();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            this.ensureOpenOrReleased();
            return this.in.getReaderCacheHelper();
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            this.ensureOpenOrReleased();
            return this.in.getCoreCacheHelper();
        }

        public Terms terms(String field) throws IOException {
            this.ensureOpenOrReleased();
            return this.in.terms(field);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("LazyLeafReader(");
            buffer.append(this.in);
            buffer.append(')');
            return buffer.toString();
        }

        public NumericDocValues getNumericDocValues(String field) throws IOException {
            this.ensureOpenOrReleased();
            return this.in.getNumericDocValues(field);
        }

        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            this.ensureOpenOrReleased();
            return this.in.getBinaryDocValues(field);
        }

        public SortedDocValues getSortedDocValues(String field) throws IOException {
            this.ensureOpenOrReleased();
            return this.in.getSortedDocValues(field);
        }

        public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
            this.ensureOpenOrReleased();
            return this.in.getSortedNumericDocValues(field);
        }

        public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
            this.ensureOpenOrReleased();
            return this.in.getSortedSetDocValues(field);
        }

        public NumericDocValues getNormValues(String field) throws IOException {
            this.ensureOpenOrReleased();
            return this.in.getNormValues(field);
        }

        public LeafMetaData getMetaData() {
            this.ensureOpenOrReleased();
            return this.in.getMetaData();
        }

        public void checkIntegrity() throws IOException {
            this.ensureOpenOrReleased();
            this.in.checkIntegrity();
        }

        public LeafReader getDelegate() {
            return this.in;
        }
    }

    static final class LazyDirectoryReader
    extends FilterDirectoryReader {
        private final FrozenEngine engine;
        private volatile DirectoryReader delegate;

        private LazyDirectoryReader(DirectoryReader reader, FrozenEngine engine) throws IOException {
            super(reader, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader reader) {
                    return new LazyLeafReader(reader);
                }
            });
            this.delegate = reader;
            this.engine = engine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressForbidden(reason="we manage references explicitly here")
        synchronized void release() throws IOException {
            if (this.delegate != null) {
                this.delegate.decRef();
                this.delegate = null;
                if (this.tryIncRef()) {
                    try {
                        for (LeafReaderContext leaf : this.leaves()) {
                            LazyLeafReader reader = (LazyLeafReader)leaf.reader();
                            reader.in = null;
                        }
                    }
                    finally {
                        this.decRef();
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void reset() throws IOException {
            boolean success = false;
            DirectoryReader reader = this.engine.getOrOpenReader();
            try {
                this.reset(reader);
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.close((Closeable[])new Closeable[]{reader});
                throw throwable;
            }
        }

        private synchronized void reset(DirectoryReader delegate) {
            if (this.delegate != null) {
                throw new AssertionError((Object)"lazy reader is not released");
            }
            assert (!(delegate instanceof LazyDirectoryReader)) : "must not be a LazyDirectoryReader";
            List leaves = delegate.leaves();
            int ord = 0;
            for (LeafReaderContext leaf : this.leaves()) {
                LazyLeafReader reader = (LazyLeafReader)leaf.reader();
                LeafReader newReader = ((LeafReaderContext)leaves.get(ord++)).reader();
                assert (reader.in == null);
                reader.in = newReader;
                assert (((LazyLeafReader)reader).info.info.equals((Object)Lucene.segmentReader((LeafReader)newReader).getSegmentInfo().info));
            }
            this.delegate = delegate;
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) {
            throw new UnsupportedOperationException();
        }

        void ensureOpenOrReset() {
            this.ensureOpen();
            if (this.delegate == null) {
                throw new AlreadyClosedException("delegate is released");
            }
        }

        public long getVersion() {
            this.ensureOpenOrReset();
            return this.delegate.getVersion();
        }

        public boolean isCurrent() throws IOException {
            this.ensureOpenOrReset();
            return this.delegate.isCurrent();
        }

        public IndexCommit getIndexCommit() throws IOException {
            this.ensureOpenOrReset();
            return this.delegate.getIndexCommit();
        }

        protected void doClose() throws IOException {
            this.release();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            this.ensureOpenOrReset();
            return this.delegate.getReaderCacheHelper();
        }

        public DirectoryReader getDelegate() {
            this.ensureOpenOrReset();
            return this.delegate;
        }
    }

    public static class ReacquireEngineSearcherListener
    implements SearchOperationListener {
        public void validateSearchContext(SearchContext context, TransportRequest transportRequest) {
            Engine.Searcher engineSearcher = context.searcher().getEngineSearcher();
            LazyDirectoryReader lazyDirectoryReader = FrozenEngine.unwrapLazyReader(engineSearcher.getDirectoryReader());
            if (lazyDirectoryReader != null) {
                try {
                    lazyDirectoryReader.reset();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                this.registerRelease(context, lazyDirectoryReader);
            }
        }

        private void registerRelease(SearchContext context, LazyDirectoryReader lazyDirectoryReader) {
            context.addReleasable(() -> {
                try {
                    lazyDirectoryReader.release();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }, SearchContext.Lifetime.PHASE);
        }

        public void onNewContext(SearchContext context) {
            Engine.Searcher engineSearcher = context.searcher().getEngineSearcher();
            LazyDirectoryReader lazyDirectoryReader = FrozenEngine.unwrapLazyReader(engineSearcher.getDirectoryReader());
            if (lazyDirectoryReader != null) {
                this.registerRelease(context, lazyDirectoryReader);
            }
        }
    }
}

