/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.sql.proto.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.proto.Protocol;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

public class SqlQueryRequest
extends AbstractSqlRequest {
    @Nullable
    private final String cursor;
    private final String query;
    private final TimeZone timeZone;
    private final int fetchSize;
    private final TimeValue requestTimeout;
    private final TimeValue pageTimeout;
    @Nullable
    private final ToXContent filter;
    private final List<SqlTypedParamValue> params;

    public SqlQueryRequest(String query, List<SqlTypedParamValue> params, TimeZone timeZone, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, ToXContent filter, String cursor, RequestInfo requestInfo) {
        super(requestInfo);
        this.query = query;
        this.params = params;
        this.timeZone = timeZone;
        this.fetchSize = fetchSize;
        this.requestTimeout = requestTimeout;
        this.pageTimeout = pageTimeout;
        this.filter = filter;
        this.cursor = cursor;
    }

    public SqlQueryRequest(String query, List<SqlTypedParamValue> params, ToXContent filter, TimeZone timeZone, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, RequestInfo requestInfo) {
        this(query, params, timeZone, fetchSize, requestTimeout, pageTimeout, filter, null, requestInfo);
    }

    public SqlQueryRequest(String cursor, TimeValue requestTimeout, TimeValue pageTimeout, RequestInfo requestInfo) {
        this("", Collections.emptyList(), Protocol.TIME_ZONE, 1000, requestTimeout, pageTimeout, null, cursor, requestInfo);
    }

    public String cursor() {
        return this.cursor;
    }

    public String query() {
        return this.query;
    }

    public List<SqlTypedParamValue> params() {
        return this.params;
    }

    public TimeZone timeZone() {
        return this.timeZone;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public TimeValue pageTimeout() {
        return this.pageTimeout;
    }

    public ToXContent filter() {
        return this.filter;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SqlQueryRequest that = (SqlQueryRequest)o;
        return this.fetchSize == that.fetchSize && Objects.equals(this.query, that.query) && Objects.equals(this.params, that.params) && Objects.equals(this.timeZone, that.timeZone) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.pageTimeout, that.pageTimeout) && Objects.equals(this.filter, that.filter) && Objects.equals(this.cursor, that.cursor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query, this.timeZone, this.fetchSize, this.requestTimeout, this.pageTimeout, this.filter, this.cursor);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.query != null) {
            builder.field("query", this.query);
        }
        builder.field("mode", this.mode().toString());
        if (this.clientId() != null) {
            builder.field("client_id", this.clientId());
        }
        if (!this.params.isEmpty()) {
            builder.startArray("params");
            for (SqlTypedParamValue val : this.params) {
                val.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.timeZone != null) {
            builder.field("time_zone", this.timeZone.getID());
        }
        if (this.fetchSize != 1000) {
            builder.field("fetch_size", this.fetchSize);
        }
        if (this.requestTimeout != Protocol.REQUEST_TIMEOUT) {
            builder.field("request_timeout", this.requestTimeout.getStringRep());
        }
        if (this.pageTimeout != Protocol.PAGE_TIMEOUT) {
            builder.field("page_timeout", this.pageTimeout.getStringRep());
        }
        if (this.filter != null) {
            builder.field("filter");
            this.filter.toXContent(builder, params);
        }
        if (this.cursor != null) {
            builder.field("cursor", this.cursor);
        }
        return builder;
    }
}

