/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.bucket.composite.RoundingValuesSource;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;
import org.joda.time.DateTimeZone;

public class DateHistogramValuesSourceBuilder
extends CompositeValuesSourceBuilder<DateHistogramValuesSourceBuilder> {
    static final String TYPE = "date_histogram";
    private static final ObjectParser<DateHistogramValuesSourceBuilder, Void> PARSER = new ObjectParser("date_histogram");
    private long interval = 0L;
    private DateTimeZone timeZone = null;
    private DateHistogramInterval dateHistogramInterval;

    static DateHistogramValuesSourceBuilder parse(String name, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new DateHistogramValuesSourceBuilder(name), null);
    }

    public DateHistogramValuesSourceBuilder(String name) {
        super(name, ValueType.DATE);
    }

    protected DateHistogramValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
        this.interval = in.readLong();
        this.dateHistogramInterval = in.readOptionalWriteable(DateHistogramInterval::new);
        if (in.readBoolean()) {
            this.timeZone = DateTimeZone.forID(in.readString());
        }
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeLong(this.interval);
        out.writeOptionalWriteable(this.dateHistogramInterval);
        boolean hasTimeZone = this.timeZone != null;
        out.writeBoolean(hasTimeZone);
        if (hasTimeZone) {
            out.writeString(this.timeZone.getID());
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.dateHistogramInterval == null) {
            builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.interval);
        } else {
            builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.dateHistogramInterval.toString());
        }
        if (this.timeZone != null) {
            builder.field("time_zone", this.timeZone.toString());
        }
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.interval, this.dateHistogramInterval, this.timeZone);
    }

    @Override
    protected boolean innerEquals(DateHistogramValuesSourceBuilder other) {
        return Objects.equals(this.interval, other.interval) && Objects.equals(this.dateHistogramInterval, other.dateHistogramInterval) && Objects.equals(this.timeZone, other.timeZone);
    }

    @Override
    public String type() {
        return TYPE;
    }

    public long interval() {
        return this.interval;
    }

    public DateHistogramValuesSourceBuilder interval(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("[interval] must be 1 or greater for [date_histogram] source");
        }
        this.interval = interval;
        return this;
    }

    public DateHistogramInterval dateHistogramInterval() {
        return this.dateHistogramInterval;
    }

    public DateHistogramValuesSourceBuilder dateHistogramInterval(DateHistogramInterval dateHistogramInterval) {
        if (dateHistogramInterval == null) {
            throw new IllegalArgumentException("[dateHistogramInterval] must not be null");
        }
        this.dateHistogramInterval = dateHistogramInterval;
        return this;
    }

    public DateHistogramValuesSourceBuilder timeZone(DateTimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("[timeZone] must not be null: [" + this.name + "]");
        }
        this.timeZone = timeZone;
        return this;
    }

    public DateTimeZone timeZone() {
        return this.timeZone;
    }

    private Rounding createRounding() {
        DateTimeUnit dateTimeUnit;
        Rounding.Builder tzRoundingBuilder = this.dateHistogramInterval != null ? ((dateTimeUnit = DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(this.dateHistogramInterval.toString())) != null ? Rounding.builder(dateTimeUnit) : Rounding.builder(TimeValue.parseTimeValue(this.dateHistogramInterval.toString(), null, this.getClass().getSimpleName() + ".interval"))) : Rounding.builder(TimeValue.timeValueMillis(this.interval));
        if (this.timeZone() != null) {
            tzRoundingBuilder.timeZone(this.timeZone());
        }
        Rounding rounding = tzRoundingBuilder.build();
        return rounding;
    }

    @Override
    protected CompositeValuesSourceConfig innerBuild(SearchContext context, ValuesSourceConfig<?> config) throws IOException {
        Rounding rounding = this.createRounding();
        Object orig = config.toValuesSource(context.getQueryShardContext());
        if (orig == null) {
            orig = ValuesSource.Numeric.EMPTY;
        }
        if (orig instanceof ValuesSource.Numeric) {
            ValuesSource.Numeric numeric = (ValuesSource.Numeric)orig;
            RoundingValuesSource vs = new RoundingValuesSource(numeric, rounding);
            DocValueFormat docValueFormat = this.format() == null ? DocValueFormat.RAW : config.format();
            MappedFieldType fieldType = config.fieldContext() != null ? config.fieldContext().fieldType() : null;
            return new CompositeValuesSourceConfig(this.name, fieldType, vs, docValueFormat, this.order(), this.missingBucket());
        }
        throw new IllegalArgumentException("invalid source, expected numeric, got " + orig.getClass().getSimpleName());
    }

    static {
        PARSER.declareString(CompositeValuesSourceBuilder::format, new ParseField("format", new String[0]));
        PARSER.declareField((histogram, interval) -> {
            if (interval instanceof Long) {
                histogram.interval((Long)interval);
            } else {
                histogram.dateHistogramInterval((DateHistogramInterval)interval);
            }
        }, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            return new DateHistogramInterval(p.text());
        }, Histogram.INTERVAL_FIELD, ObjectParser.ValueType.LONG);
        PARSER.declareField(DateHistogramValuesSourceBuilder::timeZone, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return DateTimeZone.forID(p.text());
            }
            return DateTimeZone.forOffsetHours(p.intValue());
        }, new ParseField("time_zone", new String[0]), ObjectParser.ValueType.LONG);
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER, ValueType.NUMERIC);
    }
}

