/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.node.ResponseCollectorService;
import org.elasticsearch.script.FieldScript;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.DefaultSearchContext;
import org.elasticsearch.search.SearchContextException;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.dfs.DfsPhase;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.fetch.subphase.DocValueFieldsContext;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;

public class SearchService
extends AbstractLifecycleComponent
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SearchService.class);
    public static final Setting<TimeValue> DEFAULT_KEEPALIVE_SETTING = Setting.positiveTimeSetting("search.default_keep_alive", TimeValue.timeValueMinutes(5L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> MAX_KEEPALIVE_SETTING = Setting.positiveTimeSetting("search.max_keep_alive", TimeValue.timeValueHours(24L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> KEEPALIVE_INTERVAL_SETTING = Setting.positiveTimeSetting("search.keep_alive_interval", TimeValue.timeValueMinutes(1L), Setting.Property.NodeScope);
    public static final Setting<Boolean> LOW_LEVEL_CANCELLATION_SETTING = Setting.boolSetting("search.low_level_cancellation", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final TimeValue NO_TIMEOUT = TimeValue.timeValueMillis(-1L);
    public static final Setting<TimeValue> DEFAULT_SEARCH_TIMEOUT_SETTING = Setting.timeSetting("search.default_search_timeout", NO_TIMEOUT, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS = Setting.boolSetting("search.default_allow_partial_results", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> MAX_OPEN_SCROLL_CONTEXT = Setting.intSetting("search.max_open_scroll_context", 500, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final ResponseCollectorService responseCollectorService;
    private final BigArrays bigArrays;
    private final DfsPhase dfsPhase = new DfsPhase();
    private final QueryPhase queryPhase;
    private final FetchPhase fetchPhase;
    private volatile long defaultKeepAlive;
    private volatile long maxKeepAlive;
    private volatile TimeValue defaultSearchTimeout;
    private volatile boolean defaultAllowPartialSearchResults;
    private volatile boolean lowLevelCancellation;
    private volatile int maxOpenScrollContext;
    private final Scheduler.Cancellable keepAliveReaper;
    private final AtomicLong idGenerator = new AtomicLong();
    private final ConcurrentMapLong<SearchContext> activeContexts = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    private final MultiBucketConsumerService multiBucketConsumerService;
    private final AtomicInteger openScrollContexts = new AtomicInteger();

    public SearchService(ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ScriptService scriptService, BigArrays bigArrays, FetchPhase fetchPhase, ResponseCollectorService responseCollectorService) {
        super(clusterService.getSettings());
        Settings settings = clusterService.getSettings();
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.responseCollectorService = responseCollectorService;
        this.bigArrays = bigArrays;
        this.queryPhase = new QueryPhase();
        this.fetchPhase = fetchPhase;
        this.multiBucketConsumerService = new MultiBucketConsumerService(clusterService, settings);
        TimeValue keepAliveInterval = KEEPALIVE_INTERVAL_SETTING.get(settings);
        this.setKeepAlives(DEFAULT_KEEPALIVE_SETTING.get(settings), MAX_KEEPALIVE_SETTING.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_KEEPALIVE_SETTING, MAX_KEEPALIVE_SETTING, this::setKeepAlives, this::validateKeepAlives);
        this.keepAliveReaper = threadPool.scheduleWithFixedDelay(new Reaper(), keepAliveInterval, "same");
        this.defaultSearchTimeout = DEFAULT_SEARCH_TIMEOUT_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_SEARCH_TIMEOUT_SETTING, this::setDefaultSearchTimeout);
        this.defaultAllowPartialSearchResults = DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS, this::setDefaultAllowPartialSearchResults);
        this.maxOpenScrollContext = MAX_OPEN_SCROLL_CONTEXT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_OPEN_SCROLL_CONTEXT, this::setMaxOpenScrollContext);
        this.lowLevelCancellation = LOW_LEVEL_CANCELLATION_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LOW_LEVEL_CANCELLATION_SETTING, this::setLowLevelCancellation);
    }

    private void validateKeepAlives(TimeValue defaultKeepAlive, TimeValue maxKeepAlive) {
        if (defaultKeepAlive.millis() > maxKeepAlive.millis()) {
            throw new IllegalArgumentException("Default keep alive setting for scroll [" + DEFAULT_KEEPALIVE_SETTING.getKey() + "] should be smaller than max keep alive [" + MAX_KEEPALIVE_SETTING.getKey() + "], was (" + defaultKeepAlive + " > " + maxKeepAlive + ")");
        }
    }

    private void setKeepAlives(TimeValue defaultKeepAlive, TimeValue maxKeepAlive) {
        this.validateKeepAlives(defaultKeepAlive, maxKeepAlive);
        this.defaultKeepAlive = defaultKeepAlive.millis();
        this.maxKeepAlive = maxKeepAlive.millis();
    }

    private void setDefaultSearchTimeout(TimeValue defaultSearchTimeout) {
        this.defaultSearchTimeout = defaultSearchTimeout;
    }

    private void setDefaultAllowPartialSearchResults(boolean defaultAllowPartialSearchResults) {
        this.defaultAllowPartialSearchResults = defaultAllowPartialSearchResults;
    }

    public boolean defaultAllowPartialSearchResults() {
        return this.defaultAllowPartialSearchResults;
    }

    private void setMaxOpenScrollContext(int maxOpenScrollContext) {
        this.maxOpenScrollContext = maxOpenScrollContext;
    }

    private void setLowLevelCancellation(Boolean lowLevelCancellation) {
        this.lowLevelCancellation = lowLevelCancellation;
    }

    @Override
    public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        if (reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED || reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.CLOSED) {
            this.freeAllContextForIndex(index);
        }
    }

    protected void putContext(SearchContext context) {
        SearchContext previous = this.activeContexts.put(context.id(), context);
        assert (previous == null);
    }

    protected SearchContext removeContext(long id) {
        return this.activeContexts.remove(id);
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        for (SearchContext context : this.activeContexts.values()) {
            this.freeContext(context.id());
        }
    }

    @Override
    protected void doClose() {
        this.doStop();
        this.keepAliveReaper.cancel();
    }

    public void executeDfsPhase(ShardSearchRequest request, final SearchTask task, final ActionListener<SearchPhaseResult> listener) {
        this.rewriteShardRequest(request, new ActionListener<ShardSearchRequest>(){

            @Override
            public void onResponse(ShardSearchRequest request) {
                try {
                    listener.onResponse(SearchService.this.executeDfsPhase(request, task));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private DfsSearchResult executeDfsPhase(ShardSearchRequest request, SearchTask task) throws IOException {
        SearchContext context = this.createAndPutContext(request);
        context.incRef();
        try {
            context.setTask(task);
            this.contextProcessing(context);
            this.dfsPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            DfsSearchResult dfsSearchResult = context.dfsResult();
            return dfsSearchResult;
        }
        catch (Exception e) {
            logger.trace("Dfs phase failed", (Throwable)e);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    private void loadOrExecuteQueryPhase(ShardSearchRequest request, SearchContext context) throws Exception {
        boolean canCache = this.indicesService.canCache(request, context);
        context.getQueryShardContext().freezeContext();
        if (canCache) {
            this.indicesService.loadIntoContext(request, context, this.queryPhase);
        } else {
            this.queryPhase.execute(context);
        }
    }

    public void executeQueryPhase(ShardSearchRequest request, final SearchTask task, final ActionListener<SearchPhaseResult> listener) {
        this.rewriteShardRequest(request, new ActionListener<ShardSearchRequest>(){

            @Override
            public void onResponse(ShardSearchRequest request) {
                try {
                    listener.onResponse(SearchService.this.executeQueryPhase(request, task));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private <T> void runAsync(long id, final Supplier<T> executable, final ActionListener<T> listener) {
        this.getExecutor(id).execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            @Override
            protected void doRun() {
                listener.onResponse(executable.get());
            }
        });
    }

    private SearchPhaseResult executeQueryPhase(ShardSearchRequest request, SearchTask task) throws IOException {
        SearchContext context = this.createAndPutContext(request);
        SearchOperationListener operationListener = context.indexShard().getSearchOperationListener();
        context.incRef();
        boolean queryPhaseSuccess = false;
        try {
            context.setTask(task);
            operationListener.onPreQueryPhase(context);
            long time = System.nanoTime();
            this.contextProcessing(context);
            this.loadOrExecuteQueryPhase(request, context);
            if (!context.queryResult().hasSearchContext() && context.scrollContext() == null) {
                this.freeContext(context.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            long afterQueryTime = System.nanoTime();
            queryPhaseSuccess = true;
            operationListener.onQueryPhase(context, afterQueryTime - time);
            if (request.numberOfShards() == 1) {
                QueryFetchSearchResult queryFetchSearchResult = this.executeFetchPhase(context, operationListener, afterQueryTime);
                return queryFetchSearchResult;
            }
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                Exception exception = e = e.getCause() == null || e.getCause() instanceof Exception ? (Exception)e.getCause() : new ElasticsearchException(e.getCause());
            }
            if (!queryPhaseSuccess) {
                operationListener.onFailedQueryPhase(context);
            }
            logger.trace("Query phase failed", (Throwable)e);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    private QueryFetchSearchResult executeFetchPhase(SearchContext context, SearchOperationListener operationListener, long afterQueryTime) {
        operationListener.onPreFetchPhase(context);
        try {
            this.shortcutDocIdsToLoad(context);
            this.fetchPhase.execute(context);
            if (this.fetchPhaseShouldFreeContext(context)) {
                this.freeContext(context.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
        }
        catch (Exception e) {
            operationListener.onFailedFetchPhase(context);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        operationListener.onFetchPhase(context, System.nanoTime() - afterQueryTime);
        return new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
    }

    public void executeQueryPhase(InternalScrollSearchRequest request, SearchTask task, ActionListener<ScrollQuerySearchResult> listener) {
        this.runAsync(request.id(), () -> {
            SearchContext context = this.findContext(request.id(), request);
            SearchOperationListener operationListener = context.indexShard().getSearchOperationListener();
            context.incRef();
            try {
                context.setTask(task);
                operationListener.onPreQueryPhase(context);
                long time = System.nanoTime();
                this.contextProcessing(context);
                this.processScroll(request, context);
                this.queryPhase.execute(context);
                this.contextProcessedSuccessfully(context);
                operationListener.onQueryPhase(context, System.nanoTime() - time);
                ScrollQuerySearchResult scrollQuerySearchResult = new ScrollQuerySearchResult(context.queryResult(), context.shardTarget());
                return scrollQuerySearchResult;
            }
            catch (Exception e) {
                operationListener.onFailedQueryPhase(context);
                logger.trace("Query phase failed", (Throwable)e);
                this.processFailure(context, e);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            finally {
                this.cleanContext(context);
            }
        }, listener);
    }

    public void executeQueryPhase(QuerySearchRequest request, SearchTask task, ActionListener<QuerySearchResult> listener) {
        this.runAsync(request.id(), () -> {
            SearchContext context = this.findContext(request.id(), request);
            context.setTask(task);
            IndexShard indexShard = context.indexShard();
            SearchOperationListener operationListener = indexShard.getSearchOperationListener();
            context.incRef();
            try {
                this.contextProcessing(context);
                context.searcher().setAggregatedDfs(request.dfs());
                operationListener.onPreQueryPhase(context);
                long time = System.nanoTime();
                this.queryPhase.execute(context);
                if (!context.queryResult().hasSearchContext() && context.scrollContext() == null) {
                    this.freeContext(context.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
                operationListener.onQueryPhase(context, System.nanoTime() - time);
                QuerySearchResult querySearchResult = context.queryResult();
                return querySearchResult;
            }
            catch (Exception e) {
                operationListener.onFailedQueryPhase(context);
                logger.trace("Query phase failed", (Throwable)e);
                this.processFailure(context, e);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            finally {
                this.cleanContext(context);
            }
        }, listener);
    }

    private boolean fetchPhaseShouldFreeContext(SearchContext context) {
        if (context.scrollContext() == null) {
            return true;
        }
        return context.scrollContext().scroll == null;
    }

    final Executor getExecutor(long id) {
        SearchContext context = this.activeContexts.get(id);
        if (context == null) {
            throw new SearchContextMissingException(id);
        }
        return this.getExecutor(context.indexShard());
    }

    private Executor getExecutor(IndexShard indexShard) {
        assert (indexShard != null);
        return this.threadPool.executor(indexShard.indexSettings().isSearchThrottled() ? "search_throttled" : "search");
    }

    public void executeFetchPhase(InternalScrollSearchRequest request, SearchTask task, ActionListener<ScrollQueryFetchSearchResult> listener) {
        this.runAsync(request.id(), () -> {
            SearchContext context = this.findContext(request.id(), request);
            context.incRef();
            try {
                context.setTask(task);
                this.contextProcessing(context);
                SearchOperationListener operationListener = context.indexShard().getSearchOperationListener();
                this.processScroll(request, context);
                operationListener.onPreQueryPhase(context);
                long time = System.nanoTime();
                try {
                    this.queryPhase.execute(context);
                }
                catch (Exception e) {
                    operationListener.onFailedQueryPhase(context);
                    throw ExceptionsHelper.convertToRuntime(e);
                }
                long afterQueryTime = System.nanoTime();
                operationListener.onQueryPhase(context, afterQueryTime - time);
                QueryFetchSearchResult fetchSearchResult = this.executeFetchPhase(context, operationListener, afterQueryTime);
                ScrollQueryFetchSearchResult scrollQueryFetchSearchResult = new ScrollQueryFetchSearchResult(fetchSearchResult, context.shardTarget());
                return scrollQueryFetchSearchResult;
            }
            catch (Exception e) {
                logger.trace("Fetch phase failed", (Throwable)e);
                this.processFailure(context, e);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            finally {
                this.cleanContext(context);
            }
        }, listener);
    }

    public void executeFetchPhase(ShardFetchRequest request, SearchTask task, ActionListener<FetchSearchResult> listener) {
        this.runAsync(request.id(), () -> {
            SearchContext context = this.findContext(request.id(), request);
            SearchOperationListener operationListener = context.indexShard().getSearchOperationListener();
            context.incRef();
            try {
                context.setTask(task);
                this.contextProcessing(context);
                if (request.lastEmittedDoc() != null) {
                    context.scrollContext().lastEmittedDoc = request.lastEmittedDoc();
                }
                context.docIdsToLoad(request.docIds(), 0, request.docIdsSize());
                operationListener.onPreFetchPhase(context);
                long time = System.nanoTime();
                this.fetchPhase.execute(context);
                if (this.fetchPhaseShouldFreeContext(context)) {
                    this.freeContext(request.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
                operationListener.onFetchPhase(context, System.nanoTime() - time);
                FetchSearchResult fetchSearchResult = context.fetchResult();
                return fetchSearchResult;
            }
            catch (Exception e) {
                operationListener.onFailedFetchPhase(context);
                logger.trace("Fetch phase failed", (Throwable)e);
                this.processFailure(context, e);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            finally {
                this.cleanContext(context);
            }
        }, listener);
    }

    private SearchContext findContext(long id, TransportRequest request) throws SearchContextMissingException {
        SearchContext context = this.activeContexts.get(id);
        if (context == null) {
            throw new SearchContextMissingException(id);
        }
        SearchOperationListener operationListener = context.indexShard().getSearchOperationListener();
        try {
            operationListener.validateSearchContext(context, request);
            return context;
        }
        catch (Exception e) {
            this.processFailure(context, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SearchContext createAndPutContext(ShardSearchRequest request) throws IOException {
        if (request.scroll() != null && this.openScrollContexts.get() >= this.maxOpenScrollContext) {
            throw new ElasticsearchException("Trying to create too many scroll contexts. Must be less than or equal to: [" + this.maxOpenScrollContext + "]. This limit can be set by changing the [" + MAX_OPEN_SCROLL_CONTEXT.getKey() + "] setting.", new Object[0]);
        }
        SearchContext context = this.createContext(request);
        boolean success = false;
        try {
            this.putContext(context);
            if (request.scroll() != null) {
                this.openScrollContexts.incrementAndGet();
                context.indexShard().getSearchOperationListener().onNewScrollContext(context);
            }
            context.indexShard().getSearchOperationListener().onNewContext(context);
            success = true;
            SearchContext searchContext = context;
            return searchContext;
        }
        finally {
            if (!success) {
                this.freeContext(context.id());
            }
        }
    }

    final SearchContext createContext(ShardSearchRequest request) throws IOException {
        DefaultSearchContext context = this.createSearchContext(request, this.defaultSearchTimeout);
        try {
            if (request.scroll() != null) {
                context.scrollContext(new ScrollContext());
                context.scrollContext().scroll = request.scroll();
            }
            this.parseSource(context, request.source());
            if (context.from() == -1) {
                context.from(0);
            }
            if (context.size() == -1) {
                context.size(10);
            }
            this.dfsPhase.preProcess(context);
            this.queryPhase.preProcess(context);
            this.fetchPhase.preProcess(context);
            long keepAlive = this.defaultKeepAlive;
            if (request.scroll() != null && request.scroll().keepAlive() != null) {
                keepAlive = request.scroll().keepAlive().millis();
            }
            this.contextScrollKeepAlive(context, keepAlive);
            context.lowLevelCancellation(this.lowLevelCancellation);
        }
        catch (Exception e) {
            context.close();
            throw ExceptionsHelper.convertToRuntime(e);
        }
        return context;
    }

    public DefaultSearchContext createSearchContext(ShardSearchRequest request, TimeValue timeout) throws IOException {
        return this.createSearchContext(request, timeout, true, "search");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DefaultSearchContext createSearchContext(ShardSearchRequest request, TimeValue timeout, boolean assertAsyncActions, String source) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(request.shardId().getId());
        SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().getId(), indexShard.shardId(), request.getClusterAlias(), OriginalIndices.NONE);
        Engine.Searcher engineSearcher = indexShard.acquireSearcher(source);
        DefaultSearchContext searchContext = new DefaultSearchContext(this.idGenerator.incrementAndGet(), request, shardTarget, engineSearcher, this.clusterService, indexService, indexShard, this.bigArrays, this.threadPool.estimatedTimeInMillisCounter(), timeout, this.fetchPhase, request.getClusterAlias(), this.clusterService.state().nodes().getMinNodeVersion());
        boolean success = false;
        try {
            QueryShardContext context = new QueryShardContext(searchContext.getQueryShardContext());
            Rewriteable.rewrite(request.getRewriteable(), context, assertAsyncActions);
            assert (searchContext.getQueryShardContext().isCachable());
            success = true;
            if (success) return searchContext;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(searchContext);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(searchContext);
        return searchContext;
    }

    private void freeAllContextForIndex(Index index) {
        assert (index != null);
        for (SearchContext ctx : this.activeContexts.values()) {
            if (!index.equals(ctx.indexShard().shardId().getIndex())) continue;
            this.freeContext(ctx.id());
        }
    }

    public boolean freeContext(long id) {
        try (SearchContext context = this.removeContext(id);){
            if (context != null) {
                assert (context.refCount() > 0) : " refCount must be > 0: " + context.refCount();
                context.indexShard().getSearchOperationListener().onFreeContext(context);
                if (context.scrollContext() != null) {
                    this.openScrollContexts.decrementAndGet();
                    context.indexShard().getSearchOperationListener().onFreeScrollContext(context);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public void freeAllScrollContexts() {
        for (SearchContext searchContext : this.activeContexts.values()) {
            if (searchContext.scrollContext() == null) continue;
            this.freeContext(searchContext.id());
        }
    }

    private void contextScrollKeepAlive(SearchContext context, long keepAlive) throws IOException {
        if (keepAlive > this.maxKeepAlive) {
            throw new IllegalArgumentException("Keep alive for scroll (" + TimeValue.timeValueMillis(keepAlive) + ") is too large. It must be less than (" + TimeValue.timeValueMillis(this.maxKeepAlive) + "). This limit can be set by changing the [" + MAX_KEEPALIVE_SETTING.getKey() + "] cluster level setting.");
        }
        context.keepAlive(keepAlive);
    }

    private void contextProcessing(SearchContext context) {
        context.accessed(-1L);
    }

    private void contextProcessedSuccessfully(SearchContext context) {
        context.accessed(this.threadPool.relativeTimeInMillis());
    }

    private void cleanContext(SearchContext context) {
        try {
            context.clearReleasables(SearchContext.Lifetime.PHASE);
            context.setTask(null);
        }
        finally {
            context.decRef();
        }
    }

    private void processFailure(SearchContext context, Exception e) {
        this.freeContext(context.id());
        try {
            if (Lucene.isCorruptionException(e)) {
                context.indexShard().failShard("search execution corruption failure", e);
            }
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.warn("failed to process shard failure to (potentially) send back shard failure on corruption", (Throwable)inner);
        }
    }

    private void parseSource(DefaultSearchContext context, SearchSourceBuilder source) throws SearchContextException {
        if (source == null) {
            return;
        }
        QueryShardContext queryShardContext = context.getQueryShardContext();
        context.from(source.from());
        context.size(source.size());
        HashMap<String, InnerHitContextBuilder> innerHitBuilders = new HashMap<String, InnerHitContextBuilder>();
        if (source.query() != null) {
            InnerHitContextBuilder.extractInnerHits(source.query(), innerHitBuilders);
            context.parsedQuery(queryShardContext.toQuery(source.query()));
        }
        if (source.postFilter() != null) {
            InnerHitContextBuilder.extractInnerHits(source.postFilter(), innerHitBuilders);
            context.parsedPostFilter(queryShardContext.toQuery(source.postFilter()));
        }
        if (innerHitBuilders.size() > 0) {
            for (Map.Entry entry : innerHitBuilders.entrySet()) {
                try {
                    ((InnerHitContextBuilder)entry.getValue()).build(context, context.innerHits());
                }
                catch (IOException e) {
                    throw new SearchContextException(context, "failed to build inner_hits", (Throwable)e);
                }
            }
        }
        if (source.sorts() != null) {
            try {
                Optional<SortAndFormats> optionalSort = SortBuilder.buildSort(source.sorts(), context.getQueryShardContext());
                if (optionalSort.isPresent()) {
                    context.sort(optionalSort.get());
                }
            }
            catch (IOException e) {
                throw new SearchContextException(context, "failed to create sort elements", (Throwable)e);
            }
        }
        context.trackScores(source.trackScores());
        if (!source.trackTotalHits() && context.scrollContext() != null) {
            throw new SearchContextException(context, "disabling [track_total_hits] is not allowed in a scroll context");
        }
        context.trackTotalHits(source.trackTotalHits());
        if (source.minScore() != null) {
            context.minimumScore(source.minScore().floatValue());
        }
        if (source.profile()) {
            context.setProfilers(new Profilers(context.searcher()));
        }
        if (source.timeout() != null) {
            context.timeout(source.timeout());
        }
        context.terminateAfter(source.terminateAfter());
        if (source.aggregations() != null) {
            try {
                AggregatorFactories factories = source.aggregations().build(context, null);
                context.aggregations(new SearchContextAggregations(factories, this.multiBucketConsumerService.create()));
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Failed to create aggregators", e);
            }
        }
        if (source.suggest() != null) {
            try {
                context.suggest(source.suggest().build(queryShardContext));
            }
            catch (IOException e) {
                throw new SearchContextException(context, "failed to create SuggestionSearchContext", (Throwable)e);
            }
        }
        if (source.rescores() != null) {
            try {
                for (RescorerBuilder rescorerBuilder : source.rescores()) {
                    context.addRescore(rescorerBuilder.buildContext(queryShardContext));
                }
            }
            catch (IOException e) {
                throw new SearchContextException(context, "failed to create RescoreSearchContext", (Throwable)e);
            }
        }
        if (source.explain() != null) {
            context.explain(source.explain());
        }
        if (source.fetchSource() != null) {
            context.fetchSourceContext(source.fetchSource());
        }
        if (source.docValueFields() != null) {
            ArrayList<DocValueFieldsContext.FieldAndFormat> docValueFields = new ArrayList<DocValueFieldsContext.FieldAndFormat>();
            for (DocValueFieldsContext.FieldAndFormat format : source.docValueFields()) {
                Collection<String> fieldNames = context.mapperService().simpleMatchToFullName(format.field);
                for (String fieldName : fieldNames) {
                    docValueFields.add(new DocValueFieldsContext.FieldAndFormat(fieldName, format.format));
                }
            }
            int n = context.mapperService().getIndexSettings().getMaxDocvalueFields();
            if (docValueFields.size() > n) {
                throw new IllegalArgumentException("Trying to retrieve too many docvalue_fields. Must be less than or equal to: [" + n + "] but was [" + docValueFields.size() + "]. This limit can be set by changing the [" + IndexSettings.MAX_DOCVALUE_FIELDS_SEARCH_SETTING.getKey() + "] index level setting.");
            }
            context.docValueFieldsContext(new DocValueFieldsContext(docValueFields));
        }
        if (source.highlighter() != null) {
            HighlightBuilder highlightBuilder = source.highlighter();
            try {
                context.highlight(highlightBuilder.build(queryShardContext));
            }
            catch (IOException iOException) {
                throw new SearchContextException(context, "failed to create SearchContextHighlighter", (Throwable)iOException);
            }
        }
        if (source.scriptFields() != null && source.size() != 0) {
            int maxAllowedScriptFields = context.mapperService().getIndexSettings().getMaxScriptFields();
            if (source.scriptFields().size() > maxAllowedScriptFields) {
                throw new IllegalArgumentException("Trying to retrieve too many script_fields. Must be less than or equal to: [" + maxAllowedScriptFields + "] but was [" + source.scriptFields().size() + "]. This limit can be set by changing the [" + IndexSettings.MAX_SCRIPT_FIELDS_SETTING.getKey() + "] index level setting.");
            }
            for (SearchSourceBuilder.ScriptField field : source.scriptFields()) {
                FieldScript.Factory factory = this.scriptService.compile(field.script(), FieldScript.CONTEXT);
                FieldScript.LeafFactory searchScript = factory.newFactory(field.script().getParams(), context.lookup());
                context.scriptFields().add(new ScriptFieldsContext.ScriptField(field.fieldName(), searchScript, field.ignoreFailure()));
            }
        }
        if (source.ext() != null) {
            for (SearchExtBuilder searchExtBuilder : source.ext()) {
                context.addSearchExt(searchExtBuilder);
            }
        }
        if (source.version() != null) {
            context.version(source.version());
        }
        if (source.stats() != null) {
            context.groupStats(source.stats());
        }
        if (source.searchAfter() != null && source.searchAfter().length > 0) {
            if (context.scrollContext() != null) {
                throw new SearchContextException(context, "`search_after` cannot be used in a scroll context.");
            }
            if (context.from() > 0) {
                throw new SearchContextException(context, "`from` parameter must be set to 0 when `search_after` is used.");
            }
            FieldDoc fieldDoc = SearchAfterBuilder.buildFieldDoc(context.sort(), source.searchAfter());
            context.searchAfter(fieldDoc);
        }
        if (source.slice() != null) {
            if (context.scrollContext() == null) {
                throw new SearchContextException(context, "`slice` cannot be used outside of a scroll context");
            }
            context.sliceBuilder(source.slice());
        }
        if (source.storedFields() != null) {
            if (!source.storedFields().fetchFields()) {
                if (context.version()) {
                    throw new SearchContextException(context, "`stored_fields` cannot be disabled if version is requested");
                }
                if (context.sourceRequested()) {
                    throw new SearchContextException(context, "`stored_fields` cannot be disabled if _source is requested");
                }
            }
            context.storedFieldsContext(source.storedFields());
        }
        if (source.collapse() != null) {
            CollapseContext collapseContext = source.collapse().build(context);
            context.collapse(collapseContext);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void shortcutDocIdsToLoad(SearchContext context) {
        int[] docIdsToLoad;
        TopDocs topDocs;
        List<Object> completionSuggestions;
        int docsOffset = 0;
        Suggest suggest = context.queryResult().suggest();
        int numSuggestDocs = 0;
        if (suggest != null && suggest.hasScoreDocs()) {
            completionSuggestions = suggest.filter(CompletionSuggestion.class);
            for (CompletionSuggestion completionSuggestion : completionSuggestions) {
                numSuggestDocs += completionSuggestion.getOptions().size();
            }
        } else {
            completionSuggestions = Collections.emptyList();
        }
        if (context.request().scroll() != null) {
            void var8_9;
            topDocs = context.queryResult().topDocs().topDocs;
            docIdsToLoad = new int[topDocs.scoreDocs.length + numSuggestDocs];
            boolean bl = false;
            while (var8_9 < topDocs.scoreDocs.length) {
                docIdsToLoad[docsOffset++] = topDocs.scoreDocs[var8_9].doc;
                ++var8_9;
            }
        } else {
            topDocs = context.queryResult().topDocs().topDocs;
            if (topDocs.scoreDocs.length < context.from()) {
                docIdsToLoad = new int[numSuggestDocs];
            } else {
                int n = context.from() + context.size();
                docIdsToLoad = new int[Math.min(topDocs.scoreDocs.length - context.from(), context.size()) + numSuggestDocs];
                for (int i = context.from(); i < Math.min(n, topDocs.scoreDocs.length); ++i) {
                    docIdsToLoad[docsOffset++] = topDocs.scoreDocs[i].doc;
                }
            }
        }
        for (CompletionSuggestion completionSuggestion : completionSuggestions) {
            for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                docIdsToLoad[docsOffset++] = option.getDoc().doc;
            }
        }
        context.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
    }

    private void processScroll(InternalScrollSearchRequest request, SearchContext context) throws IOException {
        context.from(context.from() + context.size());
        context.scrollContext().scroll = request.scroll();
        if (request.scroll() != null && request.scroll().keepAlive() != null) {
            this.contextScrollKeepAlive(context, request.scroll().keepAlive().millis());
        }
    }

    public int getActiveContexts() {
        return this.activeContexts.size();
    }

    public ResponseCollectorService getResponseCollectorService() {
        return this.responseCollectorService;
    }

    public AliasFilter buildAliasFilter(ClusterState state, String index, String ... expressions) {
        return this.indicesService.buildAliasFilter(state, index, expressions);
    }

    public boolean canMatch(ShardSearchRequest request) throws IOException {
        assert (request.searchType() == SearchType.QUERY_THEN_FETCH) : "unexpected search type: " + (Object)((Object)request.searchType());
        try (DefaultSearchContext context = this.createSearchContext(request, this.defaultSearchTimeout, false, "can_match");){
            SearchSourceBuilder source = context.request().source();
            if (SearchService.canRewriteToMatchNone(source)) {
                QueryBuilder queryBuilder = source.query();
                boolean bl = !(queryBuilder instanceof MatchNoneQueryBuilder);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public void canMatch(ShardSearchRequest request, ActionListener<CanMatchResponse> listener) {
        try {
            listener.onResponse(new CanMatchResponse(this.canMatch(request)));
        }
        catch (IOException e) {
            listener.onFailure(e);
        }
    }

    public static boolean canRewriteToMatchNone(SearchSourceBuilder source) {
        if (source == null || source.query() == null || source.query() instanceof MatchAllQueryBuilder || source.suggest() != null) {
            return false;
        }
        AggregatorFactories.Builder aggregations = source.aggregations();
        return aggregations == null || !aggregations.mustVisitAllDocs();
    }

    private void rewriteShardRequest(final ShardSearchRequest request, final ActionListener<ShardSearchRequest> listener) {
        IndexShard shard = this.indicesService.indexServiceSafe(request.shardId().getIndex()).getShard(request.shardId().id());
        Executor executor = this.getExecutor(shard);
        ActionListener<Rewriteable> actionListener = ActionListener.wrap(r -> shard.awaitShardSearchActive(b -> executor.execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            @Override
            protected void doRun() {
                listener.onResponse(request);
            }
        })), listener::onFailure);
        Rewriteable.rewriteAndFetch(request.getRewriteable(), this.indicesService.getRewriteContext(request::nowInMillis), actionListener);
    }

    public QueryRewriteContext getRewriteContext(LongSupplier nowInMillis) {
        return this.indicesService.getRewriteContext(nowInMillis);
    }

    public IndicesService getIndicesService() {
        return this.indicesService;
    }

    public InternalAggregation.ReduceContext createReduceContext(boolean finalReduce) {
        return new InternalAggregation.ReduceContext(this.bigArrays, this.scriptService, finalReduce ? this.multiBucketConsumerService.create() : bucketCount -> {}, finalReduce);
    }

    public static final class CanMatchResponse
    extends SearchPhaseResult {
        private boolean canMatch;

        public CanMatchResponse(StreamInput in) throws IOException {
            this.canMatch = in.readBoolean();
        }

        public CanMatchResponse(boolean canMatch) {
            this.canMatch = canMatch;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.canMatch = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.canMatch);
        }

        public boolean canMatch() {
            return this.canMatch;
        }
    }

    class Reaper
    implements Runnable {
        Reaper() {
        }

        @Override
        public void run() {
            long time = SearchService.this.threadPool.relativeTimeInMillis();
            for (SearchContext context : SearchService.this.activeContexts.values()) {
                long lastAccessTime = context.lastAccessTime();
                if (lastAccessTime == -1L || time - lastAccessTime <= context.keepAlive()) continue;
                logger.debug("freeing search context [{}], time [{}], lastAccessTime [{}], keepAlive [{}]", (Object)context.id(), (Object)time, (Object)lastAccessTime, (Object)context.keepAlive());
                SearchService.this.freeContext(context.id());
            }
        }
    }
}

