/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.Version;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.node.Node;

public class DiscoveryNode
implements Writeable,
ToXContentFragment {
    static final String COORDINATING_ONLY = "coordinating_only";
    private final String nodeName;
    private final String nodeId;
    private final String ephemeralId;
    private final String hostName;
    private final String hostAddress;
    private final TransportAddress address;
    private final Map<String, String> attributes;
    private final Version version;
    private final Set<Role> roles;

    public static boolean nodeRequiresLocalStorage(Settings settings) {
        boolean localStorageEnable = Node.NODE_LOCAL_STORAGE_SETTING.get(settings);
        if (!localStorageEnable && (Node.NODE_DATA_SETTING.get(settings).booleanValue() || Node.NODE_MASTER_SETTING.get(settings).booleanValue())) {
            throw new IllegalArgumentException("storage can not be disabled for master and data nodes");
        }
        return localStorageEnable;
    }

    public static boolean isMasterNode(Settings settings) {
        return Node.NODE_MASTER_SETTING.get(settings);
    }

    public static boolean isDataNode(Settings settings) {
        return Node.NODE_DATA_SETTING.get(settings);
    }

    public static boolean isIngestNode(Settings settings) {
        return Node.NODE_INGEST_SETTING.get(settings);
    }

    public DiscoveryNode(String id, TransportAddress address, Version version) {
        this(id, address, Collections.emptyMap(), EnumSet.allOf(Role.class), version);
    }

    public DiscoveryNode(String id, TransportAddress address, Map<String, String> attributes, Set<Role> roles, Version version) {
        this("", id, address, attributes, roles, version);
    }

    public DiscoveryNode(String nodeName, String nodeId, TransportAddress address, Map<String, String> attributes, Set<Role> roles, Version version) {
        this(nodeName, nodeId, UUIDs.randomBase64UUID(), address.address().getHostString(), address.getAddress(), address, attributes, roles, version);
    }

    public DiscoveryNode(String nodeName, String nodeId, String ephemeralId, String hostName, String hostAddress, TransportAddress address, Map<String, String> attributes, Set<Role> roles, Version version) {
        this.nodeName = nodeName != null ? nodeName.intern() : "";
        this.nodeId = nodeId.intern();
        this.ephemeralId = ephemeralId.intern();
        this.hostName = hostName.intern();
        this.hostAddress = hostAddress.intern();
        this.address = address;
        this.version = version == null ? Version.CURRENT : version;
        this.attributes = Collections.unmodifiableMap(attributes);
        Predicate<Map> predicate = attrs -> {
            for (Role role : Role.values()) {
                assert (!attrs.containsKey(role.getRoleName()));
            }
            return true;
        };
        assert (predicate.test(attributes));
        EnumSet<Role> rolesSet = EnumSet.noneOf(Role.class);
        rolesSet.addAll(roles);
        this.roles = Collections.unmodifiableSet(rolesSet);
    }

    public static DiscoveryNode createLocal(Settings settings, TransportAddress publishAddress, String nodeId) {
        Map<String, String> attributes = Node.NODE_ATTRIBUTES.getAsMap(settings);
        Set<Role> roles = DiscoveryNode.getRolesFromSettings(settings);
        return new DiscoveryNode(Node.NODE_NAME_SETTING.get(settings), nodeId, publishAddress, attributes, roles, Version.CURRENT);
    }

    public static Set<Role> getRolesFromSettings(Settings settings) {
        EnumSet<Role> roles = EnumSet.noneOf(Role.class);
        if (Node.NODE_INGEST_SETTING.get(settings).booleanValue()) {
            roles.add(Role.INGEST);
        }
        if (Node.NODE_MASTER_SETTING.get(settings).booleanValue()) {
            roles.add(Role.MASTER);
        }
        if (Node.NODE_DATA_SETTING.get(settings).booleanValue()) {
            roles.add(Role.DATA);
        }
        return roles;
    }

    public DiscoveryNode(StreamInput in) throws IOException {
        this.nodeName = in.readString().intern();
        this.nodeId = in.readString().intern();
        this.ephemeralId = in.readString().intern();
        this.hostName = in.readString().intern();
        this.hostAddress = in.readString().intern();
        this.address = new TransportAddress(in);
        int size = in.readVInt();
        this.attributes = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            this.attributes.put(in.readString(), in.readString());
        }
        int rolesSize = in.readVInt();
        this.roles = EnumSet.noneOf(Role.class);
        for (int i = 0; i < rolesSize; ++i) {
            this.roles.add(in.readEnum(Role.class));
        }
        this.version = Version.readVersion(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeName);
        out.writeString(this.nodeId);
        out.writeString(this.ephemeralId);
        out.writeString(this.hostName);
        out.writeString(this.hostAddress);
        this.address.writeTo(out);
        out.writeVInt(this.attributes.size());
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeVInt(this.roles.size());
        for (Role role : this.roles) {
            out.writeEnum(role);
        }
        Version.writeVersion(this.version, out);
    }

    public TransportAddress getAddress() {
        return this.address;
    }

    public String getId() {
        return this.nodeId;
    }

    public String getEphemeralId() {
        return this.ephemeralId;
    }

    public String getName() {
        return this.nodeName;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isDataNode() {
        return this.roles.contains((Object)Role.DATA);
    }

    public boolean isMasterNode() {
        return this.roles.contains((Object)Role.MASTER);
    }

    public boolean isIngestNode() {
        return this.roles.contains((Object)Role.INGEST);
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryNode that = (DiscoveryNode)o;
        return this.ephemeralId.equals(that.ephemeralId);
    }

    public int hashCode() {
        return this.ephemeralId.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.nodeName.length() > 0) {
            sb.append('{').append(this.nodeName).append('}');
        }
        sb.append('{').append(this.nodeId).append('}');
        sb.append('{').append(this.ephemeralId).append('}');
        sb.append('{').append(this.hostName).append('}');
        sb.append('{').append(this.address).append('}');
        if (!this.attributes.isEmpty()) {
            sb.append(this.attributes);
        }
        return sb.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getId());
        builder.field("name", this.getName());
        builder.field("ephemeral_id", this.getEphemeralId());
        builder.field("transport_address", this.getAddress().toString());
        builder.startObject("attributes");
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static enum Role {
        MASTER("master", "m"),
        DATA("data", "d"),
        INGEST("ingest", "i");

        private final String roleName;
        private final String abbreviation;

        private Role(String roleName, String abbreviation) {
            this.roleName = roleName;
            this.abbreviation = abbreviation;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }
    }
}

