/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.indexlifecycle.ErrorStep;
import org.elasticsearch.xpack.core.indexlifecycle.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleExecutionState;
import org.elasticsearch.xpack.core.indexlifecycle.LifecyclePolicy;
import org.elasticsearch.xpack.core.indexlifecycle.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.indexlifecycle.Phase;
import org.elasticsearch.xpack.core.indexlifecycle.PhaseExecutionInfo;
import org.elasticsearch.xpack.core.indexlifecycle.Step;
import org.elasticsearch.xpack.indexlifecycle.LifecyclePolicySecurityClient;

public class PolicyStepsRegistry {
    private static final Logger logger = LogManager.getLogger(PolicyStepsRegistry.class);
    private final Client client;
    private final SortedMap<String, LifecyclePolicyMetadata> lifecyclePolicyMap;
    private final Map<String, Step> firstStepMap;
    private final Map<String, Map<Step.StepKey, Step>> stepMap;
    private final NamedXContentRegistry xContentRegistry;

    public PolicyStepsRegistry(NamedXContentRegistry xContentRegistry, Client client) {
        this(new TreeMap<String, LifecyclePolicyMetadata>(), new HashMap<String, Step>(), new HashMap<String, Map<Step.StepKey, Step>>(), xContentRegistry, client);
    }

    PolicyStepsRegistry(SortedMap<String, LifecyclePolicyMetadata> lifecyclePolicyMap, Map<String, Step> firstStepMap, Map<String, Map<Step.StepKey, Step>> stepMap, NamedXContentRegistry xContentRegistry, Client client) {
        this.lifecyclePolicyMap = lifecyclePolicyMap;
        this.firstStepMap = firstStepMap;
        this.stepMap = stepMap;
        this.xContentRegistry = xContentRegistry;
        this.client = client;
    }

    SortedMap<String, LifecyclePolicyMetadata> getLifecyclePolicyMap() {
        return this.lifecyclePolicyMap;
    }

    Map<String, Step> getFirstStepMap() {
        return this.firstStepMap;
    }

    Map<String, Map<Step.StepKey, Step>> getStepMap() {
        return this.stepMap;
    }

    public void update(ClusterState clusterState) {
        DiffableUtils.MapDiff diff;
        IndexLifecycleMetadata meta = (IndexLifecycleMetadata)clusterState.metaData().custom("index_lifecycle");
        assert (meta != null) : "IndexLifecycleMetadata cannot be null when updating the policy steps registry";
        DiffableUtils.MapDiff mapDiff = diff = DiffableUtils.diff(this.lifecyclePolicyMap, (Map)meta.getPolicyMetadatas(), (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), (DiffableUtils.ValueSerializer)new DiffableUtils.NonDiffableValueSerializer<String, LifecyclePolicyMetadata>(){

            public void write(LifecyclePolicyMetadata value, StreamOutput out) {
                throw new UnsupportedOperationException("should never be called");
            }

            public LifecyclePolicyMetadata read(StreamInput in, String key) {
                throw new UnsupportedOperationException("should never be called");
            }
        });
        for (String deletedPolicyName : mapDiff.getDeletes()) {
            this.lifecyclePolicyMap.remove(deletedPolicyName);
            this.firstStepMap.remove(deletedPolicyName);
            this.stepMap.remove(deletedPolicyName);
        }
        if (!mapDiff.getUpserts().isEmpty()) {
            for (LifecyclePolicyMetadata policyMetadata : mapDiff.getUpserts().values()) {
                LifecyclePolicySecurityClient policyClient = new LifecyclePolicySecurityClient(this.client, "index_lifecycle", policyMetadata.getHeaders());
                this.lifecyclePolicyMap.put(policyMetadata.getName(), policyMetadata);
                List policyAsSteps = policyMetadata.getPolicy().toSteps((Client)policyClient);
                if (policyAsSteps.isEmpty()) continue;
                this.firstStepMap.put(policyMetadata.getName(), (Step)policyAsSteps.get(0));
                HashMap<Step.StepKey, Step> stepMapForPolicy = new HashMap<Step.StepKey, Step>();
                for (Step step : policyAsSteps) {
                    assert (!"ERROR".equals(step.getKey().getName())) : "unexpected error step in policy";
                    stepMapForPolicy.put(step.getKey(), step);
                }
                logger.trace("updating cached steps for [{}] policy, new steps: {}", (Object)policyMetadata.getName(), stepMapForPolicy.keySet());
                this.stepMap.put(policyMetadata.getName(), stepMapForPolicy);
            }
        }
    }

    private List<Step> parseStepsFromPhase(String policy, String currentPhase, String phaseDef) throws IOException {
        LifecyclePolicy policyToExecute;
        LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)this.lifecyclePolicyMap.get(policy);
        if (policyMetadata == null) {
            throw new IllegalStateException("unable to parse steps for policy [" + policy + "] as it doesn't exist");
        }
        LifecyclePolicy currentPolicy = policyMetadata.getPolicy();
        if ("new".equals(phaseDef) || "completed".equals(phaseDef)) {
            policyToExecute = currentPolicy;
        } else {
            PhaseExecutionInfo phaseExecutionInfo;
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, phaseDef);){
                phaseExecutionInfo = PhaseExecutionInfo.parse((XContentParser)parser, (String)currentPhase);
            }
            HashMap<String, Phase> phaseMap = new HashMap<String, Phase>(currentPolicy.getPhases());
            if (phaseExecutionInfo.getPhase() != null) {
                phaseMap.put(currentPhase, phaseExecutionInfo.getPhase());
            }
            policyToExecute = new LifecyclePolicy(currentPolicy.getType(), currentPolicy.getName(), phaseMap);
        }
        LifecyclePolicySecurityClient policyClient = new LifecyclePolicySecurityClient(this.client, "index_lifecycle", ((LifecyclePolicyMetadata)this.lifecyclePolicyMap.get(policy)).getHeaders());
        List steps = policyToExecute.toSteps((Client)policyClient);
        List<Object> phaseSteps = steps == null ? new ArrayList() : steps.stream().filter(e -> e.getKey().getPhase().equals(currentPhase)).collect(Collectors.toList());
        logger.trace("parsed steps for policy [{}] in phase [{}], definition: [{}], steps: [{}]", (Object)policy, (Object)currentPhase, (Object)phaseDef, phaseSteps);
        return phaseSteps;
    }

    @Nullable
    public Step getStep(IndexMetaData indexMetaData, Step.StepKey stepKey) {
        List<Step> phaseSteps;
        if ("ERROR".equals(stepKey.getName())) {
            return new ErrorStep(new Step.StepKey(stepKey.getPhase(), stepKey.getAction(), "ERROR"));
        }
        String phase = stepKey.getPhase();
        String policyName = indexMetaData.getSettings().get("index.lifecycle.name");
        Index index = indexMetaData.getIndex();
        if (policyName == null) {
            throw new IllegalArgumentException("failed to retrieve step " + stepKey + " as index [" + index.getName() + "] has no policy");
        }
        String phaseJson = Optional.ofNullable(LifecycleExecutionState.fromIndexMetadata((IndexMetaData)indexMetaData).getPhaseDefinition()).orElse("new");
        try {
            phaseSteps = this.parseStepsFromPhase(policyName, phase, phaseJson);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to load cached steps for " + stepKey, (Throwable)e, new Object[0]);
        }
        catch (XContentParseException parseErr) {
            throw new XContentParseException(parseErr.getLocation(), "failed to load steps for " + stepKey + " from [" + phaseJson + "]", (Exception)((Object)parseErr));
        }
        assert (phaseSteps.stream().allMatch(step -> step.getKey().getPhase().equals(phase))) : "expected phase steps loaded from phase definition for [" + index.getName() + "] to be in phase [" + phase + "] but they were not, steps: " + phaseSteps;
        return phaseSteps.stream().filter(step -> step.getKey().equals((Object)stepKey)).findFirst().orElse(null);
    }

    public boolean stepExists(String policy, Step.StepKey stepKey) {
        Map<Step.StepKey, Step> steps = this.stepMap.get(policy);
        if (steps == null) {
            return false;
        }
        return steps.containsKey(stepKey);
    }

    public boolean policyExists(String policy) {
        return this.lifecyclePolicyMap.containsKey(policy);
    }

    public Step getFirstStep(String policy) {
        return this.firstStepMap.get(policy);
    }

    public TimeValue getIndexAgeForPhase(String policy, String phase) {
        if ("new".equals(phase) || "completed".equals(phase)) {
            return TimeValue.ZERO;
        }
        LifecyclePolicyMetadata meta = (LifecyclePolicyMetadata)this.lifecyclePolicyMap.get(policy);
        if (meta == null) {
            throw new IllegalArgumentException("no policy found with name \"" + policy + "\"");
        }
        Phase retrievedPhase = (Phase)meta.getPolicy().getPhases().get(phase);
        if (retrievedPhase == null) {
            return TimeValue.ZERO;
        }
        return retrievedPhase.getMinimumAge();
    }
}

