/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.indexlifecycle.AllocateAction;
import org.elasticsearch.xpack.core.indexlifecycle.DeleteAction;
import org.elasticsearch.xpack.core.indexlifecycle.ForceMergeAction;
import org.elasticsearch.xpack.core.indexlifecycle.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleAction;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleSettings;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleType;
import org.elasticsearch.xpack.core.indexlifecycle.ReadOnlyAction;
import org.elasticsearch.xpack.core.indexlifecycle.RolloverAction;
import org.elasticsearch.xpack.core.indexlifecycle.ShrinkAction;
import org.elasticsearch.xpack.core.indexlifecycle.TimeseriesLifecycleType;
import org.elasticsearch.xpack.core.indexlifecycle.action.DeleteLifecycleAction;
import org.elasticsearch.xpack.core.indexlifecycle.action.ExplainLifecycleAction;
import org.elasticsearch.xpack.core.indexlifecycle.action.GetLifecycleAction;
import org.elasticsearch.xpack.core.indexlifecycle.action.GetStatusAction;
import org.elasticsearch.xpack.core.indexlifecycle.action.MoveToStepAction;
import org.elasticsearch.xpack.core.indexlifecycle.action.PutLifecycleAction;
import org.elasticsearch.xpack.core.indexlifecycle.action.RemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.core.indexlifecycle.action.RetryAction;
import org.elasticsearch.xpack.core.indexlifecycle.action.StartILMAction;
import org.elasticsearch.xpack.core.indexlifecycle.action.StopILMAction;
import org.elasticsearch.xpack.indexlifecycle.IndexLifecycleFeatureSet;
import org.elasticsearch.xpack.indexlifecycle.IndexLifecycleService;
import org.elasticsearch.xpack.indexlifecycle.action.RestDeleteLifecycleAction;
import org.elasticsearch.xpack.indexlifecycle.action.RestExplainLifecycleAction;
import org.elasticsearch.xpack.indexlifecycle.action.RestGetLifecycleAction;
import org.elasticsearch.xpack.indexlifecycle.action.RestGetStatusAction;
import org.elasticsearch.xpack.indexlifecycle.action.RestMoveToStepAction;
import org.elasticsearch.xpack.indexlifecycle.action.RestPutLifecycleAction;
import org.elasticsearch.xpack.indexlifecycle.action.RestRemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.indexlifecycle.action.RestRetryAction;
import org.elasticsearch.xpack.indexlifecycle.action.RestStartILMAction;
import org.elasticsearch.xpack.indexlifecycle.action.RestStopAction;
import org.elasticsearch.xpack.indexlifecycle.action.TransportDeleteLifecycleAction;
import org.elasticsearch.xpack.indexlifecycle.action.TransportExplainLifecycleAction;
import org.elasticsearch.xpack.indexlifecycle.action.TransportGetLifecycleAction;
import org.elasticsearch.xpack.indexlifecycle.action.TransportGetStatusAction;
import org.elasticsearch.xpack.indexlifecycle.action.TransportMoveToStepAction;
import org.elasticsearch.xpack.indexlifecycle.action.TransportPutLifecycleAction;
import org.elasticsearch.xpack.indexlifecycle.action.TransportRemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.indexlifecycle.action.TransportRetryAction;
import org.elasticsearch.xpack.indexlifecycle.action.TransportStartILMAction;
import org.elasticsearch.xpack.indexlifecycle.action.TransportStopILMAction;

public class IndexLifecycle
extends Plugin
implements ActionPlugin {
    private final SetOnce<IndexLifecycleService> indexLifecycleInitialisationService = new SetOnce();
    private Settings settings;
    private boolean enabled;
    private boolean transportClientMode;

    public IndexLifecycle(Settings settings) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.INDEX_LIFECYCLE_ENABLED.get(settings);
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.transportClientMode) {
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, IndexLifecycleFeatureSet.class));
        return modules;
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(LifecycleSettings.LIFECYCLE_POLL_INTERVAL_SETTING, LifecycleSettings.LIFECYCLE_NAME_SETTING, LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING, RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        if (!this.enabled || this.transportClientMode) {
            return Collections.emptyList();
        }
        this.indexLifecycleInitialisationService.set((Object)new IndexLifecycleService(this.settings, client, clusterService, this.getClock(), System::currentTimeMillis, xContentRegistry));
        return Collections.singletonList(this.indexLifecycleInitialisationService.get());
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Arrays.asList(new NamedWriteableRegistry.Entry[0]);
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Arrays.asList(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("index_lifecycle", new String[0]), parser -> (MetaData.Custom)IndexLifecycleMetadata.PARSER.parse(parser, null)), new NamedXContentRegistry.Entry(LifecycleType.class, new ParseField("timeseries", new String[0]), (p, c) -> TimeseriesLifecycleType.INSTANCE), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("allocate", new String[0]), AllocateAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("forcemerge", new String[0]), ForceMergeAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("readonly", new String[0]), ReadOnlyAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("rollover", new String[0]), RolloverAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("shrink", new String[0]), ShrinkAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("delete", new String[0]), DeleteAction::parse));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestPutLifecycleAction(settings, restController), new RestGetLifecycleAction(settings, restController), new RestDeleteLifecycleAction(settings, restController), new RestExplainLifecycleAction(settings, restController), new RestRemoveIndexLifecyclePolicyAction(settings, restController), new RestMoveToStepAction(settings, restController), new RestRetryAction(settings, restController), new RestStopAction(settings, restController), new RestStartILMAction(settings, restController), new RestGetStatusAction(settings, restController)});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((Action)PutLifecycleAction.INSTANCE, TransportPutLifecycleAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)GetLifecycleAction.INSTANCE, TransportGetLifecycleAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)DeleteLifecycleAction.INSTANCE, TransportDeleteLifecycleAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)ExplainLifecycleAction.INSTANCE, TransportExplainLifecycleAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)RemoveIndexLifecyclePolicyAction.INSTANCE, TransportRemoveIndexLifecyclePolicyAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)MoveToStepAction.INSTANCE, TransportMoveToStepAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)RetryAction.INSTANCE, TransportRetryAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)StartILMAction.INSTANCE, TransportStartILMAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)StopILMAction.INSTANCE, TransportStopILMAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)GetStatusAction.INSTANCE, TransportGetStatusAction.class, new Class[0]));
    }

    public void close() {
        IndexLifecycleService lifecycleService = (IndexLifecycleService)this.indexLifecycleInitialisationService.get();
        if (lifecycleService != null) {
            lifecycleService.close();
        }
    }
}

